/*
 * Decompiled with CFR 0.152.
 */
package com.xsj.crasheye.session;

import android.content.Context;
import com.xsj.crasheye.ActionEvent;
import com.xsj.crasheye.dao.SessionDao;
import com.xsj.crasheye.dao.impl.SessionDaoImpl;
import com.xsj.crasheye.db.CrasheyeDatabase;
import com.xsj.crasheye.log.Logger;
import com.xsj.crasheye.session.Session;
import java.util.List;

public class SessionStorage {
    private SessionDao mSessionDao = null;

    private void ensureSessionDao(Context context) {
        if (this.mSessionDao == null) {
            this.mSessionDao = new SessionDaoImpl(CrasheyeDatabase.getOpenHelper(context));
        }
    }

    public Session newSession(int sessionType) {
        ActionEvent event = ActionEvent.createPing(sessionType);
        Session session = new Session();
        session.set_id(0L);
        session.setSessionId(event.getSessionId());
        session.setType(sessionType);
        session.setCreatedAt(System.currentTimeMillis());
        session.setJson(event.toJsonLine());
        return session;
    }

    public boolean save(Context context, Session session) {
        this.ensureSessionDao(context);
        boolean success = this.mSessionDao.save(session);
        Logger.logInfo("[Session] store new session into db, sessionId=" + session.getSessionId());
        return success;
    }

    public List<Session> findAll(Context context) {
        this.ensureSessionDao(context);
        List<Session> list = this.mSessionDao.findAll();
        if (list != null) {
            Logger.logInfo("[Session] find " + list.size() + " unSend sessions in db.");
        }
        return list;
    }

    public boolean delete(Context context, Session session) {
        this.ensureSessionDao(context);
        return this.mSessionDao.delete(session) > 0;
    }

    public boolean delete(Context context, List<Session> sessions) {
        this.ensureSessionDao(context);
        return this.mSessionDao.delete(sessions) > 0;
    }

    public int deleteAll(Context context) {
        this.ensureSessionDao(context);
        return this.mSessionDao.deleteAll();
    }
}

