/*
 * Decompiled with CFR 0.152.
 */
package com.xsj.crasheye.session;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import com.xsj.crasheye.ActionEvent;
import com.xsj.crasheye.NativeExceptionHandler;
import com.xsj.crasheye.NetSender;
import com.xsj.crasheye.NetSenderResponse;
import com.xsj.crasheye.log.Logger;
import com.xsj.crasheye.session.MergeSession;
import com.xsj.crasheye.session.MidnightTask;
import com.xsj.crasheye.session.Session;
import com.xsj.crasheye.session.SessionStorage;
import com.xsj.crasheye.session.SyncTask;
import com.xsj.crasheye.util.TaskManager;
import java.util.List;

public class SessionManager {
    private static final long BACKGROUND_THRESHOLD_MS = 30000L;
    public static final long SYNC_INTERVAL = 1800000L;
    public static final int FOREGROUND_UNKNOWN = 0;
    public static final int FOREGROUND_TRUE = 1;
    public static final int FOREGROUND_FALSE = 2;
    private static volatile SessionManager sInstance;
    private int mForeground = 0;
    private Application.ActivityLifecycleCallbacks mLifecycleCallbacks;
    private long mFirstLaunchTime = 0L;
    private long mLastLaunchTime = 0L;
    private long mLastResumeTime = 0L;
    private long mLastPauseTime = 0L;
    private boolean mSessionStarted = false;
    private SessionStorage mSessionStorage = new SessionStorage();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SessionManager getInstance() {
        if (sInstance != null) return sInstance;
        Class<SessionManager> clazz = SessionManager.class;
        synchronized (SessionManager.class) {
            if (sInstance != null) return sInstance;
            sInstance = new SessionManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    private SessionManager() {
    }

    public synchronized void startSession(Context context) {
        if (this.mSessionStarted) {
            Logger.logWarning("[Session] session already started.");
            return;
        }
        this.mSessionStarted = true;
        Application app = SessionManager.getApplication(context);
        if (app != null) {
            this.registerActivityLifecycleCallbacks(app);
        }
        Logger.logInfo("[Session] launch app once, application relaunch");
        this.mFirstLaunchTime = System.currentTimeMillis();
        this.createAndSaveNewSession(context, 2);
        this.startSyncTask(context.getApplicationContext());
        this.startMidnightTask(context.getApplicationContext());
    }

    public void createAndSaveNewSession(Context context, int sessionType) {
        if (context != null) {
            this.mLastLaunchTime = System.currentTimeMillis();
            this.mSessionStorage.save(context, this.mSessionStorage.newSession(sessionType));
        }
    }

    private static Application getApplication(Context context) {
        Application application = null;
        if (context != null) {
            if (context instanceof Activity) {
                application = ((Activity)context).getApplication();
            } else if (context instanceof Application) {
                application = (Application)context;
            } else {
                Context appContext = context.getApplicationContext();
                if (appContext instanceof Application) {
                    application = (Application)appContext;
                }
            }
        }
        return application;
    }

    private static String getActivityName(Activity activity) {
        if (activity != null) {
            return activity.getClass().getName();
        }
        return "UnknownActivity";
    }

    private void registerActivityLifecycleCallbacks(Application application) {
        if (Build.VERSION.SDK_INT >= 14) {
            try {
                if (this.mLifecycleCallbacks == null) {
                    this.mLifecycleCallbacks = new Application.ActivityLifecycleCallbacks(){

                        public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
                            String activityName = SessionManager.getActivityName(activity);
                            Logger.logInfo("[Session] " + activityName + " onCreate");
                        }

                        public void onActivityStarted(Activity activity) {
                        }

                        public void onActivityResumed(Activity activity) {
                            String activityName = SessionManager.getActivityName(activity);
                            Logger.logInfo("[Session] " + activityName + " onResume");
                            SessionManager.this.mLastResumeTime = System.currentTimeMillis();
                            long timePassBy = SessionManager.this.mLastResumeTime - SessionManager.this.mLastPauseTime;
                            if (SessionManager.this.mLastPauseTime > 0L && timePassBy > 30000L) {
                                Logger.logInfo("[Session] launch app once, activity resume from background " + timePassBy / 1000L + "s,  over threshold " + 30L + "s");
                                SessionManager.this.createAndSaveNewSession((Context)activity, 1);
                            }
                            SessionManager.this.mForeground = 1;
                            NativeExceptionHandler.getInstance().setNativeData("foreground", SessionManager.this.mForeground + "");
                        }

                        public void onActivityPaused(Activity activity) {
                            String activityName = SessionManager.getActivityName(activity);
                            Logger.logInfo("[Session] " + activityName + " onPause");
                            SessionManager.this.mLastPauseTime = System.currentTimeMillis();
                            SessionManager.this.mForeground = 2;
                            NativeExceptionHandler.getInstance().setNativeData("foreground", SessionManager.this.mForeground + "");
                        }

                        public void onActivityStopped(Activity activity) {
                        }

                        public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
                        }

                        public void onActivityDestroyed(Activity activity) {
                            String activityName = SessionManager.getActivityName(activity);
                            Logger.logInfo("[Session] " + activityName + " onDestroy");
                        }
                    };
                    application.registerActivityLifecycleCallbacks(this.mLifecycleCallbacks);
                }
            }
            catch (Throwable e) {
                Logger.logError("[Session] Can't register Activity Lifecycle Callbacks: " + e.getMessage());
            }
        }
    }

    public int getForeground() {
        return this.mForeground;
    }

    private void startSyncTask(Context applicationContext) {
        TaskManager.getInstance().postInterval(new SyncTask(applicationContext), 1800000L);
    }

    private void startMidnightTask(Context applicationContext) {
        TaskManager.getInstance().postDelay(new MidnightTask(applicationContext), MidnightTask.getMillisSecondBeforeMidnight());
    }

    public MergeSession findUnSendSessions(Context context) {
        List<Session> sessions = this.mSessionStorage.findAll(context);
        if (sessions != null && sessions.size() > 0) {
            Logger.logInfo("[Session] Merge " + sessions.size() + " sessions.");
            return new MergeSession(sessions);
        }
        return null;
    }

    public boolean deleteSessions(Context context, MergeSession mergeSession) {
        if (mergeSession != null && mergeSession.size() > 0) {
            return this.mSessionStorage.delete(context, mergeSession.getSessions());
        }
        return false;
    }

    public boolean sendSessionBlocking(Context context, MergeSession mergeSession) {
        if (mergeSession != null) {
            try {
                String jsonLine = mergeSession.toJsonLine();
                NetSenderResponse response = new NetSender().sendBlocking(null, jsonLine, false);
                ActionEvent.parseAndSaveRemoteSettingsFromPingResponse(context, response);
                return response != null && response.getSentSuccessfully() != false;
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return false;
    }
}

