/*
 * Decompiled with CFR 0.152.
 */
package com.xsj.crasheye.session;

import com.xsj.crasheye.EnumActionType;
import com.xsj.crasheye.Properties;
import com.xsj.crasheye.log.Logger;
import com.xsj.crasheye.session.ApiClient;
import com.xsj.crasheye.session.Session;
import java.io.Serializable;
import java.util.List;

public class MergeSession
implements Serializable {
    private List<Session> mSessions;

    public MergeSession(List<Session> sessions) {
        this.mSessions = sessions;
    }

    public List<Session> getSessions() {
        return this.mSessions;
    }

    public int size() {
        return this.mSessions != null ? this.mSessions.size() : 0;
    }

    public String toJsonLine() {
        StringBuilder sb = new StringBuilder();
        sb.append(ApiClient.getApiRequestHeaderString());
        if (this.mSessions != null) {
            sb.append("[");
            for (int i = 0; i < this.mSessions.size(); ++i) {
                Session session = this.mSessions.get(i);
                Logger.logInfo("[Session] Upload A merged session, sessionId=" + session.getSessionId() + ", sessionType=" + session.getType() + ", createAt=" + session.getCreatedAt());
                String sessionJson = session.getJson();
                sessionJson = Properties.actionTypeRegx.matcher(sessionJson).replaceAll("");
                sb.append(sessionJson);
                if (i >= this.mSessions.size() - 1) continue;
                sb.append(",");
            }
            sb.append("]");
            sb.append(Properties.getSeparator(EnumActionType.ping));
        }
        return sb.toString();
    }
}

