/*
 * Decompiled with CFR 0.152.
 */
package com.xsj.crasheye.http.impl;

import com.xsj.crasheye.http.ByteArrayPool;
import com.xsj.crasheye.http.HttpException;
import com.xsj.crasheye.http.HttpResponse;
import com.xsj.crasheye.http.HttpStack;
import com.xsj.crasheye.http.PoolingByteArrayOutputStream;
import com.xsj.crasheye.log.Logger;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class HurlStack
implements HttpStack {
    private static final int DEFAULT_CONNECT_TIMEOUT = 20000;
    private static final int DEFAULT_READ_TIMEOUT = 20000;
    private static final int DEFAULT_POOL_SIZE = 4096;
    private static final int MAX_RETRY_NUM = 3;
    private final SSLSocketFactory mSslSocketFactory = this.createSSLSocketFactory();
    private final ByteArrayPool mPool = new ByteArrayPool(4096);

    private SSLSocketFactory createSSLSocketFactory() {
        try {
            TrustManager[] tm = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }
            }};
            SSLContext sslContext = SSLContext.getInstance("TLSv1");
            sslContext.init(null, tm, new SecureRandom());
            return sslContext.getSocketFactory();
        }
        catch (Throwable e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpResponse post(String url, Map<String, String> headers, byte[] body) throws HttpException {
        int currentRetryCount = 0;
        while (true) {
            if (++currentRetryCount > 1) {
                Logger.logWarning("[Network] retry count: " + currentRetryCount);
            }
            HttpResponse resp = new HttpResponse();
            HttpURLConnection connection = null;
            try {
                int requestLength;
                connection = this.createHttpURLConnection(url);
                this.addRequestHeaders(connection, headers);
                this.writeRequestBody(connection, body);
                int statusCode = connection.getResponseCode();
                Logger.logInfo("[Network] Response status code: " + statusCode);
                resp.setStatusCode(statusCode);
                if (statusCode < 200 || statusCode > 299) {
                    throw new IOException("statusCode == " + statusCode);
                }
                byte[] responseBody = this.readResponseBody(connection);
                resp.setResponseBody(new String(responseBody, "UTF-8"));
                Logger.logInfo("[Network] Response body: " + resp.getResponseBody());
                int n = requestLength = body != null ? body.length : 0;
                int responseLength = connection.getContentLength() > 0 ? connection.getContentLength() : (resp.getResponseBody() != null ? resp.getResponseBody().getBytes().length : 0);
                Logger.logInfo("[Network] Traffic statistics, req: " + HurlStack.formatByteSize(requestLength) + ", resp: " + HurlStack.formatByteSize(responseLength));
                HttpResponse httpResponse = resp;
                return httpResponse;
            }
            catch (SocketTimeoutException e) {
                Logger.logError("[Network] TimeoutException");
                if (currentRetryCount < 3) continue;
                Logger.logError("[Network] retry failed, retry count: " + currentRetryCount);
                throw new HttpException("TimeoutException", e);
            }
            catch (IOException e) {
                Logger.logError("[Network] IOException");
                if (currentRetryCount < 3) continue;
                Logger.logError("[Network] retry failed, retry count: " + currentRetryCount);
                throw new HttpException("IOException", e);
            }
            catch (Throwable e) {
                Logger.logError("[Network] Exception: " + e.getMessage());
                if (currentRetryCount < 3) continue;
                Logger.logError("[Network] retry failed, retry count: " + currentRetryCount);
                throw new HttpException("Throwable", e);
            }
            finally {
                if (connection == null) continue;
                connection.disconnect();
                continue;
            }
            break;
        }
    }

    private HttpURLConnection createHttpURLConnection(String url) throws IOException {
        URL parsedUrl = new URL(url);
        HttpURLConnection connection = (HttpURLConnection)parsedUrl.openConnection();
        connection.setRequestMethod("POST");
        connection.setInstanceFollowRedirects(HttpURLConnection.getFollowRedirects());
        connection.setConnectTimeout(20000);
        connection.setReadTimeout(20000);
        connection.setUseCaches(false);
        connection.setDoInput(true);
        if ("https".equals(parsedUrl.getProtocol()) && this.mSslSocketFactory != null) {
            ((HttpsURLConnection)connection).setSSLSocketFactory(this.mSslSocketFactory);
        }
        return connection;
    }

    private void addRequestHeaders(HttpURLConnection connection, Map<String, String> headers) {
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            connection.addRequestProperty(key, value);
        }
    }

    private void writeRequestBody(HttpURLConnection connection, byte[] body) throws IOException {
        connection.setDoOutput(true);
        DataOutputStream out = null;
        try {
            out = new DataOutputStream(connection.getOutputStream());
            out.write(body);
        }
        catch (IOException e) {
            Logger.logError("[Network] write request body fail.");
            throw e;
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private byte[] readResponseBody(HttpURLConnection connection) throws IOException {
        byte[] body = null;
        InputStream in = null;
        try {
            in = connection.getInputStream();
        }
        catch (IOException ignore) {
            in = connection.getErrorStream();
        }
        if (in != null) {
            try {
                body = this.inputStreamToBytes(in, connection.getContentLength());
            }
            catch (IOException e) {
                Logger.logError("[Network] read response body fail.");
                throw e;
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        return body;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] inputStreamToBytes(InputStream in, int length) throws IOException {
        PoolingByteArrayOutputStream bytes = new PoolingByteArrayOutputStream(this.mPool, length);
        byte[] buffer = null;
        try {
            int count;
            buffer = this.mPool.getBuf(1024);
            while ((count = in.read(buffer)) != -1) {
                bytes.write(buffer, 0, count);
            }
            byte[] byArray = bytes.toByteArray();
            return byArray;
        }
        finally {
            this.mPool.returnBuf(buffer);
            bytes.close();
        }
    }

    private static String formatByteSize(long byteCount) {
        if (byteCount > 1024L) {
            return (int)((double)byteCount / 1024.0) + " kb";
        }
        return byteCount + " b";
    }
}

