/*
 * Decompiled with CFR 0.152.
 */
package com.xsj.crasheye.http;

import com.xsj.crasheye.http.ByteArrayPool;
import com.xsj.crasheye.http.PoolingByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class MultipartBody {
    private static final byte[] COLONSPACE = new byte[]{58, 32};
    private static final byte[] CRLF = new byte[]{13, 10};
    private static final byte[] DASHDASH = new byte[]{45, 45};
    private final byte[] mBoundary;
    private final String mMediaType;
    private final List<Part> mParts;

    MultipartBody(byte[] boundary, String mediaType, List<Part> parts) {
        this.mBoundary = boundary;
        this.mMediaType = mediaType;
        this.mParts = parts;
    }

    public String getContentType() {
        return this.mMediaType + "; boundary=" + Utils.decodeUTF8(this.mBoundary);
    }

    public byte[] toByteArray() throws IOException {
        PoolingByteArrayOutputStream buffer = new PoolingByteArrayOutputStream(new ByteArrayPool(4096));
        for (int i = 0; i < this.mParts.size(); ++i) {
            Part part = this.mParts.get(i);
            if (part == null) continue;
            buffer.write(DASHDASH);
            buffer.write(this.mBoundary);
            buffer.write(CRLF);
            part.writeTo(buffer);
        }
        buffer.write(DASHDASH);
        buffer.write(this.mBoundary);
        buffer.write(DASHDASH);
        buffer.write(CRLF);
        return buffer.toByteArray();
    }

    private static final class Utils {
        private Utils() {
        }

        private static byte[] encodeUTF8(String s) {
            try {
                if (s != null) {
                    return s.getBytes("UTF-8");
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return new byte[0];
        }

        private static String decodeUTF8(byte[] bytes) {
            try {
                return new String(bytes, "UTF-8");
            }
            catch (Throwable throwable) {
                return "";
            }
        }

        private static String quotedString(String key) {
            StringBuilder target = new StringBuilder();
            target.append('\"');
            if (key != null) {
                int len = key.length();
                block5: for (int i = 0; i < len; ++i) {
                    char ch = key.charAt(i);
                    switch (ch) {
                        case '\n': {
                            target.append("%0A");
                            continue block5;
                        }
                        case '\r': {
                            target.append("%0D");
                            continue block5;
                        }
                        case '\"': {
                            target.append("%22");
                            continue block5;
                        }
                        default: {
                            target.append(ch);
                        }
                    }
                }
            }
            target.append('\"');
            return target.toString();
        }
    }

    public static interface Part {
        public void writeTo(OutputStream var1) throws IOException;
    }

    public static final class Builder {
        private final String mBoundary;
        private final String mMediaType;
        private final List<Part> mParts = new ArrayList<Part>();

        public Builder() {
            this(UUID.randomUUID().toString(), "multipart/form-data");
        }

        public Builder(String boundary, String mediaType) {
            this.mBoundary = boundary;
            this.mMediaType = mediaType;
        }

        public Builder addStringPart(String name, String value) {
            this.mParts.add(new StringPart(name, value));
            return this;
        }

        public Builder addFilePart(String name, String filename, String mimeType, byte[] fileContentBytes) {
            this.mParts.add(new FilePart(name, filename, mimeType, fileContentBytes));
            return this;
        }

        public MultipartBody build() {
            return new MultipartBody(Utils.encodeUTF8(this.mBoundary), this.mMediaType, this.mParts);
        }
    }

    public static final class FilePart
    implements Part {
        private final String mName;
        private final String mFileName;
        private final String mMimeType;
        private final byte[] mValue;

        public FilePart(String name, String fileName, String mimeType, byte[] fileContentBytes) {
            this.mName = name;
            this.mFileName = fileName;
            this.mMimeType = mimeType;
            this.mValue = fileContentBytes;
        }

        @Override
        public void writeTo(OutputStream out) throws IOException {
            out.write(Utils.encodeUTF8("Content-Disposition: form-data; name="));
            out.write(Utils.encodeUTF8(Utils.quotedString(this.mName)));
            out.write(Utils.encodeUTF8("; filename="));
            out.write(Utils.encodeUTF8(Utils.quotedString(this.mFileName)));
            out.write(CRLF);
            out.write(Utils.encodeUTF8("Content-Type: "));
            out.write(Utils.encodeUTF8(this.mMimeType));
            out.write(CRLF);
            out.write(CRLF);
            out.write(this.mValue);
            out.write(CRLF);
        }
    }

    public static final class StringPart
    implements Part {
        private final String mName;
        private final String mValue;

        public StringPart(String name, String value) {
            this.mName = name;
            this.mValue = value;
        }

        @Override
        public void writeTo(OutputStream out) throws IOException {
            out.write(Utils.encodeUTF8("Content-Disposition: form-data; name="));
            out.write(Utils.encodeUTF8(Utils.quotedString(this.mName)));
            out.write(CRLF);
            out.write(CRLF);
            out.write(Utils.encodeUTF8(this.mValue));
            out.write(CRLF);
        }
    }
}

