/*
 * Decompiled with CFR 0.152.
 */
package com.xsj.crasheye.exception;

import android.util.Log;
import com.xsj.crasheye.ActionError;
import com.xsj.crasheye.ActionTransactionStop;
import com.xsj.crasheye.AsyncDataSaver;
import com.xsj.crasheye.Crasheye;
import com.xsj.crasheye.EnumActionType;
import com.xsj.crasheye.EnumExceptionType;
import com.xsj.crasheye.Properties;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.Map;

public class ExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private Thread.UncaughtExceptionHandler defaultExceptionHandler;

    public ExceptionHandler(Thread.UncaughtExceptionHandler pDefaultExceptionHandler) {
        this.defaultExceptionHandler = pDefaultExceptionHandler;
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        Log.i((String)"Crasheye", (String)"[Crash] ---------------- Crasheye SDK Crash Begin ------------------------");
        Log.i((String)"Crasheye", (String)("uuid: " + Properties.UID));
        Log.i((String)"Crasheye", (String)("appVersionName: " + Properties.getAppVersion()));
        StringWriter stacktrace = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stacktrace);
        for (Throwable cause = e; cause != null; cause = cause.getCause()) {
            cause.printStackTrace(printWriter);
        }
        String stacktraceLog = ((Object)stacktrace).toString();
        Log.i((String)"Crasheye", (String)stacktraceLog);
        ActionError crashData = new ActionError(EnumActionType.error, stacktraceLog, EnumExceptionType.UNHANDLED, null);
        Iterator iterator = Properties.transactionsDatabase.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry pair = iterator.next();
            if (pair.getValue() != null) {
                ActionTransactionStop mTransactionStop = ActionTransactionStop.createTransactionFail(((String)pair.getKey()).replace("TStart:name:", ""), crashData.getErrorHash(), null);
                mTransactionStop.save(new AsyncDataSaver());
            }
            iterator.remove();
        }
        crashData.save(null);
        if (Crasheye.crasheyeCallback != null) {
            Crasheye.crasheyeCallback.lastBreath(new Exception(e));
        }
        Log.i((String)"Crasheye", (String)"[Crash] ---------------- Crasheye SDK Crash End ------------------------");
        this.defaultExceptionHandler.uncaughtException(t, e);
    }
}

