/*
 * Decompiled with CFR 0.152.
 */
package com.xsj.crasheye.dao.impl;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import com.xsj.crasheye.dao.SessionDao;
import com.xsj.crasheye.dao.base.BaseDao;
import com.xsj.crasheye.session.Session;
import com.xsj.crasheye.util.Utils;

public class SessionDaoImpl
extends BaseDao<Session, Long>
implements SessionDao {
    public static final String TABLE_NAME = "session";
    private static final String CREATE_TABLE_SQL = " CREATE TABLE `session` (`_id`\tINTEGER PRIMARY KEY\t\t\t,`session_id`\tTEXT\t\t\t,`json`\tTEXT\t\t\t,`type`\tINTEGER\t\t\t,`created_at`\tINTEGER\t\t\t);";
    private static final int INDEX__ID = 0;
    private static final int INDEX_SESSION_ID = 1;
    private static final int INDEX_JSON = 2;
    private static final int INDEX_TYPE = 3;
    private static final int INDEX_CREATED_AT = 4;
    public static final String COLUMN__ID = "_id";
    public static final String COLUMN_SESSION_ID = "session_id";
    public static final String COLUMN_JSON = "json";
    public static final String COLUMN_TYPE = "type";
    public static final String COLUMN_CREATED_AT = "created_at";
    private boolean xor = true;

    public SessionDaoImpl(SQLiteOpenHelper openHelper) {
        super(openHelper);
        this.setPrimaryKey(COLUMN__ID);
        this.mTableName = TABLE_NAME;
    }

    public SessionDaoImpl() {
        this(null);
    }

    @Override
    public Session cursorToObject(Cursor c, String[] columns) {
        Session obj = new Session();
        obj.set_id(c.getLong(0));
        obj.setSessionId(c.getString(1));
        if (this.xor) {
            obj.setJson(Utils.decryptString(c.getString(2)));
        } else {
            obj.setJson(c.getString(2));
        }
        obj.setType(c.getInt(3));
        obj.setCreatedAt(c.getLong(4));
        return obj;
    }

    @Override
    public ContentValues objectToValues(Session obj) {
        ContentValues v = new ContentValues();
        v.put(COLUMN_SESSION_ID, obj.getSessionId());
        if (this.xor) {
            v.put(COLUMN_JSON, Utils.encryptString(obj.getJson()));
        } else {
            v.put(COLUMN_JSON, obj.getJson());
        }
        v.put(COLUMN_TYPE, Integer.valueOf(obj.getType()));
        v.put(COLUMN_CREATED_AT, Long.valueOf(obj.getCreatedAt()));
        return v;
    }

    @Override
    public Long getPK(Session entity) {
        return entity.get_id();
    }

    @Override
    public Session setPK(Session entity, Long id) {
        if (id != null) {
            entity.set_id(id);
        }
        return entity;
    }

    @Override
    public Class<?> getPKClass() {
        return Long.TYPE;
    }

    @Override
    public String getTableName() {
        return TABLE_NAME;
    }

    @Override
    public String getCreateTableSql() {
        return CREATE_TABLE_SQL;
    }

    @Override
    public void onCreateTable(SQLiteDatabase db) {
        db.execSQL(this.getCreateTableSql());
    }

    @Override
    public void onUpgradeTable(SQLiteDatabase db, int oldVersion, int newVersion) {
        db.execSQL("DROP TABLE IF EXISTS " + this.getTableName());
    }
}

