/*
 * Decompiled with CFR 0.152.
 */
package com.xsj.crasheye.dao.base;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.util.Log;
import com.xsj.crasheye.dao.base.YoDao;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.UUID;

public abstract class BaseDao<T, ID extends Serializable>
implements YoDao<T, ID> {
    private static final String TAG = YoDao.TAG;
    private static boolean DEBUG = false;
    protected SQLiteOpenHelper mOpenHelper;
    protected String mTableName = null;
    protected String mPrimaryKey = "_id";
    protected static final String AGO_FULL_DATE_FORMATTER = "yyyy-MM-dd HH:mm:ss";
    protected static ThreadLocal<DateFormat> TL_AGO_FULL_DATE_FORMATTER = new ThreadLocal();

    public BaseDao(SQLiteOpenHelper openHelper) {
        this.mOpenHelper = openHelper;
    }

    public abstract String getTableName();

    public abstract T setPK(T var1, ID var2);

    public abstract ID getPK(T var1);

    public abstract T cursorToObject(Cursor var1, String[] var2);

    public abstract ContentValues objectToValues(T var1);

    @Override
    public abstract String getCreateTableSql();

    public abstract Class<?> getPKClass();

    @Override
    public boolean save(T entity) {
        this.log("save entity: " + entity, new Object[0]);
        SQLiteDatabase db = this.getDb(true);
        return this.save(db, entity);
    }

    protected boolean save(SQLiteDatabase db, T entity) {
        boolean successed = false;
        if (entity != null) {
            if (this.isEmptyEntity(entity)) {
                long rowId = db.insert(this.mTableName, null, this.objectToValues(entity));
                boolean bl = successed = rowId > 0L;
                if (this.isPkEqualsRowId()) {
                    this.setPK(entity, rowId);
                }
            } else {
                long count = this.update(entity);
                successed = count > 0L;
            }
        }
        return successed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean save(List<T> entities) {
        this.log("save entities: " + entities, new Object[0]);
        boolean allSuccessed = true;
        SQLiteDatabase db = this.getDb(true);
        db.beginTransaction();
        try {
            allSuccessed = this.saveWithoutTransaction(db, entities);
            db.setTransactionSuccessful();
        }
        catch (Throwable e) {
            e.printStackTrace();
            allSuccessed = false;
        }
        finally {
            db.endTransaction();
        }
        return allSuccessed;
    }

    protected boolean saveWithoutTransaction(SQLiteDatabase db, List<T> entities) {
        boolean allSuccessed = true;
        for (T entity : entities) {
            boolean successed = this.save(db, entity);
            if (successed) continue;
            allSuccessed = false;
        }
        return allSuccessed;
    }

    private boolean isEmptyEntity(T entity) {
        ID id = this.getPK(entity);
        Class<?> clazz = this.getPKClass();
        if (!clazz.isPrimitive()) {
            return id == null;
        }
        if (id instanceof Number) {
            return ((Number)id).longValue() == 0L;
        }
        throw new IllegalArgumentException("Unsupport PK type: " + clazz + ", id=" + id);
    }

    @Override
    public int update(T entity) {
        ID id = this.getPK(entity);
        return this.updateByFields(this.objectToValues(entity), this.whereClauseByPK(), this.whereArgsByPK(id));
    }

    @Override
    public int updateByFields(T entity, String whereClause, String[] whereArgs) {
        return this.updateByFields(this.objectToValues(entity), whereClause, whereArgs);
    }

    @Override
    public int updateByFields(ContentValues values, String whereClause, String[] whereArgs) {
        SQLiteDatabase db = this.getDb(true);
        return db.update(this.mTableName, values, whereClause, whereArgs);
    }

    private boolean isPkEqualsRowId() {
        Class<?> clazz = this.getPKClass();
        if (clazz == Long.class) {
            return true;
        }
        if (clazz == Long.TYPE) {
            return true;
        }
        if (clazz == Integer.class) {
            return true;
        }
        return clazz == Integer.TYPE;
    }

    @Override
    public T findOne(ID id) {
        return this.findOneByFields(this.whereClauseByPK(), this.whereArgsByPK(id), null);
    }

    @Override
    public T findOneByFields(String selection, String[] selectionArgs, String groupBy, String having, String orderBy) {
        this.log("find one by fields: where %s, args %s, group by %s, having %s, order by %s", selection, Arrays.toString(selectionArgs), groupBy, having, orderBy);
        SQLiteDatabase db = this.getDb(false);
        Cursor cursor = db.query(this.mTableName, null, selection, selectionArgs, groupBy, having, orderBy);
        return this._cursorToObject(cursor);
    }

    @Override
    public T findOneByFields(String selection, String[] selectionArgs, String orderBy) {
        return this.findOneByFields(selection, selectionArgs, null, null, orderBy);
    }

    @Override
    public T findOneBySql(String sql, String[] selectionArgs) {
        this.log("find one by sql: %s", sql);
        SQLiteDatabase db = this.getDb(false);
        Cursor cursor = db.rawQuery(sql, selectionArgs);
        return this._cursorToObject(cursor);
    }

    @Override
    public List<T> findAll() {
        return this.findListByFields(null, null, null);
    }

    @Override
    public List<T> findListByFields(String selection, String[] selectionArgs, String groupBy, String having, String orderBy) {
        this.log("find list by fields: where %s, args %s, group by %s, having %s, order by %s", selection, Arrays.toString(selectionArgs), groupBy, having, orderBy);
        SQLiteDatabase db = this.getDb(false);
        Cursor cursor = db.query(this.mTableName, null, selection, selectionArgs, groupBy, having, orderBy);
        List<T> list = this.cursorToList(cursor, null);
        cursor.close();
        return list;
    }

    @Override
    public List<T> findListByFields(String selection, String[] selectionArgs, String orderBy) {
        return this.findListByFields(selection, selectionArgs, null, null, orderBy);
    }

    @Override
    public List<T> findListBySql(String sql, String[] selectionArgs) {
        this.log("find list by sql: %s", sql);
        SQLiteDatabase db = this.getDb(false);
        Cursor cursor = db.rawQuery(sql, selectionArgs);
        List<T> list = this.cursorToList(cursor, null);
        cursor.close();
        return list;
    }

    @Override
    public boolean exists(ID id) {
        return this.countByFields(this.whereClauseByPK(), this.whereArgsByPK(id)) != 0L;
    }

    @Override
    public long count() {
        return this.countByFields(null, null);
    }

    @Override
    public int delete(ID id) {
        return this.deleteByFields(this.whereClauseByPK(), this.whereArgsByPK(id));
    }

    @Override
    public int delete(T entity) {
        ID id;
        int count = 0;
        if (entity != null && (id = this.getPK(entity)) != null) {
            count = this.delete((T)id);
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int delete(List<T> entities) {
        int count = 0;
        SQLiteDatabase db = this.getDb(true);
        db.beginTransaction();
        try {
            for (T item : entities) {
                count += this.delete(item);
            }
            db.setTransactionSuccessful();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        finally {
            db.endTransaction();
        }
        return count;
    }

    @Override
    public int deleteAll() {
        return this.deleteByFields(null, null);
    }

    @Override
    public int deleteByFields(String selection, String[] selectionArgs) {
        this.log("delete by fields: where %s, args %s", selection, Arrays.toString(selectionArgs));
        SQLiteDatabase db = this.getDb(true);
        return db.delete(this.mTableName, selection, selectionArgs);
    }

    @Override
    public void debug() {
        DEBUG = true;
    }

    @Override
    public SQLiteDatabase getDb(boolean writeable) {
        if (writeable) {
            return this.mOpenHelper.getWritableDatabase();
        }
        return this.mOpenHelper.getReadableDatabase();
    }

    @Override
    public long countByFields(String selections, String[] selectionArgs) {
        this.log("count by fields: where %s, args %s", selections, Arrays.toString(selectionArgs));
        SQLiteDatabase db = this.getDb(false);
        long count = db.query(this.mTableName, null, selections, selectionArgs, null, null, null).getCount();
        return count;
    }

    protected final void log(String format, Object ... args) {
        String msg = "[" + this.mTableName + "] ";
        msg = args.length > 1 ? msg + String.format(format, args) : msg + format;
        if (DEBUG) {
            Log.v((String)TAG, (String)msg);
        }
    }

    protected final String whereClauseByPK() {
        return this.mPrimaryKey + " = ?";
    }

    protected final String[] whereArgsByPK(ID id) {
        return new String[]{String.valueOf(id)};
    }

    protected final T _cursorToObject(Cursor cursor) {
        if (cursor != null && cursor.getCount() > 0) {
            cursor.moveToFirst();
            T obj = this.cursorToObject(cursor, null);
            cursor.close();
            return obj;
        }
        return null;
    }

    public final List<T> cursorToList(Cursor cursor, String[] columns) {
        ArrayList<T> list = null;
        if (cursor != null && cursor.getCount() > 0) {
            list = new ArrayList<T>();
            while (cursor.moveToNext()) {
                list.add(this.cursorToObject(cursor, columns));
            }
        }
        return list;
    }

    public void setPrimaryKey(String pk) {
        this.mPrimaryKey = pk;
    }

    public String getPrimaryKey() {
        return this.mPrimaryKey;
    }

    protected long findLongColBySql(String sql, String[] selectionArgs) {
        SQLiteDatabase db = this.getDb(false);
        Cursor cursor = db.rawQuery(sql, selectionArgs);
        long col = -1L;
        if (cursor != null && cursor.getCount() > 0) {
            cursor.moveToFirst();
            if (cursor.getColumnCount() > 0) {
                col = cursor.getLong(0);
            }
            cursor.close();
        }
        return col;
    }

    protected int findIntColBySql(String sql, String[] selectionArgs) {
        SQLiteDatabase db = this.getDb(false);
        Cursor cursor = db.rawQuery(sql, selectionArgs);
        int col = -1;
        if (cursor != null && cursor.getCount() > 0) {
            cursor.moveToFirst();
            if (cursor.getColumnCount() > 0) {
                col = cursor.getInt(0);
            }
            cursor.close();
        }
        return col;
    }

    protected String findStringColBySql(String sql, String[] selectionArgs) {
        SQLiteDatabase db = this.getDb(false);
        Cursor cursor = db.rawQuery(sql, selectionArgs);
        String col = null;
        if (cursor != null && cursor.getCount() > 0) {
            cursor.moveToFirst();
            if (cursor.getColumnCount() > 0) {
                col = cursor.getString(0);
            }
            cursor.close();
        }
        return col;
    }

    protected boolean parseBoolean(int value) {
        return value != 0;
    }

    protected Date parseDatetime(String datetime) {
        if (datetime != null && datetime.length() > 0) {
            try {
                return this.getDefaultDateFormat().parse(datetime);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    protected String formatDatetime(Date date) {
        if (date != null) {
            try {
                return this.getDefaultDateFormat().format(date);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    protected DateFormat getDefaultDateFormat() {
        return BaseDao.getDataFormatThreadSafe(TL_AGO_FULL_DATE_FORMATTER, AGO_FULL_DATE_FORMATTER);
    }

    protected static DateFormat getDataFormatThreadSafe(ThreadLocal<DateFormat> threadLocal, String format) {
        DateFormat df;
        if (threadLocal == null) {
            threadLocal = new ThreadLocal();
        }
        if ((df = threadLocal.get()) == null) {
            df = new SimpleDateFormat(format, Locale.US);
            threadLocal.set(df);
        }
        return df;
    }

    public static String generateUUID() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }
}

