/*
 * Decompiled with CFR 0.152.
 */
package com.xsj.crasheye;

import android.text.TextUtils;
import com.xsj.crasheye.ActionScriptError;
import com.xsj.crasheye.NetSender;
import com.xsj.crasheye.util.Utils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ScriptExceptionHanler {
    private static HashMap<String, Long> exceptions = new HashMap();

    public static synchronized void logScriptException(String errorTitle, String stacktrace, String language) {
        if (!ScriptExceptionHanler.isSendReoprt(errorTitle + stacktrace)) {
            return;
        }
        ActionScriptError error = new ActionScriptError(errorTitle, stacktrace, language, 1, null);
        error.send(new NetSender(), true);
    }

    private static boolean isSendReoprt(String exceptionMessage) {
        long tenMinutes = 600000L;
        if (TextUtils.isEmpty((CharSequence)exceptionMessage)) {
            return false;
        }
        String md5ExMessage = null;
        try {
            md5ExMessage = Utils.MD5(exceptionMessage);
        }
        catch (Exception e) {
            return false;
        }
        Iterator<Map.Entry<String, Long>> it = exceptions.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Long> entry = it.next();
            if (entry.getKey().equals(md5ExMessage)) {
                if (Utils.getTimeForLong() - entry.getValue() >= 600000L) {
                    entry.setValue(Utils.getTimeForLong());
                    return true;
                }
                return false;
            }
            if (Utils.getTimeForLong() - entry.getValue() < 600000L) continue;
            it.remove();
        }
        exceptions.put(md5ExMessage, Utils.getTimeForLong());
        return true;
    }
}

