/*
 * Decompiled with CFR 0.152.
 */
package com.xsj.crasheye;

import android.content.Context;
import android.content.SharedPreferences;
import com.xsj.crasheye.Properties;
import com.xsj.crasheye.RemoteSettingsData;
import com.xsj.crasheye.log.Logger;
import org.json.JSONException;
import org.json.JSONObject;

class RemoteSettings {
    RemoteSettings() {
    }

    protected static final RemoteSettingsData convertJsonToRemoteSettings(String jsonData) {
        if (jsonData == null || jsonData.length() < 1) {
            return null;
        }
        RemoteSettingsData rsd = new RemoteSettingsData();
        try {
            JSONObject settingdata;
            JSONObject rdjson = new JSONObject(jsonData);
            JSONObject settings = rdjson.optJSONObject("remSetVer1");
            if (settings != null) {
                rsd.logLevel = settings.optInt("logLevel");
                rsd.eventLevel = settings.getInt("eventLevel");
                rsd.netMonitoring = settings.optBoolean("netMonitoring");
                rsd.sessionTime = settings.optInt("sessionTime");
                rsd.devSettings = settings.optJSONObject("devSettings").toString();
                rsd.hashCode = settings.optString("hash");
            }
            if ((settingdata = rdjson.optJSONObject("data")) != null) {
                rsd.actionSpan = settingdata.optInt("st");
                rsd.actionCounts = settingdata.optInt("sc");
                rsd.actionHost = settingdata.optInt("sr");
            }
        }
        catch (JSONException e) {
            Logger.logError("Could not convert json to remote data");
            return null;
        }
        catch (Exception e) {
            Logger.logError("convert Json To Remote Settings Error");
            return null;
        }
        return rsd;
    }

    protected static final boolean saveAndLoadRemoteSettings(Context ctx, RemoteSettingsData rsd) {
        SharedPreferences preferences = ctx.getSharedPreferences("REMOTESETTINGSSETTINGS", 0);
        if (preferences == null) {
            return false;
        }
        SharedPreferences.Editor editor = preferences.edit();
        if (editor == null) {
            return false;
        }
        if (rsd.logLevel != null && rsd.logLevel > 0) {
            editor.putInt("logLevel", rsd.logLevel.intValue());
            Properties.RemoteSettingsProps.logLevel = rsd.logLevel;
        }
        if (rsd.eventLevel != null && rsd.eventLevel > 0) {
            editor.putInt("eventLevel", rsd.eventLevel.intValue());
            Properties.RemoteSettingsProps.eventLevel = rsd.eventLevel;
        }
        if (rsd.netMonitoring != null) {
            editor.putBoolean("netMonitoring", rsd.netMonitoring.booleanValue());
            Properties.RemoteSettingsProps.netMonitoringEnabled = rsd.netMonitoring;
        }
        if (rsd.sessionTime != null && rsd.sessionTime > 0) {
            editor.putInt("sessionTime", rsd.sessionTime.intValue());
            Properties.RemoteSettingsProps.sessionTime = rsd.sessionTime;
        }
        if (rsd.devSettings != null) {
            editor.putString("devSettings", rsd.devSettings);
            try {
                Properties.RemoteSettingsProps.devSettings = new JSONObject(rsd.devSettings);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        if (rsd.hashCode != null && rsd.hashCode.length() > 1) {
            editor.putString("hashCode", rsd.hashCode);
            Properties.RemoteSettingsProps.hashCode = rsd.hashCode;
        }
        if (rsd.actionSpan != null && rsd.actionSpan >= 1 && rsd.actionSpan <= 23) {
            editor.putInt("actionSpan", rsd.actionSpan.intValue());
            Properties.RemoteSettingsProps.actionSpan = rsd.actionSpan;
        }
        if (rsd.actionCounts != null && rsd.actionCounts > 0) {
            editor.putInt("actionCounts", rsd.actionCounts.intValue());
            Properties.RemoteSettingsProps.actionCounts = rsd.actionCounts;
        }
        if (rsd.actionHost != null && rsd.actionHost >= 0 && rsd.actionHost <= 99) {
            editor.putInt("actionHost", rsd.actionHost.intValue());
            Properties.RemoteSettingsProps.actionHost = rsd.actionHost;
        }
        return editor.commit();
    }

    protected static final boolean revertAndLoadSendReoprtHost(Context ctx) {
        SharedPreferences preferences = ctx.getSharedPreferences("REMOTESETTINGSSETTINGS", 0);
        if (preferences == null) {
            return false;
        }
        SharedPreferences.Editor editor = preferences.edit();
        if (editor == null) {
            return false;
        }
        editor.putInt("actionHost", -1);
        Properties.RemoteSettingsProps.actionHost = -1;
        return editor.commit();
    }

    protected static final RemoteSettingsData loadRemoteSettings(Context ctx) {
        if (ctx == null) {
            return null;
        }
        RemoteSettingsData rsd = new RemoteSettingsData();
        SharedPreferences preferences = ctx.getSharedPreferences("REMOTESETTINGSSETTINGS", 0);
        if (preferences == null) {
            return null;
        }
        try {
            rsd.logLevel = preferences.getInt("logLevel", Properties.RemoteSettingsProps.logLevel.intValue());
            rsd.eventLevel = preferences.getInt("eventLevel", Properties.RemoteSettingsProps.eventLevel.intValue());
            rsd.actionSpan = preferences.getInt("actionSpan", Properties.RemoteSettingsProps.actionSpan.intValue());
            rsd.actionCounts = preferences.getInt("actionCounts", Properties.RemoteSettingsProps.actionCounts.intValue());
            rsd.actionHost = preferences.getInt("actionHost", Properties.RemoteSettingsProps.actionHost.intValue());
            rsd.netMonitoring = preferences.getBoolean("netMonitoring", Properties.RemoteSettingsProps.netMonitoringEnabled.booleanValue());
            rsd.sessionTime = preferences.getInt("sessionTime", Properties.RemoteSettingsProps.sessionTime.intValue());
            rsd.devSettings = preferences.getString("devSettings", Properties.RemoteSettingsProps.devSettings.toString());
            rsd.hashCode = preferences.getString("hashCode", Properties.RemoteSettingsProps.hashCode);
        }
        catch (Exception ex) {
            Logger.logInfo("load remote settings error:" + ex.getMessage());
        }
        return rsd;
    }
}

