/*
 * Decompiled with CFR 0.152.
 */
package com.xsj.crasheye;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import com.xsj.crasheye.BreadcrumbsLimited;
import com.xsj.crasheye.Crasheye;
import com.xsj.crasheye.CrasheyeLogLevel;
import com.xsj.crasheye.EnumActionType;
import com.xsj.crasheye.ExtraData;
import com.xsj.crasheye.RemoteSettings;
import com.xsj.crasheye.RemoteSettingsData;
import com.xsj.crasheye.TransactionsDatabase;
import com.xsj.crasheye.UidManager;
import com.xsj.crasheye.log.Logger;
import com.xsj.crasheye.util.DeviceUtils;
import com.xsj.crasheye.util.EnumStateStatus;
import com.xsj.crasheye.util.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONException;
import org.json.JSONObject;

public class Properties {
    protected static final String PREF_NAME = "CRASHEYE_USER_SETTINGS";
    protected static final String PREF_KEY_USER_IDENTIFIER = "USER_IDENTIFIER";
    protected static final String PREF_KEY_APP_VERSION = "APP_VERSION";
    protected static final String PERF_KEY_LAST_APP_VERSIONNAME = "PERF_KEY_LAST_APP_VERSIONNAME";
    protected static final String PREF_KEY_EXTRA_DATA = "EXTRA_DATA";
    protected static final String SDK_VERSION = "2.3.8";
    public static final String API_VERSION = "2";
    protected static final String SDK_PLATFORM = "Android";
    public static final String REST_VERSION = "1.0";
    private static boolean initialized = false;
    private static SharedPreferences sPref;
    public static Context AppContent;
    public static String CONNECTION;
    static String STATE;
    public static String FILES_PATH;
    static String LIB_MONOPATH;
    private static String APP_VERSIONNAME;
    public static boolean APP_ISBETAVERSION;
    static String APP_VERSIONCODE;
    public static String APP_PACKAGE;
    static final String TAG = "Crasheye";
    static String OS_VERSION;
    static String PHONE_MODEL;
    static String PHONE_BRAND;
    static String APP_CHANNELID;
    static String APP_KEY;
    static boolean HAS_ROOT;
    static String LOCALE;
    static String CARRIER;
    static String SCREEN_ORIENTATION;
    static String SCREEN_SIZE;
    public static String UID;
    static String UNITE_DEVICE_ID;
    static BreadcrumbsLimited breadcrumbs;
    static ExtraData extraData;
    static boolean SEND_LOG;
    public static String LOG_FILTER;
    public static int LOG_MAX_LINES;
    public static int LOG_MAX_LENGTH;
    public static long TIMESTAMP;
    static boolean proxyEnabled;
    static EnumStateStatus IS_GPS_ON;
    static boolean sendOnlyWiFi;
    private static String userIdentifierBeforeInit;
    private static String extraDataBeforeInit;
    private static String appVersionBeforeInit;
    public static volatile TransactionsDatabase transactionsDatabase;
    public static long lastPingTime;
    public static boolean isKitKat;
    public static ArrayList<String> transactions;
    public static boolean flushOnlyOverWiFi;
    public static final Pattern actionTypeRegx;
    public static String crasheyeInitType;
    public static String domainConfig;
    public static String region;
    public static int sessionCount;
    public static boolean libcrasheye_stack_analyze;
    static String IMEI;
    static String IMSI;
    static String ANDROID_ID;
    static String CPU_ARCH;
    static String OS_ROM;
    static String VIRTUAL_CHECK;
    static final String REMOTEIP_PLACEHOLDER = "{%#@@#%}";

    public static boolean isPluginInitialized() {
        if (!initialized) {
            Logger.logWarning("Crasheye SDK is not initialized!");
        }
        return initialized;
    }

    protected static boolean initialize(Context context) {
        if (!initialized) {
            block19: {
                AppContent = context.getApplicationContext();
                UID = UidManager.getUid(context);
                UNITE_DEVICE_ID = "NA";
                try {
                    PackageManager pm = context.getPackageManager();
                    PackageInfo pi = pm.getPackageInfo(context.getPackageName(), 0);
                    if (APP_VERSIONNAME.equals("NA") || APP_VERSIONNAME.isEmpty()) {
                        APP_VERSIONNAME = pi.versionName;
                    }
                    APP_VERSIONCODE = String.valueOf(pi.versionCode);
                    APP_PACKAGE = pi.packageName;
                }
                catch (Exception e) {
                    Logger.logError("Error collecting information about the package!");
                    if (!Crasheye.DEBUG) break block19;
                    e.printStackTrace();
                }
            }
            PHONE_MODEL = Build.MODEL;
            PHONE_BRAND = Build.MANUFACTURER;
            OS_VERSION = Build.VERSION.RELEASE;
            IMEI = DeviceUtils.getIMEI(context);
            if (IMEI == null) {
                IMEI = "NA";
            }
            if ((IMSI = DeviceUtils.getIMSI(context)) == null) {
                IMSI = "NA";
            }
            if ((ANDROID_ID = DeviceUtils.getAndroidId(context)) == null) {
                ANDROID_ID = "NA";
            }
            if ((CPU_ARCH = DeviceUtils.getCpuArch(context)) == null) {
                CPU_ARCH = "NA";
            }
            OS_ROM = DeviceUtils.getOSROM(context);
            VIRTUAL_CHECK = "NA";
            HAS_ROOT = Utils.checkForRoot();
            if (breadcrumbs == null) {
                breadcrumbs = new BreadcrumbsLimited();
            }
            if (extraData == null) {
                extraData = new ExtraData();
            }
            if (transactionsDatabase == null) {
                transactionsDatabase = new TransactionsDatabase();
            }
            if ((FILES_PATH = Utils.getAbsolutePath(context)) == null) {
                return false;
            }
            LIB_MONOPATH = Utils.getParentFilePath(context);
            RemoteSettingsData remoteSettings = RemoteSettings.loadRemoteSettings(context);
            if (remoteSettings != null) {
                RemoteSettingsProps.logLevel = remoteSettings.logLevel;
                RemoteSettingsProps.eventLevel = remoteSettings.eventLevel;
                RemoteSettingsProps.actionSpan = remoteSettings.actionSpan;
                RemoteSettingsProps.actionCounts = remoteSettings.actionCounts;
                RemoteSettingsProps.actionHost = remoteSettings.actionHost;
                RemoteSettingsProps.netMonitoringEnabled = remoteSettings.netMonitoring;
                RemoteSettingsProps.sessionTime = remoteSettings.sessionTime;
                RemoteSettingsProps.hashCode = remoteSettings.hashCode;
                try {
                    RemoteSettingsProps.devSettings = new JSONObject(remoteSettings.devSettings);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
            initialized = true;
        }
        IS_GPS_ON = Utils.isGPSOn(context);
        LOCALE = Locale.getDefault().getCountry();
        if (LOCALE == null || LOCALE.length() == 0) {
            LOCALE = "NA";
        }
        CARRIER = Utils.getCarrier(context);
        SCREEN_ORIENTATION = Utils.getScreenOrientation(context);
        SCREEN_SIZE = Utils.getScreenSize(context);
        HashMap<String, String> conInfo = Utils.getConnectionInfo(context);
        CONNECTION = conInfo.get("connection");
        STATE = conInfo.get("state");
        APP_CHANNELID = Utils.getChannelIdByConfig(context, APP_CHANNELID);
        sPref = AppContent.getSharedPreferences(PREF_NAME, 0);
        if (userIdentifierBeforeInit != null) {
            Properties.setUserIdentifier(userIdentifierBeforeInit);
            userIdentifierBeforeInit = null;
        }
        if (extraDataBeforeInit != null) {
            Properties.setInternalExtraData(extraDataBeforeInit);
            extraDataBeforeInit = null;
        }
        if (appVersionBeforeInit != null) {
            Properties.setAppVersion(appVersionBeforeInit);
            appVersionBeforeInit = null;
        }
        sessionCount = 1;
        return true;
    }

    public static final String getSeparator(EnumActionType actionName) {
        return "{^1^" + actionName.toString() + "^" + Utils.getTime() + "}";
    }

    protected static final EnumActionType findActionType(String data) {
        Matcher m = actionTypeRegx.matcher(data);
        if (m.find()) {
            return EnumActionType.valueOf(m.group(1));
        }
        return EnumActionType.invalid;
    }

    public static String getUserIdentifier() {
        String userIdentifier = null;
        if (sPref != null) {
            userIdentifier = Utils.decryptString(sPref.getString(PREF_KEY_USER_IDENTIFIER, null));
        }
        return userIdentifier != null ? userIdentifier : "NA";
    }

    public static void setUserIdentifier(String id) {
        if (sPref != null) {
            sPref.edit().putString(PREF_KEY_USER_IDENTIFIER, Utils.encryptString(id)).commit();
        } else {
            userIdentifierBeforeInit = id;
        }
    }

    public static String getInternalExtraData() {
        String internalExtraData = null;
        if (sPref != null) {
            internalExtraData = sPref.getString(PREF_KEY_EXTRA_DATA, null);
        }
        return internalExtraData != null ? internalExtraData : "NA";
    }

    public static void setInternalExtraData(String internalExtraData) {
        if (sPref != null) {
            sPref.edit().putString(PREF_KEY_EXTRA_DATA, internalExtraData).commit();
        } else {
            extraDataBeforeInit = internalExtraData;
        }
    }

    public static String getAppVersion() {
        String lastAppVersionName;
        String appVersion = null;
        if (sPref != null && (lastAppVersionName = Utils.decryptString(sPref.getString(PERF_KEY_LAST_APP_VERSIONNAME, null))) != null && lastAppVersionName.equals(APP_VERSIONNAME)) {
            appVersion = Utils.decryptString(sPref.getString(PREF_KEY_APP_VERSION, null));
        }
        if (appVersion == null) {
            appVersion = APP_VERSIONNAME;
        }
        return appVersion != null ? appVersion : "NA";
    }

    public static void setAppVersion(String YourAppVersion) {
        if (sPref != null) {
            sPref.edit().putString(PREF_KEY_APP_VERSION, Utils.encryptString(YourAppVersion)).putString(PERF_KEY_LAST_APP_VERSIONNAME, Utils.encryptString(APP_VERSIONNAME)).commit();
        } else {
            appVersionBeforeInit = YourAppVersion;
        }
    }

    static {
        AppContent = null;
        CONNECTION = "NA";
        STATE = "NA";
        FILES_PATH = null;
        LIB_MONOPATH = null;
        APP_VERSIONNAME = "NA";
        APP_ISBETAVERSION = false;
        APP_VERSIONCODE = "NA";
        APP_PACKAGE = "NA";
        OS_VERSION = "NA";
        PHONE_MODEL = "NA";
        PHONE_BRAND = null;
        APP_CHANNELID = "NA";
        APP_KEY = "NA";
        HAS_ROOT = false;
        LOCALE = "NA";
        CARRIER = "NA";
        SCREEN_ORIENTATION = "NA";
        SCREEN_SIZE = "NA";
        UID = "";
        UNITE_DEVICE_ID = "";
        breadcrumbs = new BreadcrumbsLimited();
        extraData = new ExtraData();
        SEND_LOG = false;
        LOG_FILTER = "";
        LOG_MAX_LINES = 1000;
        LOG_MAX_LENGTH = -1;
        TIMESTAMP = 0L;
        proxyEnabled = false;
        IS_GPS_ON = EnumStateStatus.NA;
        sendOnlyWiFi = false;
        userIdentifierBeforeInit = null;
        extraDataBeforeInit = null;
        appVersionBeforeInit = null;
        transactionsDatabase = new TransactionsDatabase();
        lastPingTime = 0L;
        isKitKat = false;
        transactions = new ArrayList(2);
        flushOnlyOverWiFi = false;
        actionTypeRegx = Pattern.compile("\\{\\^1\\^([a-z]+?)\\^[0-9]+?\\}$");
        crasheyeInitType = "NA";
        domainConfig = "external";
        region = "cn";
        sessionCount = -1;
        libcrasheye_stack_analyze = false;
        IMEI = "NA";
        IMSI = "NA";
        ANDROID_ID = "NA";
        CPU_ARCH = "NA";
        OS_ROM = "NA";
        VIRTUAL_CHECK = "NA";
    }

    public static class RemoteSettingsProps {
        static Integer logLevel = Utils.convertLoggingLevelToInt(CrasheyeLogLevel.Verbose);
        static Integer eventLevel = Utils.convertLoggingLevelToInt(CrasheyeLogLevel.Verbose);
        public static Integer actionSpan = -1;
        public static Integer actionCounts = -1;
        public static Integer actionHost = -1;
        static Boolean netMonitoringEnabled = true;
        public static Integer sessionTime = 5;
        static JSONObject devSettings = new JSONObject();
        static String hashCode = "none";

        public static String toReadableFormat() {
            return "loglevel: " + String.valueOf(logLevel) + " eventLevel: " + String.valueOf(eventLevel) + " actionSpan: " + String.valueOf(actionSpan) + " actionCounts: " + String.valueOf(actionCounts) + " actionHost: " + String.valueOf(actionHost) + " netMonitoring: " + String.valueOf(netMonitoringEnabled) + " sessionTime: " + String.valueOf(sessionTime) + " devSettings: " + devSettings.toString() + " hashCode: " + hashCode;
        }
    }
}

