/*
 * Decompiled with CFR 0.152.
 */
package com.xsj.crasheye;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.xsj.crasheye.ActionNativeError;
import com.xsj.crasheye.Crasheye;
import com.xsj.crasheye.CrasheyeFileFilter;
import com.xsj.crasheye.Properties;
import com.xsj.crasheye.log.Logger;

public final class NativeExceptionHandler {
    private static boolean initialized = false;
    private static volatile NativeExceptionHandler INSTANCE = null;
    private static Handler handler;
    private static String lastDmpFile;
    private static boolean handleUserspaceSig;
    public static Crasheye.NDKExceptionCallback ndkExceptionCallback;

    private NativeExceptionHandler() {
    }

    private native boolean nativeInstallHandler(String var1, String var2, String var3);

    private native boolean nativeInstallHandlerWithMono(String var1, String var2, String var3, String var4);

    private native void nativeTestNativeCrash();

    private native void nativeReInstallHandler();

    private native boolean nativeHandlerInstalled();

    private native void nativeSetUnhandleException();

    private native void nativeSetSystemLogFilter(boolean var1, int var2, String var3);

    private native void nativeWriteMinidump();

    private native void nativeSetData(String var1, String var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static NativeExceptionHandler getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<NativeExceptionHandler> clazz = NativeExceptionHandler.class;
        synchronized (NativeExceptionHandler.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new NativeExceptionHandler();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public void testNativeCrash() {
        try {
            this.nativeTestNativeCrash();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void setNativeData(String key, String value) {
        try {
            this.nativeSetData(key, value);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void updateSystemLogConfigs() {
        if (initialized) {
            try {
                this.nativeSetSystemLogFilter(Properties.SEND_LOG, Properties.LOG_MAX_LINES, Properties.LOG_FILTER);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void handleUserspaceSig() {
        handleUserspaceSig = true;
        this.nativeSetUnhandleException();
        handler = new Handler(Looper.getMainLooper()){

            public void handleMessage(Message msg) {
                try {
                    Logger.logWarning("Not a Crash, delete dump file.");
                    CrasheyeFileFilter.DeleteNativeFile();
                    NativeExceptionHandler.this.nativeReInstallHandler();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.sendEmptyMessageDelayed(1, 500L);
            }
        };
    }

    public boolean init() {
        if (initialized) {
            Logger.logWarning("native exception hanle is already init!");
            return true;
        }
        if (!Properties.isPluginInitialized()) {
            return false;
        }
        try {
            System.loadLibrary("CrasheyeNDK");
        }
        catch (UnsatisfiedLinkError ex) {
            Logger.logError("load CrasheyeNDK so fail");
            return false;
        }
        this.updateSystemLogConfigs();
        if (this.nativeInstallHandler(Properties.FILES_PATH, Properties.UID, Properties.getAppVersion())) {
            initialized = true;
            return true;
        }
        return false;
    }

    public boolean initWithMono() {
        if (initialized) {
            Logger.logWarning("native exception hanle is already init!");
            return true;
        }
        if (!Properties.isPluginInitialized()) {
            return false;
        }
        try {
            System.loadLibrary("CrasheyeNDK");
        }
        catch (UnsatisfiedLinkError e) {
            Logger.logError("load CrasheyeNDK so fail");
            return false;
        }
        if (Properties.FILES_PATH == null) {
            Logger.logError("FILES_PATH is null, Mono init is fail!");
            return false;
        }
        if (Properties.LIB_MONOPATH == null) {
            Logger.logError("LIB_MONOPATH is null, Mono init is fail!");
            return false;
        }
        if (this.nativeInstallHandlerWithMono(Properties.FILES_PATH, Properties.LIB_MONOPATH, Properties.UID, Properties.getAppVersion())) {
            initialized = true;
            return true;
        }
        return false;
    }

    public boolean initWithHandleUserspaceSig() {
        if (initialized) {
            Logger.logWarning("unity native exception handle is already init!");
            return true;
        }
        return this.init();
    }

    public static void hanleNativeException(String dumpFile) {
        Logger.logInfo("[Callback] Got Native Crash from NDK.");
        if (!initialized) {
            Logger.logWarning("native exception handler is not init!");
            return;
        }
        if (!Properties.isPluginInitialized()) {
            return;
        }
        lastDmpFile = dumpFile;
        ActionNativeError mCrashData = new ActionNativeError(dumpFile);
        if (ndkExceptionCallback != null) {
            ndkExceptionCallback.execute();
        }
        mCrashData.save(null);
        Logger.logInfo("[Callback] Save Native Crash into file.");
        if (handleUserspaceSig && !handler.hasMessages(1)) {
            handler.sendEmptyMessageDelayed(1, 5000L);
        }
    }

    static {
        handleUserspaceSig = false;
    }
}

