/*
 * Decompiled with CFR 0.152.
 */
package com.xsj.crasheye;

import android.text.TextUtils;
import android.util.Base64;
import com.xsj.crasheye.ActionNativeError;
import com.xsj.crasheye.BaseExecutor;
import com.xsj.crasheye.Crasheye;
import com.xsj.crasheye.CrasheyeFileFilter;
import com.xsj.crasheye.EnumActionType;
import com.xsj.crasheye.NetSender;
import com.xsj.crasheye.NetSenderResponse;
import com.xsj.crasheye.Properties;
import com.xsj.crasheye.log.Logger;
import com.xsj.crasheye.minidump.MinidumpStackAnalyzer;
import com.xsj.crasheye.pushstrategy.DateRefreshStrategy;
import com.xsj.crasheye.pushstrategy.MergerSession;
import com.xsj.crasheye.util.TaskManager;
import com.xsj.crasheye.util.Utils;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class DataFlusher
extends BaseExecutor {
    private static final int MAX_FILE_SIZE = 0x3200000;
    private MinidumpStackAnalyzer mMinidumpStackAnalyzer = new MinidumpStackAnalyzer();

    DataFlusher() {
    }

    public synchronized void send() {
        Runnable t = new Runnable(){

            @Override
            public void run() {
                DataFlusher.this.BuildNativateErrorData();
                DataFlusher.this.BuildNotSaveNativateErrorData();
                MergerSession.MergerSessionFiles();
                if (!Utils.allowedToSendData()) {
                    Logger.logInfo("You have enabled the FlushOnlyOverWiFi option and there is no WiFi connection, data will not be sent now.");
                    return;
                }
                if (Properties.FILES_PATH == null) {
                    return;
                }
                File filesPath = new File(Properties.FILES_PATH);
                File[] files = filesPath.listFiles(CrasheyeFileFilter.getInstance());
                if (files == null) {
                    return;
                }
                if (files.length <= 0) {
                    return;
                }
                boolean isSendReport = false;
                isSendReport = files.length >= 2 ? true : DateRefreshStrategy.getInstance().checkCanReportBySpanTime();
                for (File file : files) {
                    if (!file.exists()) continue;
                    if (file.length() > 0x3200000L || file.length() == 0L) {
                        Logger.logWarning("dump file size is more than MAX_FILE_SIZE: 52428800");
                        Utils.deleteFile(file);
                        continue;
                    }
                    if (!isSendReport && file.getName().startsWith("session-CrasheyeSavedData-")) {
                        int sessionFileCount = MergerSession.GetSessionCountByFileName(file.getName());
                        if (!DateRefreshStrategy.getInstance().checkCanReportByFileCount(sessionFileCount)) continue;
                        isSendReport = true;
                    }
                    NetSenderResponse nsr = new NetSenderResponse("", null);
                    String jsonData = null;
                    try {
                        jsonData = Utils.readFile(file.getAbsolutePath());
                        if (jsonData == null || jsonData.length() == 0) {
                            if (Crasheye.crasheyeCallback == null) continue;
                            Crasheye.crasheyeCallback.netSenderResponse(nsr);
                            continue;
                        }
                        NetSenderResponse sendResult = new NetSender().sendBlocking(null, jsonData, false);
                        if (!sendResult.getSentSuccessfully().booleanValue()) continue;
                        if (file.getName().startsWith("session-CrasheyeSavedData-")) {
                            DateRefreshStrategy.getInstance().updataLastReportTime(Utils.getTimeForLong());
                            DateRefreshStrategy.getInstance().saveLastReportTime(Properties.AppContent);
                        }
                        Utils.deleteFile(file);
                    }
                    catch (Exception e) {
                        nsr.setException(e);
                        nsr.setSentSuccessfully(false);
                        e.printStackTrace();
                        if (Crasheye.crasheyeCallback == null) continue;
                        Crasheye.crasheyeCallback.netSenderResponse(nsr);
                    }
                }
            }
        };
        TaskManager.getInstance().postImmediately(t);
    }

    private void BuildNativateErrorData() {
        File filesPath = new File(Properties.FILES_PATH);
        File[] files = filesPath.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().startsWith("native-CrasheyeSavedData-1-") && pathname.getName().endsWith(".json");
            }
        });
        if (files != null) {
            for (File f : files) {
                try {
                    String jsonData = Utils.readFile(f.getAbsolutePath());
                    JSONObject json = new JSONObject(jsonData);
                    JSONObject crashNode = json.getJSONObject("crash");
                    String dumpFile = crashNode.getString("dumpfile");
                    File file = new File(dumpFile);
                    if (!file.exists()) {
                        Logger.logWarning("native crash dump file is not exists");
                        Utils.deleteFile(f);
                        continue;
                    }
                    byte[] data = Utils.toByteArray(dumpFile);
                    if (data != null) {
                        String baseData = Base64.encodeToString((byte[])data, (int)2);
                        crashNode.put("file", (Object)baseData);
                    }
                    this.BuildMinidumpAnalyzed(file, json);
                    this.BuildNativeErrorCustomData(dumpFile, json);
                    this.BuildNativeInfoData(dumpFile, json);
                    this.BuildNativeSystemLogData(dumpFile, json);
                    this.BuildNativeBreadcrumbData(dumpFile, json);
                    this.BuildMonoStackData(dumpFile, json);
                    String filePath = CrasheyeFileFilter.createNewFile();
                    String content = json.toString() + Properties.getSeparator(EnumActionType.ndkerror);
                    Utils.writeFile(filePath, content);
                    Utils.deleteFile(file);
                    Utils.deleteFile(f);
                    this.DeleteNativeDataFile(dumpFile);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Logger.logWarning("build ndk error report fail");
                }
            }
        }
    }

    private void DeleteNativeDataFile(String dumppath) {
        String[] fileSuffix = new String[]{".custom", ".breadcrumbs", ".monostack", ".log", ".info"};
        for (int i = 0; i < fileSuffix.length; ++i) {
            String extrapath = dumppath.replace(".dmp", fileSuffix[i]);
            Utils.deleteFile(extrapath);
        }
    }

    private void BuildNativeBreadcrumbData(String dumppath, JSONObject node) {
        String extrapath = dumppath.replace(".dmp", ".breadcrumbs");
        File f = new File(extrapath);
        if (!f.exists() || f.isDirectory()) {
            return;
        }
        byte[] data = Utils.toByteArray(extrapath);
        if (data == null) {
            return;
        }
        List<byte[]> pairs = Utils.byteSplit("^@%*#~^".getBytes(), data);
        if (pairs.size() % 2 != 0) {
            return;
        }
        JSONArray jsonArray = new JSONArray();
        for (int i = 0; i < pairs.size(); i += 2) {
            try {
                String key = new String(pairs.get(i), "UTF-8");
                String value = new String(pairs.get(i + 1), "UTF-8");
                jsonArray.put((Object)(key + ":" + value));
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (jsonArray.length() != 0) {
            try {
                node.put("breadcrumbs", (Object)jsonArray);
            }
            catch (JSONException e) {
                Logger.logError(e.getMessage());
            }
        }
    }

    private void BuildNativeSystemLogData(String dumppath, JSONObject node) {
        String log = null;
        String extrapath = dumppath.replace(".dmp", ".log");
        File f = new File(extrapath);
        if (!f.exists() || f.isDirectory()) {
            Logger.logInfo("old SEND_LOG: false");
        } else {
            Logger.logInfo("old SEND_LOG: true");
            try {
                log = this.readNativeLogFile(extrapath, Properties.LOG_MAX_LINES, Properties.LOG_MAX_LENGTH);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            if (TextUtils.isEmpty((CharSequence)log)) {
                log = "Can't Read System Log, Permission denied.";
            }
        }
        if (TextUtils.isEmpty(log)) {
            log = "NA";
        }
        try {
            node.put("log", (Object)log);
        }
        catch (JSONException e) {
            Logger.logError(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String readNativeLogFile(String filepath, long maxLines, int maxLength) {
        int lineCount = 0;
        ArrayList<String> lines = new ArrayList<String>();
        RandomAccessFile rf = null;
        try {
            rf = new RandomAccessFile(filepath, "r");
            long len = rf.length();
            long start = rf.getFilePointer();
            long nextend = start + len - 1L;
            rf.seek(nextend);
            int c = -1;
            while (nextend > start) {
                String line;
                c = rf.read();
                if (c == 10 || c == 13) {
                    line = rf.readLine();
                    if (line != null) {
                        lines.add(line + "\n");
                        if ((long)(++lineCount) >= maxLines) break;
                    }
                    --nextend;
                }
                rf.seek(--nextend);
                if (nextend != 0L || (line = rf.readLine()) == null) continue;
                lines.add(line + "\n");
                if ((long)(++lineCount) < maxLines) continue;
                break;
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (rf != null) {
                    rf.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        Collections.reverse(lines);
        String log = TextUtils.join((CharSequence)"", lines);
        if (maxLength <= 0) return log;
        if (log.length() <= maxLength) return log;
        return log.substring(log.length() - maxLength);
    }

    private void BuildNativeErrorCustomData(String dumppath, JSONObject node) {
        JSONObject crashNode;
        String extrapath = dumppath.replace(".dmp", ".custom");
        File f = new File(extrapath);
        if (!f.exists() || f.isDirectory()) {
            return;
        }
        byte[] data = Utils.toByteArray(extrapath);
        if (data == null) {
            return;
        }
        List<byte[]> pairs = Utils.byteSplit("^@%*#~^".getBytes(), data);
        if (pairs.size() % 2 != 0) {
            return;
        }
        String scriptStack = null;
        HashMap<String, String> extraData = new HashMap<String, String>();
        for (int i = 0; i < pairs.size(); i += 2) {
            try {
                String key = new String(pairs.get(i), "UTF-8");
                String value = new String(pairs.get(i + 1), "UTF-8");
                if (key.equals("scriptstack")) {
                    scriptStack = value;
                    continue;
                }
                extraData.put(key, value);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (scriptStack != null && (crashNode = node.optJSONObject("crash")) != null) {
            try {
                crashNode.put("scriptstack", scriptStack);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        if (extraData.size() != 0) {
            try {
                node.put("extradata", (Object)new JSONObject(extraData));
            }
            catch (JSONException e) {
                Logger.logError(e.getMessage());
            }
        }
    }

    private void BuildNativeInfoData(String dumppath, JSONObject node) {
        String extrapath = dumppath.replace(".dmp", ".info");
        File f = new File(extrapath);
        if (!f.exists() || f.isDirectory()) {
            return;
        }
        byte[] data = Utils.toByteArray(extrapath);
        if (data == null) {
            return;
        }
        List<byte[]> pairs = Utils.byteSplit("^@%*#~^".getBytes(), data);
        if (pairs.size() % 2 != 0) {
            return;
        }
        for (int i = 0; i < pairs.size(); i += 2) {
            try {
                String key = new String(pairs.get(i), "UTF-8");
                String value = new String(pairs.get(i + 1), "UTF-8");
                try {
                    Logger.logInfo("[DataFlusher] Set JSON Value From Native Info File, " + key + " : " + value);
                    node.put(key, (Object)value);
                }
                catch (JSONException e) {
                    Logger.logError(e.getMessage());
                }
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void BuildMonoStackData(String dumppath, JSONObject node) {
        JSONObject crashNode;
        String extrapath = dumppath.replace(".dmp", ".monostack");
        File f = new File(extrapath);
        if (!f.exists() || f.isDirectory()) {
            return;
        }
        byte[] data = Utils.toByteArray(extrapath);
        if (data == null) {
            return;
        }
        String monoStack = null;
        try {
            monoStack = new String(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        if (monoStack != null && (crashNode = node.optJSONObject("crash")) != null) {
            try {
                crashNode.put("scriptstack", (Object)monoStack);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    private void BuildNotSaveNativateErrorData() {
        File filesPath = new File(Properties.FILES_PATH);
        File[] files = filesPath.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().endsWith(".dmp");
            }
        });
        if (files != null) {
            for (File f : files) {
                try {
                    ActionNativeError error = new ActionNativeError(f.getAbsolutePath());
                    error.SetNativeCrashData(f.getAbsolutePath());
                    error.SetLastUnSave();
                    JSONObject json = error.toJson();
                    this.BuildMinidumpAnalyzed(f, json);
                    this.BuildNativeErrorCustomData(f.getAbsolutePath(), json);
                    this.BuildNativeInfoData(f.getAbsolutePath(), json);
                    this.BuildNativeSystemLogData(f.getAbsolutePath(), json);
                    this.BuildNativeBreadcrumbData(f.getAbsolutePath(), json);
                    this.BuildMonoStackData(f.getAbsolutePath(), json);
                    String filePath = CrasheyeFileFilter.createNewFile();
                    String content = json.toString() + Properties.getSeparator(EnumActionType.ndkerror);
                    Utils.writeFile(filePath, content);
                    Utils.deleteFile(f);
                    this.DeleteNativeDataFile(f.getAbsolutePath());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Logger.logWarning("build ndk error report fail");
                }
            }
        }
    }

    private void BuildMinidumpAnalyzed(File dumpFile, JSONObject node) {
        if (!Properties.libcrasheye_stack_analyze) {
            Logger.logWarning("libminidump_stack_analyze not enabled!");
            return;
        }
        if (dumpFile == null || !dumpFile.exists()) {
            Logger.logError("dumpFile is null or not exists");
            return;
        }
        File analyzedFile = this.mMinidumpStackAnalyzer.analyze(dumpFile);
        if (analyzedFile != null) {
            JSONObject crashNode;
            String minidumpStack = null;
            try {
                minidumpStack = Utils.readFile(analyzedFile.getAbsolutePath());
            }
            catch (Throwable e) {
                e.printStackTrace();
                Logger.logError(e.getMessage());
            }
            if (minidumpStack != null && node != null && (crashNode = node.optJSONObject("crash")) != null) {
                try {
                    crashNode.put("minidump_stack", (Object)minidumpStack);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
            Utils.deleteFile(analyzedFile);
        }
    }
}

