/*
 * Decompiled with CFR 0.152.
 */
package com.xsj.crasheye;

import com.xsj.crasheye.Properties;
import com.xsj.crasheye.util.Utils;
import java.io.File;
import java.io.FileFilter;

public class CrasheyeFileFilter
implements FileFilter {
    private static final String VERSION = "1";
    private static final String PREFIX = "CrasheyeSavedData-1-";
    public static final String POSTFIX = ".json";
    public static final String RAWNATIVEFILE = ".dmp";
    public static final String BREADCRUMBSFILE = ".breadcrumbs";
    public static final String CUSTOMFILE = ".custom";
    public static final String NATIVEINFOFILE = ".info";
    public static final String SYSTEMLOGFILE = ".log";
    public static final String MONOSTACKFILE = ".monostack";
    public static final String NATIVEPREFIX = "native-CrasheyeSavedData-1-";
    public static final String NativeErrorFile = Properties.FILES_PATH + "/" + "native-CrasheyeSavedData-1-" + String.valueOf(System.currentTimeMillis()) + ".json";
    public static final String NATIVESEPARATOR = "^@%*#~^";
    public static final String SPLITSTRING = "\\^";
    public static final String MINIDUMP_ANALYZED_FILE = ".analyzed";
    private static String FILECOUNT = "1";
    public static final String SESIONFIX = "session-CrasheyeSavedData-";
    private static CrasheyeFileFilter fileFilterSingleton = null;

    @Override
    public boolean accept(File filename) {
        if (filename.getName().startsWith(PREFIX) && filename.getName().endsWith(POSTFIX)) {
            return true;
        }
        return filename.getName().startsWith(SESIONFIX) && filename.getName().endsWith(POSTFIX);
    }

    public static String createNewFile() {
        return Properties.FILES_PATH + "/" + PREFIX + String.valueOf(System.currentTimeMillis()) + POSTFIX;
    }

    public static void SetFileCount(int fileCount) {
        FILECOUNT = String.valueOf(fileCount);
    }

    public static String createSessionNewFile() {
        String SESIONPREFIX = SESIONFIX + FILECOUNT + "-";
        return Properties.FILES_PATH + "/" + SESIONPREFIX + String.valueOf(System.currentTimeMillis()) + POSTFIX;
    }

    public static CrasheyeFileFilter getInstance() {
        if (fileFilterSingleton == null) {
            fileFilterSingleton = new CrasheyeFileFilter();
        }
        return fileFilterSingleton;
    }

    public static void DeleteNativeFile() {
        Utils.deleteFile(NativeErrorFile);
    }
}

