/*
 * Decompiled with CFR 0.152.
 */
package com.xsj.crasheye;

import com.xsj.crasheye.BaseDataSaver;
import com.xsj.crasheye.Crasheye;
import com.xsj.crasheye.CrasheyeFileFilter;
import com.xsj.crasheye.DataFlusher;
import com.xsj.crasheye.DataSaverResponse;
import com.xsj.crasheye.util.TaskManager;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class AsyncDataSaver
extends BaseDataSaver {
    @Override
    public synchronized void save(String jsonData) {
        this.save(jsonData, CrasheyeFileFilter.createNewFile());
    }

    public synchronized void save(final String jsonData, final String fileFullPath) {
        Runnable t = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                File file = new File(fileFullPath);
                boolean flushData = false;
                DataSaverResponse dsr = new DataSaverResponse(jsonData, file.getAbsolutePath());
                if (file != null && !file.exists()) {
                    try {
                        file.createNewFile();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                BufferedWriter bWritter = null;
                try {
                    bWritter = new BufferedWriter(new FileWriter(file, true));
                    bWritter.append(jsonData);
                    bWritter.flush();
                    bWritter.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    dsr.setException(e);
                    dsr.setSavedSuccessfully(false);
                    if (Crasheye.crasheyeCallback != null) {
                        Crasheye.crasheyeCallback.dataSaverResponse(dsr);
                    }
                }
                finally {
                    if (bWritter != null) {
                        try {
                            bWritter.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    dsr.setSavedSuccessfully(true);
                    if (Crasheye.crasheyeCallback != null) {
                        Crasheye.crasheyeCallback.dataSaverResponse(dsr);
                    }
                    if (flushData) {
                        new DataFlusher().send();
                    }
                }
            }
        };
        TaskManager.getInstance().postImmediately(t);
    }
}

