/*
 * Decompiled with CFR 0.152.
 */
package com.xsj.crasheye;

import android.content.Context;
import com.xsj.crasheye.ActionTransaction;
import com.xsj.crasheye.AsyncDataSaver;
import com.xsj.crasheye.BaseDataSaver;
import com.xsj.crasheye.EnumActionType;
import com.xsj.crasheye.InterfaceDataType;
import com.xsj.crasheye.NetSender;
import com.xsj.crasheye.Properties;
import com.xsj.crasheye.util.Utils;
import java.util.HashMap;
import org.json.JSONException;
import org.json.JSONObject;

class ActionTransactionStart
extends ActionTransaction
implements InterfaceDataType {
    private ActionTransactionStart(String name, HashMap<String, Object> customData) {
        super(name, EnumActionType.trstart, customData);
        this.transaction_id = Utils.getRandomSessionNumber();
        if (!Properties.transactions.contains(this.transaction_id)) {
            Properties.transactions.add(this.transaction_id);
        }
    }

    public static ActionTransactionStart createTransactionStart(String name, HashMap<String, Object> customData) {
        ActionTransactionStart mTransactionStart = new ActionTransactionStart(name, customData);
        Properties.transactionsDatabase.addStartedTransaction(mTransactionStart);
        return mTransactionStart;
    }

    @Override
    public String toJsonLine() {
        JSONObject json = this.getBasicDataFixtureJson();
        try {
            json.put("tr_name", (Object)this.name);
            json.put("transaction_id", (Object)this.transaction_id);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return json.toString() + Properties.getSeparator(EnumActionType.trstart);
    }

    @Override
    public void send(NetSender netSender, boolean saveOnFail) {
        netSender.send(null, this.toJsonLine(), saveOnFail);
    }

    @Override
    public void save(BaseDataSaver dataSaver) {
        new AsyncDataSaver().save(this.toJsonLine());
    }

    @Override
    public void send(Context ctx, NetSender netSender, boolean saveOnFail) {
        netSender.send(null, this.toJsonLine(), saveOnFail);
    }
}

