/*
 * Decompiled with CFR 0.152.
 */
package com.xsj.crasheye;

import android.content.Context;
import com.xsj.crasheye.AsyncDataSaver;
import com.xsj.crasheye.BaseDTO;
import com.xsj.crasheye.BaseDataSaver;
import com.xsj.crasheye.EnumActionType;
import com.xsj.crasheye.EnumErrorType;
import com.xsj.crasheye.InterfaceDataType;
import com.xsj.crasheye.NetSender;
import com.xsj.crasheye.Properties;
import com.xsj.crasheye.session.SessionManager;
import com.xsj.crasheye.util.DeviceUtils;
import com.xsj.crasheye.util.EnumStateStatus;
import com.xsj.crasheye.util.Utils;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class ActionScriptError
extends BaseDTO
implements InterfaceDataType {
    private String message;
    private String stacktrace;
    private Boolean handled;
    private EnumStateStatus gpsStatus;
    private String msFromStart;
    private JSONArray breadcrumbs;
    private String language;
    private int count;
    private String memSysAvailable = null;
    private String memSysTotal = null;
    private String romTotal;
    private String romFree;
    private String sdcardTotal;
    private String sdcardFree;
    private String foreground;
    private String crashTime;
    private String crashuuid = null;

    public ActionScriptError(String message, String stacktrace, String language, int count, HashMap<String, Object> customData) {
        super(EnumActionType.error, customData);
        this.message = message;
        this.stacktrace = stacktrace;
        this.language = language;
        this.count = count;
        this.handled = true;
        this.gpsStatus = Properties.IS_GPS_ON;
        this.msFromStart = Utils.getMilisFromStart();
        this.breadcrumbs = Properties.breadcrumbs.getList();
        long[] tmp = DeviceUtils.getRAMStat();
        this.memSysAvailable = String.valueOf((double)tmp[0] / DeviceUtils.GB_BYTE);
        this.memSysTotal = String.valueOf((double)tmp[1] / DeviceUtils.GB_BYTE);
        tmp = DeviceUtils.getROMStat();
        this.romFree = String.valueOf((double)tmp[0] / DeviceUtils.GB_BYTE);
        this.romTotal = String.valueOf((double)tmp[1] / DeviceUtils.GB_BYTE);
        tmp = DeviceUtils.getSDCardSpace();
        this.sdcardFree = String.valueOf((double)tmp[0] / DeviceUtils.GB_BYTE);
        this.sdcardTotal = String.valueOf((double)tmp[1] / DeviceUtils.GB_BYTE);
        this.crashTime = Utils.getTime();
        this.crashuuid = Utils.randomUUID();
        this.foreground = SessionManager.getInstance().getForeground() + "";
    }

    @Override
    public String toJsonLine() {
        JSONObject json = this.getBasicDataFixtureJson();
        try {
            JSONObject node = new JSONObject();
            node.put("stack", (Object)this.stacktrace);
            node.put("error", (Object)this.message);
            json.put("crash", (Object)node);
            json.put("screensize", (Object)this.screenSize);
            json.put("dumptype", (Object)EnumErrorType.script.toString());
            json.put("handled", (Object)this.handled);
            json.put("rooted", (Object)this.rooted);
            json.put("count", this.count);
            json.put("language", (Object)this.language);
            json.put("gpsstatus", (Object)this.gpsStatus.toString());
            json.put("msfromstart", (Object)this.msFromStart);
            if (this.breadcrumbs != null && this.breadcrumbs.length() > 0) {
                json.put("breadcrumbs", (Object)this.breadcrumbs);
            }
            if (Properties.SEND_LOG) {
                String logcat = Utils.readLogs();
                json.put("log", (Object)logcat);
            } else {
                json.put("log", (Object)"NA");
            }
            json.put("memsystotal", (Object)this.memSysTotal);
            json.put("memsysavailable", (Object)this.memSysAvailable);
            json.put("romtotal", (Object)this.romTotal);
            json.put("romavailable", (Object)this.romFree);
            json.put("sdcardtotal", (Object)this.sdcardTotal);
            json.put("sdcardavailable", (Object)this.sdcardFree);
            json.put("crashuuid", (Object)this.crashuuid);
            json.put("crashtime", (Object)this.crashTime);
            json.put("foreground", (Object)this.foreground);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return json.toString() + Properties.getSeparator(this.type);
    }

    @Override
    public void send(NetSender netSender, boolean saveOnFail) {
        netSender.send(null, this.toJsonLine(), saveOnFail);
    }

    @Override
    public void save(BaseDataSaver dataSaver) {
        new AsyncDataSaver().save(this.toJsonLine());
    }

    @Override
    public void send(Context ctx, NetSender netSender, boolean saveOnFail) {
        netSender.send(null, this.toJsonLine(), saveOnFail);
    }
}

