/*
 * Decompiled with CFR 0.152.
 */
package com.xsj.crasheye;

import android.app.ActivityManager;
import android.content.Context;
import android.util.Base64;
import com.xsj.crasheye.BaseDTO;
import com.xsj.crasheye.BaseDataSaver;
import com.xsj.crasheye.EnumActionType;
import com.xsj.crasheye.EnumErrorType;
import com.xsj.crasheye.InterfaceDataType;
import com.xsj.crasheye.NativeExceptionDataSaver;
import com.xsj.crasheye.NetSender;
import com.xsj.crasheye.Properties;
import com.xsj.crasheye.session.SessionManager;
import com.xsj.crasheye.util.DeviceUtils;
import com.xsj.crasheye.util.EnumStateStatus;
import com.xsj.crasheye.util.Utils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class ActionNativeError
extends BaseDTO
implements InterfaceDataType {
    private String stacktrace = "";
    private Boolean handled = false;
    private String sigName;
    private EnumStateStatus gpsStatus;
    private String msFromStart;
    private String memSysLow;
    private String memSysThreshold;
    private String memAppMax;
    private String memAppAvailable;
    private String memAppTotal;
    private String memSysAvailable = null;
    private String memSysTotal = null;
    private String romTotal;
    private String romFree;
    private String sdcardTotal;
    private String sdcardFree;
    private JSONArray breadcrumbs;
    private String dumptype = EnumErrorType.ndk.toString();
    private String dumpFile;
    private Boolean lastNotSave = false;
    private String nativefile;
    private String foreground;
    private String crashTime;
    private String crashuuid = null;

    public ActionNativeError(String dumpFile) {
        super(EnumActionType.ndkerror, null);
        this.dumpFile = dumpFile;
        this.gpsStatus = Properties.IS_GPS_ON;
        this.msFromStart = Utils.getMilisFromStart();
        ActivityManager.MemoryInfo memoryInfo = new ActivityManager.MemoryInfo();
        Runtime rt = Runtime.getRuntime();
        long[] tmp = DeviceUtils.getRAMStat();
        this.memSysAvailable = String.valueOf((double)tmp[0] / DeviceUtils.GB_BYTE);
        this.memSysTotal = String.valueOf((double)tmp[1] / DeviceUtils.GB_BYTE);
        tmp = DeviceUtils.getROMStat();
        this.romFree = String.valueOf((double)tmp[0] / DeviceUtils.GB_BYTE);
        this.romTotal = String.valueOf((double)tmp[1] / DeviceUtils.GB_BYTE);
        tmp = DeviceUtils.getSDCardSpace();
        this.sdcardFree = String.valueOf((double)tmp[0] / DeviceUtils.GB_BYTE);
        this.sdcardTotal = String.valueOf((double)tmp[1] / DeviceUtils.GB_BYTE);
        this.memSysThreshold = String.valueOf((double)memoryInfo.threshold / 1048576.0);
        this.memSysLow = String.valueOf(memoryInfo.lowMemory);
        this.memAppMax = String.valueOf((double)rt.maxMemory() / 1048576.0);
        this.memAppAvailable = String.valueOf((double)rt.freeMemory() / 1048576.0);
        this.memAppTotal = String.valueOf((double)rt.totalMemory() / 1048576.0);
        this.breadcrumbs = Properties.breadcrumbs.getList();
        this.crashTime = Utils.getTime();
        this.crashuuid = Utils.randomUUID();
        this.foreground = SessionManager.getInstance().getForeground() + "";
    }

    public void SetNativeCrashData(String dumpFile) {
        try {
            File file = new File(dumpFile);
            int size = (int)file.length();
            byte[] bytes = new byte[size];
            BufferedInputStream buf = new BufferedInputStream(new FileInputStream(dumpFile));
            buf.read(bytes, 0, bytes.length);
            buf.close();
            this.nativefile = Base64.encodeToString((byte[])bytes, (int)2);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void SetLastUnSave() {
        this.lastNotSave = true;
    }

    public JSONObject toJson() {
        JSONObject json = this.getBasicDataFixtureJson();
        try {
            JSONObject node = new JSONObject();
            node.put("stack", (Object)this.stacktrace);
            node.put("error", (Object)this.sigName);
            node.put("dumpfile", (Object)this.dumpFile);
            node.put("file", (Object)this.nativefile);
            json.put("dumptype", (Object)this.dumptype);
            json.put("handled", (Object)this.handled);
            json.put("rooted", (Object)this.rooted);
            if (!this.lastNotSave.booleanValue()) {
                json.put("gpsstatus", (Object)this.gpsStatus.toString());
                json.put("msfromstart", (Object)this.msFromStart);
                if (this.breadcrumbs != null && this.breadcrumbs.length() > 0) {
                    json.put("breadcrumbs", (Object)this.breadcrumbs);
                }
                json.put("memsysLow", (Object)this.memSysLow);
                json.put("memsystotal", (Object)this.memSysTotal);
                json.put("memsysavailable", (Object)this.memSysAvailable);
                json.put("romtotal", (Object)this.romTotal);
                json.put("romavailable", (Object)this.romFree);
                json.put("sdcardtotal", (Object)this.sdcardTotal);
                json.put("sdcardavailable", (Object)this.sdcardFree);
                json.put("memsysthreshold", (Object)this.memSysThreshold);
                json.put("memappmax", (Object)this.memAppMax);
                json.put("memappavailable", (Object)this.memAppAvailable);
                json.put("memapptotal", (Object)this.memAppTotal);
                json.put("crashuuid", (Object)this.crashuuid);
                json.put("crashtime", (Object)this.crashTime);
                json.put("foreground", (Object)this.foreground);
            } else {
                json.remove("extradata");
                json.remove("transactions");
            }
            json.put("crash", (Object)node);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return json;
    }

    @Override
    public String toJsonLine() {
        return this.toJson().toString();
    }

    @Override
    public void send(NetSender netSender, boolean saveOnFail) {
        netSender.send(null, this.toJsonLine(), saveOnFail);
    }

    @Override
    public void save(BaseDataSaver dataSaver) {
        new NativeExceptionDataSaver().save(this.toJsonLine());
    }

    @Override
    public void send(Context ctx, NetSender netSender, boolean saveOnFail) {
        netSender.send(null, this.toJsonLine(), saveOnFail);
    }
}

