/*
 * Decompiled with CFR 0.152.
 */
package com.youloft.statistics;

import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.appsflyer.AppsFlyerConversionListener;
import com.appsflyer.AppsFlyerInAppPurchaseValidatorListener;
import com.appsflyer.AppsFlyerLib;
import com.appsflyer.adrevenue.AppsFlyerAdRevenue;
import com.code.youloft.Constants;
import com.facebook.FacebookSdk;
import com.facebook.appevents.AppEventsLogger;
import com.google.firebase.analytics.FirebaseAnalytics;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.youloft.api.ApiManager;
import com.youloft.api.config.PurchaseBean;
import com.youloft.api.config.PurchaseObj;
import com.youloft.callbcak.NetCallBack;
import com.youloft.core.UnityPlayerBridge;
import com.youloft.core.utils.LogUtils;
import com.youloft.core.utils.PackageUtils;
import com.youloft.core.utils.SPUtils;
import java.math.BigDecimal;
import java.util.Currency;
import java.util.HashMap;
import java.util.Map;

public class StatisticsManager {
    private static final String TAG = "PottingAndroid";
    private static volatile StatisticsManager instance = null;
    private static FirebaseAnalytics mFirebaseAnalytics;
    private static boolean isUp;
    private static AppEventsLogger appEventsLogger;
    public static String conversionData;
    private static double Total_Ads_Revenue;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StatisticsManager getInstance() {
        Class<StatisticsManager> clazz = StatisticsManager.class;
        synchronized (StatisticsManager.class) {
            if (null == instance) {
                instance = new StatisticsManager();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public static void initStatistics(Application application, String faceBookStatisticsId, String AF_DEV_KEY, String UmengId, String umengChannel) {
        LogUtils.d(TAG, "faceBookStatisticsId:" + faceBookStatisticsId);
        if (!TextUtils.isEmpty((CharSequence)faceBookStatisticsId)) {
            FacebookSdk.setApplicationId((String)faceBookStatisticsId);
            FacebookSdk.sdkInitialize((Context)application);
            AppEventsLogger.activateApp((Application)application);
            appEventsLogger = AppEventsLogger.newLogger((Context)application);
            LogUtils.i(TAG, faceBookStatisticsId);
        }
        mFirebaseAnalytics = FirebaseAnalytics.getInstance((Context)application);
        AppsFlyerConversionListener conversionDataListener = new AppsFlyerConversionListener(){

            public void onConversionDataSuccess(Map<String, Object> map) {
                for (String attrName : map.keySet()) {
                    LogUtils.d(StatisticsManager.TAG, "onInstallConversionDataLoaded: " + attrName + " = " + map.get(attrName));
                }
                Object media_source = map.get("media_source");
                if (media_source != null) {
                    SPUtils.getInstance().put("CHANNEL", media_source.toString());
                } else {
                    SPUtils.getInstance().put("CHANNEL", "\u81ea\u7136\u5b89\u88c5");
                }
                StatisticsManager.myCustomEvent("channel", "{\"channel\":\"" + media_source + "\"}");
                StatisticsManager.customEventAf("conversionData", new Gson().toJson(map));
                LogUtils.d("conversionData", new Gson().toJson(map));
                UnityPlayerBridge.sendMsg("PottingMobile", "ConversionData", new Gson().toJson(map));
                conversionData = new Gson().toJson(map);
                ApiManager.dataReport("conversionData", "", "", "");
            }

            public void onConversionDataFail(String s) {
                LogUtils.d(StatisticsManager.TAG, s);
                if (isUp) {
                    StatisticsManager.customEventAf("conversionDataError", s);
                    isUp = true;
                }
            }

            public void onAppOpenAttribution(Map<String, String> map) {
                for (String attrName : map.keySet()) {
                    LogUtils.d(StatisticsManager.TAG, "onAppOpenAttribution: " + attrName + " = " + map.get(attrName));
                }
                StatisticsManager.myCustomEvent("onAppOpenAttributionData", new Gson().toJson(map));
            }

            public void onAttributionFailure(String s) {
                LogUtils.d(StatisticsManager.TAG, "onAttributionFailure" + s);
            }
        };
        AppsFlyerAdRevenue.Builder afRevnueBuilder = new AppsFlyerAdRevenue.Builder(application);
        try {
            AppsFlyerAdRevenue.initialize((AppsFlyerAdRevenue)afRevnueBuilder.build());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        AppsFlyerLib.getInstance().registerConversionListener((Context)application, conversionDataListener);
        LogUtils.i(TAG, AF_DEV_KEY);
        SPUtils.getInstance().put("version_code", String.valueOf(PackageUtils.getVersionCode((Context)application)));
        SPUtils.getInstance().put("version_name", PackageUtils.getVersionName((Context)application));
        LogUtils.d(TAG, PackageUtils.getVersionName((Context)application) + "");
        LogUtils.d(TAG, PackageUtils.getVersionCode((Context)application) + "");
    }

    public static void myCustomEvent(String eventName, String eventValues) {
        if (ApiManager.getContext() == null) {
            return;
        }
        Map<String, String> maps = new HashMap<String, String>();
        Map<String, String> umMaps = new HashMap<String, String>();
        try {
            maps = (Map)new Gson().fromJson(eventValues, new TypeToken<Map<String, Object>>(){}.getType());
            umMaps = (Map)new Gson().fromJson(eventValues, new TypeToken<Map<String, String>>(){}.getType());
        }
        catch (Exception e) {
            e.printStackTrace();
            maps.put("DataError", eventValues);
            umMaps.put("DataError", eventValues);
        }
        maps.put("channel", SPUtils.getInstance().getString("CHANNEL"));
        maps.put("platform", "Android");
        maps.put("pottingMobSDKVersion", "2.8.0");
        umMaps.put("channel", SPUtils.getInstance().getString("CHANNEL"));
        umMaps.put("platform", "Android");
        umMaps.put("pottingMobSDKVersion", "2.8.0");
        AppsFlyerLib.getInstance().logEvent(ApiManager.getContext().getApplicationContext(), eventName, maps);
        StatisticsManager.fireBaseCustomEvent(eventName, umMaps);
        StatisticsManager.faceBookCustomEvent(eventName, umMaps);
        StatisticsManager.savePreviousEventId(eventName);
        LogUtils.i(TAG, "eventName:" + eventName + "  eventValues:" + eventValues);
    }

    public static void customEvent(String eventName, String eventValues) {
        if (ApiManager.getContext() == null) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)eventName)) {
            return;
        }
        Map<String, String> umMaps = new HashMap<String, String>();
        Map<String, String> maps = new HashMap<String, String>();
        if (!TextUtils.isEmpty((CharSequence)eventValues)) {
            try {
                umMaps = (Map)new Gson().fromJson(eventValues, new TypeToken<Map<String, String>>(){}.getType());
                maps = (Map)new Gson().fromJson(eventValues, new TypeToken<Map<String, Object>>(){}.getType());
            }
            catch (Exception e) {
                e.printStackTrace();
                maps.put("Dataerror", eventValues);
                if (umMaps == null) {
                    umMaps = new HashMap();
                }
                umMaps.put("Dataerror", eventValues);
            }
        }
        if (umMaps == null) {
            umMaps = new HashMap();
        }
        umMaps.putAll(StatisticsManager.getCommonParams());
        if (maps == null) {
            maps = new HashMap();
        }
        maps.putAll(StatisticsManager.getCommonParams());
        AppsFlyerLib.getInstance().logEvent(ApiManager.getContext().getApplicationContext(), eventName, maps);
        StatisticsManager.fireBaseCustomEvent(eventName, umMaps);
        StatisticsManager.faceBookCustomEvent(eventName, umMaps);
        StatisticsManager.savePreviousEventId(eventName);
        LogUtils.i(TAG, "eventName:" + eventName + "  eventValues:" + eventValues);
    }

    public static void faceBookLogEvent(String eventName, double valueToSum, String eventValues) {
        Map<String, String> maps = new HashMap<String, String>();
        Bundle bundle = new Bundle();
        if (!TextUtils.isEmpty((CharSequence)eventValues)) {
            try {
                maps = (Map)new Gson().fromJson(eventValues, new TypeToken<Map<String, String>>(){}.getType());
            }
            catch (Exception e) {
                e.printStackTrace();
                maps.put("Dataerror", eventValues);
            }
        }
        for (Map.Entry entry : maps.entrySet()) {
            bundle.putString((String)entry.getKey(), (String)entry.getValue());
        }
        bundle.putAll(StatisticsManager.getCommonBundle());
        if (appEventsLogger == null) {
            LogUtils.e(TAG, "appEventsLogger\u4e0d\u80fd\u4e3a\u7a7a");
        } else {
            appEventsLogger.logEvent(eventName, valueToSum, bundle);
        }
    }

    public static void customEventFirebase(String eventName, String eventValues) {
        if (ApiManager.getContext() == null) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)eventName)) {
            return;
        }
        Map<String, String> umMaps = new HashMap<String, String>();
        if (!TextUtils.isEmpty((CharSequence)eventValues)) {
            try {
                umMaps = (Map)new Gson().fromJson(eventValues, new TypeToken<Map<String, String>>(){}.getType());
            }
            catch (Exception e) {
                e.printStackTrace();
                if (umMaps == null) {
                    umMaps = new HashMap();
                }
                umMaps.put("Dataerror", eventValues);
            }
        }
        if (umMaps == null) {
            umMaps = new HashMap();
        }
        umMaps.putAll(StatisticsManager.getCommonParams());
        StatisticsManager.fireBaseCustomEvent(eventName, umMaps);
        StatisticsManager.savePreviousEventId(eventName);
        LogUtils.i(TAG, "eventName:" + eventName + "  eventValues:" + eventValues);
    }

    public static void customEventFacebook(String eventName, String eventValues) {
        if (ApiManager.getContext() == null) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)eventName)) {
            return;
        }
        Map<String, String> umMaps = new HashMap<String, String>();
        if (!TextUtils.isEmpty((CharSequence)eventValues)) {
            try {
                umMaps = (Map)new Gson().fromJson(eventValues, new TypeToken<Map<String, String>>(){}.getType());
            }
            catch (Exception e) {
                e.printStackTrace();
                if (umMaps == null) {
                    umMaps = new HashMap();
                }
                umMaps.put("Dataerror", eventValues);
            }
        }
        if (umMaps == null) {
            umMaps = new HashMap();
        }
        umMaps.putAll(StatisticsManager.getCommonParams());
        StatisticsManager.faceBookCustomEvent(eventName, umMaps);
        StatisticsManager.savePreviousEventId(eventName);
        LogUtils.i(TAG, "eventName:" + eventName + "  eventValues:" + eventValues);
    }

    public static void customEventAf(String eventName, String eventValues) {
        if (ApiManager.getContext() == null) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)eventName)) {
            return;
        }
        Map<String, String> maps = new HashMap<String, String>();
        if (!TextUtils.isEmpty((CharSequence)eventValues)) {
            try {
                maps = (Map)new Gson().fromJson(eventValues, new TypeToken<Map<String, Object>>(){}.getType());
            }
            catch (Exception e) {
                e.printStackTrace();
                maps.put("Dataerror", eventValues);
            }
        }
        if (maps == null) {
            maps = new HashMap();
        }
        maps.putAll(StatisticsManager.getCommonParams());
        AppsFlyerLib.getInstance().logEvent(ApiManager.getContext().getApplicationContext(), eventName, maps);
        StatisticsManager.savePreviousEventId(eventName);
        LogUtils.i(TAG, "eventName:" + eventName + "  eventValues:" + eventValues);
    }

    public static void customEventUm(String eventName, String eventValues) {
        if (ApiManager.getContext() == null) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)eventName)) {
            return;
        }
        Map<String, String> umMaps = new HashMap<String, String>();
        if (!TextUtils.isEmpty((CharSequence)eventValues)) {
            try {
                umMaps = (Map)new Gson().fromJson(eventValues, new TypeToken<Map<String, String>>(){}.getType());
            }
            catch (Exception e) {
                e.printStackTrace();
                if (umMaps == null) {
                    umMaps = new HashMap();
                }
                umMaps.put("Dataerror", eventValues);
            }
        }
        if (umMaps == null) {
            umMaps = new HashMap();
        }
        umMaps.putAll(StatisticsManager.getCommonParams());
        StatisticsManager.savePreviousEventId(eventName);
        LogUtils.i(TAG, "eventName:" + eventName + "  eventValues:" + eventValues);
    }

    public static void startLevel(String level) {
        if (ApiManager.getContext() == null) {
            return;
        }
        HashMap<String, String> umMaps = new HashMap<String, String>();
        umMaps.put("game_level", level);
        umMaps.putAll(StatisticsManager.getCommonParams());
        HashMap<String, String> maps = new HashMap<String, String>();
        maps.put("game_level", level);
        maps.putAll(StatisticsManager.getCommonParams());
        try {
            AppsFlyerLib.getInstance().logEvent(ApiManager.getContext().getApplicationContext(), "um_plus_game_startlevel", maps);
            StatisticsManager.savePreviousEventId("um_plus_game_startlevel");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        LogUtils.i(TAG, "startLevel:" + level);
        StatisticsManager.setFireBaseLevelStart(level);
        StatisticsManager.logUm_plus_game_startlevelEvent(level);
    }

    public static void finishLevel(String level) {
        if (ApiManager.getContext() == null) {
            return;
        }
        HashMap<String, String> maps = new HashMap<String, String>();
        maps.put("game_level", level);
        maps.putAll(StatisticsManager.getCommonParams());
        try {
            AppsFlyerLib.getInstance().logEvent(ApiManager.getContext().getApplicationContext(), "um_plus_game_finishlevel", maps);
            StatisticsManager.savePreviousEventId("um_plus_game_finishlevel");
            LogUtils.i(TAG, "finishLevel:" + level);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        StatisticsManager.logUm_plus_game_finishlevelEvent(level);
        StatisticsManager.setFireBaseLevelEnd(level, 1);
    }

    public static void failLevel(String level) {
        if (ApiManager.getContext() == null) {
            return;
        }
        HashMap<String, String> maps = new HashMap<String, String>();
        maps.put("game_level", level);
        maps.putAll(StatisticsManager.getCommonParams());
        try {
            AppsFlyerLib.getInstance().logEvent(ApiManager.getContext().getApplicationContext(), "um_plus_game_faillevel", maps);
            StatisticsManager.savePreviousEventId("um_plus_game_faillevel");
            LogUtils.i(TAG, "failLevel:" + level);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        StatisticsManager.logUm_plus_game_faillevelEvent(level);
        StatisticsManager.setFireBaseLevelEnd(level, 0);
    }

    public static void buy(String item, int number, double price) {
        if (ApiManager.getContext() == null) {
            return;
        }
        HashMap<String, String> maps = new HashMap<String, String>();
        maps.put("game_item", item);
        maps.put("game_amount", String.valueOf(number));
        maps.put("game_price", String.valueOf(price));
        maps.putAll(StatisticsManager.getCommonParams());
        try {
            AppsFlyerLib.getInstance().logEvent(ApiManager.getContext().getApplicationContext(), "um_plus_game_pay", maps);
            StatisticsManager.savePreviousEventId("um_plus_game_pay");
            LogUtils.i(TAG, "buy" + ((Object)maps).toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        StatisticsManager.logUm_plus_game_payEvent(item, number, price);
        StatisticsManager.fireBaseBuy(item, number, price);
    }

    public static void pay(double money, double coin, int source) {
        if (ApiManager.getContext() == null) {
            return;
        }
        HashMap<String, String> maps = new HashMap<String, String>();
        maps.put("game_cash", String.valueOf(money));
        maps.put("game_source", String.valueOf(source));
        maps.put("game_coin", String.valueOf(coin));
        maps.putAll(StatisticsManager.getCommonParams());
        try {
            AppsFlyerLib.getInstance().logEvent(ApiManager.getContext().getApplicationContext(), "um_plus_game_pay", maps);
            StatisticsManager.savePreviousEventId("um_plus_game_pay");
            LogUtils.i(TAG, "pay" + ((Object)maps).toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        StatisticsManager.logUm_plus_game_payEvent(money, source, coin);
    }

    public static void pay(double money, String item, int number, double price, int source) {
        if (ApiManager.getContext() == null) {
            return;
        }
        HashMap<String, String> maps = new HashMap<String, String>();
        maps.put("game_cash", String.valueOf(money));
        maps.put("game_source", String.valueOf(source));
        maps.put("game_item", item);
        maps.put("game_amount", String.valueOf(number));
        maps.put("game_coin", String.valueOf(price));
        maps.putAll(StatisticsManager.getCommonParams());
        try {
            AppsFlyerLib.getInstance().logEvent(ApiManager.getContext().getApplicationContext(), "um_plus_game_pay", maps);
            StatisticsManager.savePreviousEventId("um_plus_game_pay");
            LogUtils.i(TAG, "pay" + ((Object)maps).toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void buyProduct(double realPrice, String ProductId) {
        if (ApiManager.getContext() == null) {
            return;
        }
        double price = realPrice * 0.7;
        HashMap<String, Object> eventValues = new HashMap<String, Object>();
        eventValues.put("af_revenue", price);
        eventValues.put("af_currency", "USD");
        eventValues.put("af_content_type", ProductId);
        eventValues.putAll(StatisticsManager.getCommonParams());
        try {
            AppsFlyerLib.getInstance().logEvent(ApiManager.getContext().getApplicationContext(), "af_purchase", eventValues);
            StatisticsManager.savePreviousEventId("buyProduct");
            LogUtils.i(TAG, "pay" + ((Object)eventValues).toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        LogUtils.i(TAG, "eventName:af_purchase  eventValues:" + eventValues);
        StatisticsManager.logUm_plus_game_payEvent(price, "USD");
        StatisticsManager.fireBasePay(price, "USD");
        JSONObject money = new JSONObject();
        money.put("money", (Object)price);
        money.put("currency", (Object)"USD");
        ApiManager.dataReport("payed", ProductId, "\u5185\u8d2d", money);
    }

    public static void buyProduct(long price, String ProductId, String currency) {
        if (ApiManager.getContext() == null) {
            return;
        }
        BigDecimal finalAmount = new BigDecimal(String.valueOf((double)price * 0.7)).divide(new BigDecimal("1000000"));
        String p = finalAmount.toPlainString();
        HashMap<String, String> eventValues = new HashMap<String, String>();
        eventValues.put("af_revenue", p);
        eventValues.put("af_currency", currency);
        eventValues.put("af_content_type", ProductId);
        eventValues.putAll(StatisticsManager.getCommonParams());
        try {
            AppsFlyerLib.getInstance().logEvent(ApiManager.getContext().getApplicationContext(), "af_purchase", eventValues);
            StatisticsManager.savePreviousEventId("buyProduct");
            LogUtils.i(TAG, "pay" + ((Object)eventValues).toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        LogUtils.i(TAG, "eventName:af_purchase  eventValues:" + eventValues);
        StatisticsManager.logUm_plus_game_payEvent(finalAmount.doubleValue(), currency);
        StatisticsManager.fireBasePay(finalAmount.doubleValue(), currency);
    }

    public static void validateAndTrackInAppPurchase(String publicKey, String signature, final String purchaseData, final long price, final String currency, String skuType, String actId) {
        Log.e((String)TAG, (String)("validateAndTrackInAppPurchasecurrency=" + currency));
        final PurchaseBean bean = (PurchaseBean)JSONObject.parseObject((String)purchaseData, PurchaseBean.class);
        if (bean == null) {
            return;
        }
        int type = -1;
        if (TextUtils.equals((CharSequence)"inapp", (CharSequence)skuType)) {
            type = 0;
        }
        if (TextUtils.equals((CharSequence)"subs", (CharSequence)skuType)) {
            type = 1;
        }
        PurchaseObj purchaseObj = new PurchaseObj();
        purchaseObj.setPublicKey(publicKey);
        purchaseObj.setSignature(signature);
        purchaseObj.setPurchaseData(purchaseData);
        purchaseObj.setPrice(price);
        purchaseObj.setCurrency(currency);
        purchaseObj.setPurchaseBean(bean);
        purchaseObj.setType(type);
        purchaseObj.setActId(actId);
        SPUtils.getInstance().put("PurchaseObj", JSONObject.toJSON((Object)purchaseObj).toString());
        ApiManager.googleValidate(bean.getPurchaseToken(), bean.getOrderId(), bean.getProductId(), type, actId, new NetCallBack(){

            @Override
            public void success(String decryptData) {
                SPUtils.getInstance().put("PurchaseObj", "");
                String mCurrency = currency;
                if (TextUtils.isEmpty((CharSequence)currency)) {
                    mCurrency = "USD";
                }
                JSONObject json = JSON.parseObject((String)decryptData);
                Integer uploadstate = json.getInteger("uploadstate");
                JSONObject js = JSON.parseObject((String)purchaseData);
                js.put("orderstate", (Object)json.getInteger("orderstate"));
                UnityPlayerBridge.sendMsg("PottingMobile", "Validate", js.toJSONString());
                if (uploadstate == 0) {
                    StatisticsManager.buyProduct(price, bean.getProductId(), mCurrency);
                }
            }

            @Override
            public void failed(String s) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("skuid", (Object)bean.getProductId());
                jsonObject.put("orderid", (Object)bean.getOrderId());
                jsonObject.put("userid", (Object)ApiManager.mUserId);
                StatisticsManager.customEvent("youloftpayuploadfail", jsonObject.toJSONString());
            }
        });
        JSONObject money = new JSONObject();
        BigDecimal finalAmount = new BigDecimal(String.valueOf(price)).divide(new BigDecimal("1000000"));
        money.put("money", (Object)finalAmount);
        money.put("currency", (Object)currency);
        ApiManager.dataReport("payed", bean.getProductId(), "\u5185\u8d2d", money);
    }

    public static void validateAndTrackInAppPurchase(Context context, String publicKey, String signature, String purchaseData, String price, String currency, HashMap<String, String> additionalParameters) {
        AppsFlyerLib.getInstance().validateAndLogInAppPurchase(context, publicKey, signature, purchaseData, price, currency, additionalParameters);
        AppsFlyerLib.getInstance().registerValidatorListener(context, new AppsFlyerInAppPurchaseValidatorListener(){

            public void onValidateInApp() {
                LogUtils.d(StatisticsManager.TAG, "Purchase validated successfully");
            }

            public void onValidateInAppFailure(String error) {
                LogUtils.d(StatisticsManager.TAG, "onValidateInAppFailure called: " + error);
            }
        });
    }

    public static void use(String item, int number, double price) {
        if (ApiManager.getContext() == null) {
            return;
        }
        HashMap<String, String> maps = new HashMap<String, String>();
        maps.put("game_item", item);
        maps.put("game_amount", String.valueOf(number));
        maps.put("game_price", String.valueOf(price));
        maps.putAll(StatisticsManager.getCommonParams());
        try {
            AppsFlyerLib.getInstance().logEvent(ApiManager.getContext().getApplicationContext(), "um_plus_game_use", maps);
            StatisticsManager.savePreviousEventId("um_plus_game_use");
            LogUtils.i(TAG, "use" + ((Object)maps).toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        StatisticsManager.logUm_plus_game_useEvent(item, number, price);
        StatisticsManager.fireBaseUse(item, number, price);
    }

    public static void bonus(double coin, int trigger) {
        if (ApiManager.getContext() == null) {
            return;
        }
        HashMap<String, String> maps = new HashMap<String, String>();
        maps.put("game_source", String.valueOf(trigger));
        maps.put("game_coin", String.valueOf(coin));
        maps.putAll(StatisticsManager.getCommonParams());
        try {
            AppsFlyerLib.getInstance().logEvent(ApiManager.getContext().getApplicationContext(), "um_plus_game_bonus", maps);
            StatisticsManager.savePreviousEventId("um_plus_game_bonus");
            LogUtils.i(TAG, "bonus" + ((Object)maps).toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        StatisticsManager.logUm_plus_game_bonusEvent(coin, trigger);
        StatisticsManager.setFireBaseEarnVirtualMoney(coin, trigger);
    }

    public static void bonus(String item, int num, double price, int trigger) {
        if (ApiManager.getContext() == null) {
            return;
        }
        HashMap<String, String> maps = new HashMap<String, String>();
        maps.put("game_item", item);
        maps.put("game_amount", String.valueOf(num));
        maps.put("game_price", String.valueOf(price));
        maps.put("game_source", String.valueOf(trigger));
        maps.putAll(StatisticsManager.getCommonParams());
        try {
            AppsFlyerLib.getInstance().logEvent(ApiManager.getContext().getApplicationContext(), "um_plus_game_bonus", maps);
            StatisticsManager.savePreviousEventId("um_plus_game_bonus");
            LogUtils.i(TAG, "bonus" + ((Object)maps).toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        StatisticsManager.logUm_plus_game_bonusEvent(item, num, price, trigger);
        StatisticsManager.setFireBaseEarnVirtualProduct(item, num, price, trigger);
    }

    private static void setFireBasePlayerLevel(int level) {
        Bundle bundle = new Bundle();
        bundle.putString("level", String.valueOf(level));
        bundle.putAll(StatisticsManager.getCommonBundle());
        if (mFirebaseAnalytics == null) {
            LogUtils.e(TAG, "mFirebaseAnalytics\u4e0d\u80fd\u4e3a\u7a7a");
        } else {
            mFirebaseAnalytics.logEvent("level_up", bundle);
        }
    }

    private static void onFireBasePlayerSignIn(String from, String id2) {
        Bundle bundle = new Bundle();
        bundle.putString("method", from);
        bundle.putString("userId", id2);
        bundle.putAll(StatisticsManager.getCommonBundle());
        if (mFirebaseAnalytics == null) {
            LogUtils.e(TAG, "mFirebaseAnalytics\u4e0d\u80fd\u4e3a\u7a7a");
        } else {
            mFirebaseAnalytics.logEvent("login", bundle);
        }
    }

    private static void setFireBaseLevelStart(String level) {
        Bundle bundle = new Bundle();
        bundle.putString("level_name", level);
        bundle.putAll(StatisticsManager.getCommonBundle());
        if (mFirebaseAnalytics == null) {
            LogUtils.e(TAG, "mFirebaseAnalytics\u4e0d\u80fd\u4e3a\u7a7a");
        } else {
            mFirebaseAnalytics.logEvent("level_start", bundle);
        }
    }

    private static void setFireBaseLevelEnd(String level, int result) {
        Bundle bundle = new Bundle();
        bundle.putString("level_name", level);
        bundle.putInt("success", result);
        bundle.putAll(StatisticsManager.getCommonBundle());
        if (mFirebaseAnalytics == null) {
            LogUtils.e(TAG, "mFirebaseAnalytics\u4e0d\u80fd\u4e3a\u7a7a");
        } else {
            mFirebaseAnalytics.logEvent("level_end", bundle);
        }
    }

    private static void setFireBaseEarnVirtualMoney(double coin, int trigger) {
        Bundle bundle = new Bundle();
        bundle.putInt("virtual_currency_name", trigger);
        bundle.putDouble("value", coin);
        bundle.putAll(StatisticsManager.getCommonBundle());
        if (mFirebaseAnalytics == null) {
            LogUtils.e(TAG, "mFirebaseAnalytics\u4e0d\u80fd\u4e3a\u7a7a");
        } else {
            mFirebaseAnalytics.logEvent("earn_virtual_currency", bundle);
        }
    }

    private static void setFireBaseEarnVirtualProduct(String item, int num, double price, int trigger) {
        Bundle bundle = new Bundle();
        bundle.putString("item_name", item);
        bundle.putInt("quantity", num);
        bundle.putDouble("price", price);
        bundle.putInt("virtual_currency_name", trigger);
        bundle.putAll(StatisticsManager.getCommonBundle());
        if (mFirebaseAnalytics == null) {
            LogUtils.e(TAG, "mFirebaseAnalytics\u4e0d\u80fd\u4e3a\u7a7a");
        } else {
            mFirebaseAnalytics.logEvent("earn_virtual_currency", bundle);
        }
    }

    private static void fireBaseBuy(String item, int number, double price) {
        Bundle bundle = new Bundle();
        bundle.putString("item_name", item);
        bundle.putInt("quantity", number);
        bundle.putDouble("price", price);
        bundle.putAll(StatisticsManager.getCommonBundle());
        if (mFirebaseAnalytics == null) {
            LogUtils.e(TAG, "mFirebaseAnalytics\u4e0d\u80fd\u4e3a\u7a7a");
        } else {
            mFirebaseAnalytics.logEvent("spend_virtual_currency", bundle);
        }
    }

    private static void fireBasePay(double price, String currency) {
        Bundle bundle = new Bundle();
        bundle.putString("coupon", "");
        bundle.putString("currency", currency);
        try {
            bundle.putDouble("value", price);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        bundle.putAll(StatisticsManager.getCommonBundle());
        if (mFirebaseAnalytics == null) {
            LogUtils.e(TAG, "mFirebaseAnalytics\u4e0d\u80fd\u4e3a\u7a7a");
        } else {
            mFirebaseAnalytics.logEvent("purchase", bundle);
        }
    }

    private static void fireBaseBuy(String productId, String currency, String type, String price) {
        if (mFirebaseAnalytics == null) {
            LogUtils.e(TAG, "mFirebaseAnalytics\u4e0d\u80fd\u4e3a\u7a7a");
            return;
        }
        Bundle bundle = new Bundle();
        bundle.putString("af_revenue", price);
        bundle.putString("af_currency", currency);
        bundle.putString("af_content_type", type);
        bundle.putString("af_content_id", productId);
        bundle.putAll(StatisticsManager.getCommonBundle());
        mFirebaseAnalytics.logEvent("af_purchase", bundle);
    }

    private static void fireBaseUse(String item, int number, double price) {
        Bundle bundle = new Bundle();
        bundle.putString("item_name", item);
        bundle.putInt("quantity", number);
        bundle.putDouble("price", price);
        bundle.putAll(StatisticsManager.getCommonBundle());
        if (mFirebaseAnalytics == null) {
            LogUtils.e(TAG, "mFirebaseAnalytics\u4e0d\u80fd\u4e3a\u7a7a");
        } else {
            mFirebaseAnalytics.logEvent("SPEND_VIRTUAL_PROPS", bundle);
        }
    }

    private static void fireBaseCustomEvent(String eventName, Map<String, String> maps) {
        Bundle bundle = new Bundle();
        for (Map.Entry<String, String> entry : maps.entrySet()) {
            bundle.putString(entry.getKey(), entry.getValue());
        }
        bundle.putAll(StatisticsManager.getCommonBundle());
        if (mFirebaseAnalytics == null) {
            LogUtils.e(TAG, "mFirebaseAnalytics\u4e0d\u80fd\u4e3a\u7a7a");
        } else {
            mFirebaseAnalytics.logEvent(eventName, bundle);
        }
    }

    public static void fireBaseCustomEvent(String eventName, Bundle bundle) {
        if (mFirebaseAnalytics == null) {
            LogUtils.e(TAG, "mFirebaseAnalytics\u4e0d\u80fd\u4e3a\u7a7a");
        } else {
            mFirebaseAnalytics.logEvent(eventName, bundle);
            double aDouble = bundle.getDouble("value");
            float total_ads_revenue = SPUtils.getInstance().getFloat("Total_Ads_Revenue");
            Total_Ads_Revenue = aDouble + (double)total_ads_revenue;
            bundle.putDouble("value", Total_Ads_Revenue);
            mFirebaseAnalytics.logEvent("Total_Ads_Revenue", bundle);
            if (Total_Ads_Revenue > Constants.adrevenue) {
                mFirebaseAnalytics.logEvent("Total_Ads_Revenue_001", bundle);
                Total_Ads_Revenue = 0.0;
            }
            SPUtils.getInstance().put("Total_Ads_Revenue", (float)Total_Ads_Revenue);
        }
    }

    private static void logUm_plus_game_startlevelEvent(String game_level) {
        if (appEventsLogger == null) {
            return;
        }
        Bundle params = new Bundle();
        params.putString("game_level", game_level);
        params.putAll(StatisticsManager.getCommonBundle());
        appEventsLogger.logEvent("um_plus_game_startlevel", params);
    }

    private static void logUm_plus_game_finishlevelEvent(String game_level) {
        if (appEventsLogger == null) {
            return;
        }
        Bundle params = new Bundle();
        params.putString("game_level", game_level);
        params.putAll(StatisticsManager.getCommonBundle());
        appEventsLogger.logEvent("um_plus_game_finishlevel", params);
    }

    private static void logUm_plus_game_faillevelEvent(String game_level) {
        if (appEventsLogger == null) {
            return;
        }
        Bundle params = new Bundle();
        params.putString("game_level", game_level);
        params.putAll(StatisticsManager.getCommonBundle());
        appEventsLogger.logEvent("um_plus_game_faillevel", params);
    }

    private static void logUm_plus_game_payEvent(String game_item, int game_amount, double game_price) {
        if (appEventsLogger == null) {
            return;
        }
        Bundle params = new Bundle();
        params.putString("game_item", game_item);
        params.putInt("game_amount", game_amount);
        params.putDouble("game_price", game_price);
        params.putAll(StatisticsManager.getCommonBundle());
        appEventsLogger.logEvent("um_plus_game_pay", params);
    }

    private static void logUm_plus_game_payEvent(double game_cash, int game_source, double game_coin) {
        if (appEventsLogger == null) {
            return;
        }
        Bundle params = new Bundle();
        params.putDouble("game_cash", game_cash);
        params.putInt("game_source", game_source);
        params.putDouble("game_coin", game_coin);
        params.putAll(StatisticsManager.getCommonBundle());
        appEventsLogger.logEvent("um_plus_game_pay", params);
    }

    private static void logUm_plus_game_payEvent(double price, String currency) {
        if (appEventsLogger == null) {
            return;
        }
        try {
            BigDecimal bd = new BigDecimal(price);
            Bundle bundle = new Bundle();
            bundle.putAll(StatisticsManager.getCommonBundle());
            appEventsLogger.logPurchase(bd, Currency.getInstance(currency), bundle);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void logUm_plus_game_buyEvent(String productId, String currency, String type, String price) {
        if (appEventsLogger == null) {
            return;
        }
        Bundle params = new Bundle();
        params.putString("af_revenue", price);
        params.putString("af_currency", currency);
        params.putString("af_content_type", type);
        params.putString("af_content_id", productId);
        params.putAll(StatisticsManager.getCommonBundle());
        appEventsLogger.logEvent("af_purchase", params);
    }

    public static void logUm_plus_game_useEvent(String game_item, int game_amount, double game_price) {
        if (appEventsLogger == null) {
            return;
        }
        Bundle params = new Bundle();
        params.putString("game_item", game_item);
        params.putInt("game_amount", game_amount);
        params.putDouble("game_price", game_price);
        params.putAll(StatisticsManager.getCommonBundle());
        appEventsLogger.logEvent("um_plus_game_use", params);
    }

    private static void logUm_plus_game_bonusEvent(double game_coin, int game_source) {
        if (appEventsLogger == null) {
            return;
        }
        Bundle params = new Bundle();
        params.putDouble("game_coin", game_coin);
        params.putInt("game_source", game_source);
        params.putAll(StatisticsManager.getCommonBundle());
        appEventsLogger.logEvent("um_plus_game_bonus", params);
    }

    private static void logUm_plus_game_bonusEvent(String game_item, int game_amount, double game_price, int game_source) {
        if (appEventsLogger == null) {
            return;
        }
        Bundle params = new Bundle();
        params.putString("game_item", game_item);
        params.putInt("game_amount", game_amount);
        params.putDouble("game_price", game_price);
        params.putInt("game_source", game_source);
        params.putAll(StatisticsManager.getCommonBundle());
        appEventsLogger.logEvent("um_plus_game_bonus", params);
    }

    private static void faceBookCustomEvent(String eventName, Map<String, String> maps) {
        Bundle bundle = new Bundle();
        for (Map.Entry<String, String> entry : maps.entrySet()) {
            bundle.putString(entry.getKey(), entry.getValue());
        }
        bundle.putAll(StatisticsManager.getCommonBundle());
        if (appEventsLogger == null) {
            LogUtils.e(TAG, "appEventsLogger\u4e0d\u80fd\u4e3a\u7a7a");
        } else {
            appEventsLogger.logEvent(eventName, bundle);
        }
    }

    private static void savePreviousEventId(String eventId) {
        SPUtils.getInstance().put("previous_eventid", eventId);
    }

    private static String getPreviousEventId() {
        return SPUtils.getInstance().getString("previous_eventid");
    }

    private static Map<String, String> getCommonParams() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("previous_eventid", StatisticsManager.getPreviousEventId());
        map.put("channel", SPUtils.getInstance().getString("CHANNEL"));
        map.put("platform", "Android");
        map.put("pottingMobSDKVersion", "2.8.0");
        String userId = ApiManager.mUserId;
        if (TextUtils.isEmpty((CharSequence)userId)) {
            userId = AppsFlyerLib.getInstance().getAppsFlyerUID((Context)ApiManager.getContext());
        }
        map.put("clientuserid", userId);
        map.put("versionName", SPUtils.getInstance().getString("version_name", ""));
        map.put("versionCode", SPUtils.getInstance().getString("version_code", ""));
        LogUtils.d("PreviousEventID", StatisticsManager.getPreviousEventId());
        return map;
    }

    private static Bundle getCommonBundle() {
        Bundle bundle = new Bundle();
        bundle.putString("previous_eventid", StatisticsManager.getPreviousEventId());
        bundle.putString("channel", SPUtils.getInstance().getString("CHANNEL"));
        bundle.putString("platform", "Android");
        bundle.putString("pottingMobSDKVersion", "2.8.0");
        bundle.putString("versionName", SPUtils.getInstance().getString("version_name", ""));
        bundle.putString("versionCode", SPUtils.getInstance().getString("version_code", ""));
        return bundle;
    }

    static {
        isUp = false;
        conversionData = "";
        Total_Ads_Revenue = 0.0;
    }
}

