/*
 * Decompiled with CFR 0.152.
 */
package com.youloft.core.utils;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.ActivityManager;
import android.app.Application;
import android.content.Context;
import android.content.res.Resources;
import android.os.Bundle;
import android.util.DisplayMetrics;
import androidx.core.content.FileProvider;
import com.youloft.core.utils.PermissionUtils;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public final class Utils {
    @SuppressLint(value={"StaticFieldLeak"})
    private static Application sApplication;
    private static final ActivityLifecycleImpl ACTIVITY_LIFECYCLE;
    static final AdaptScreenArgs ADAPT_SCREEN_ARGS;

    private Utils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static void init(Context context) {
        if (context == null) {
            Utils.init(Utils.getApplicationByReflect());
            return;
        }
        Utils.init((Application)context.getApplicationContext());
    }

    public static void init(Application app) {
        if (sApplication == null) {
            sApplication = app == null ? Utils.getApplicationByReflect() : app;
            sApplication.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)ACTIVITY_LIFECYCLE);
        }
    }

    public static Application getApp() {
        if (sApplication != null) {
            return sApplication;
        }
        Application app = Utils.getApplicationByReflect();
        Utils.init(app);
        return app;
    }

    private static Application getApplicationByReflect() {
        try {
            Class<?> activityThread = Class.forName("android.app.ActivityThread");
            Object thread = activityThread.getMethod("currentActivityThread", new Class[0]).invoke(null, new Object[0]);
            Object app = activityThread.getMethod("getApplication", new Class[0]).invoke(thread, new Object[0]);
            if (app == null) {
                throw new NullPointerException("u should init first");
            }
            return (Application)app;
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        throw new NullPointerException("u should init first");
    }

    static ActivityLifecycleImpl getActivityLifecycle() {
        return ACTIVITY_LIFECYCLE;
    }

    static LinkedList<Activity> getActivityList() {
        return Utils.ACTIVITY_LIFECYCLE.mActivityList;
    }

    static Context getTopActivityOrApp() {
        if (Utils.isAppForeground()) {
            Activity topActivity = ACTIVITY_LIFECYCLE.getTopActivity();
            return topActivity == null ? Utils.getApp() : topActivity;
        }
        return Utils.getApp();
    }

    static boolean isAppForeground() {
        ActivityManager am = (ActivityManager)Utils.getApp().getSystemService("activity");
        List info = am.getRunningAppProcesses();
        if (info == null || info.size() == 0) {
            return false;
        }
        for (ActivityManager.RunningAppProcessInfo aInfo : info) {
            if (aInfo.importance != 100) continue;
            return aInfo.processName.equals(Utils.getApp().getPackageName());
        }
        return false;
    }

    static void restoreAdaptScreen() {
        DisplayMetrics systemDm = Resources.getSystem().getDisplayMetrics();
        DisplayMetrics appDm = Utils.getApp().getResources().getDisplayMetrics();
        Activity activity = ACTIVITY_LIFECYCLE.getTopActivity();
        if (activity != null) {
            DisplayMetrics activityDm = activity.getResources().getDisplayMetrics();
            activityDm.density = Utils.ADAPT_SCREEN_ARGS.isVerticalSlide ? (float)activityDm.widthPixels / (float)Utils.ADAPT_SCREEN_ARGS.sizeInPx : (float)activityDm.heightPixels / (float)Utils.ADAPT_SCREEN_ARGS.sizeInPx;
            activityDm.scaledDensity = activityDm.density * (systemDm.scaledDensity / systemDm.density);
            activityDm.densityDpi = (int)(160.0f * activityDm.density);
            appDm.density = activityDm.density;
            appDm.scaledDensity = activityDm.scaledDensity;
            appDm.densityDpi = activityDm.densityDpi;
        } else {
            appDm.density = Utils.ADAPT_SCREEN_ARGS.isVerticalSlide ? (float)appDm.widthPixels / (float)Utils.ADAPT_SCREEN_ARGS.sizeInPx : (float)appDm.heightPixels / (float)Utils.ADAPT_SCREEN_ARGS.sizeInPx;
            appDm.scaledDensity = appDm.density * (systemDm.scaledDensity / systemDm.density);
            appDm.densityDpi = (int)(160.0f * appDm.density);
        }
    }

    static void cancelAdaptScreen() {
        DisplayMetrics systemDm = Resources.getSystem().getDisplayMetrics();
        DisplayMetrics appDm = Utils.getApp().getResources().getDisplayMetrics();
        Activity activity = ACTIVITY_LIFECYCLE.getTopActivity();
        if (activity != null) {
            DisplayMetrics activityDm = activity.getResources().getDisplayMetrics();
            activityDm.density = systemDm.density;
            activityDm.scaledDensity = systemDm.scaledDensity;
            activityDm.densityDpi = systemDm.densityDpi;
        }
        appDm.density = systemDm.density;
        appDm.scaledDensity = systemDm.scaledDensity;
        appDm.densityDpi = systemDm.densityDpi;
    }

    static boolean isAdaptScreen() {
        DisplayMetrics systemDm = Resources.getSystem().getDisplayMetrics();
        DisplayMetrics appDm = Utils.getApp().getResources().getDisplayMetrics();
        return systemDm.density != appDm.density;
    }

    static {
        ACTIVITY_LIFECYCLE = new ActivityLifecycleImpl();
        ADAPT_SCREEN_ARGS = new AdaptScreenArgs();
    }

    static class ActivityLifecycleImpl
    implements Application.ActivityLifecycleCallbacks {
        final LinkedList<Activity> mActivityList = new LinkedList();
        final HashMap<Object, OnAppStatusChangedListener> mStatusListenerMap = new HashMap();
        private int mForegroundCount = 0;
        private int mConfigCount = 0;

        ActivityLifecycleImpl() {
        }

        void addListener(Object object, OnAppStatusChangedListener listener) {
            this.mStatusListenerMap.put(object, listener);
        }

        void removeListener(Object object) {
            this.mStatusListenerMap.remove(object);
        }

        public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
            this.setTopActivity(activity);
        }

        public void onActivityStarted(Activity activity) {
            this.setTopActivity(activity);
            if (this.mForegroundCount <= 0) {
                this.postStatus(true);
            }
            if (this.mConfigCount < 0) {
                ++this.mConfigCount;
            } else {
                ++this.mForegroundCount;
            }
        }

        public void onActivityResumed(Activity activity) {
            this.setTopActivity(activity);
        }

        public void onActivityPaused(Activity activity) {
        }

        public void onActivityStopped(Activity activity) {
            if (activity.isChangingConfigurations()) {
                --this.mConfigCount;
            } else {
                --this.mForegroundCount;
                if (this.mForegroundCount <= 0) {
                    this.postStatus(false);
                }
            }
        }

        public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
        }

        public void onActivityDestroyed(Activity activity) {
            this.mActivityList.remove(activity);
        }

        private void postStatus(boolean isForeground) {
            if (this.mStatusListenerMap.isEmpty()) {
                return;
            }
            for (OnAppStatusChangedListener onAppStatusChangedListener : this.mStatusListenerMap.values()) {
                if (onAppStatusChangedListener == null) {
                    return;
                }
                if (isForeground) {
                    onAppStatusChangedListener.onForeground();
                    continue;
                }
                onAppStatusChangedListener.onBackground();
            }
        }

        private void setTopActivity(Activity activity) {
            if (activity.getClass() == PermissionUtils.PermissionActivity.class) {
                return;
            }
            if (this.mActivityList.contains(activity)) {
                if (!this.mActivityList.getLast().equals(activity)) {
                    this.mActivityList.remove(activity);
                    this.mActivityList.addLast(activity);
                }
            } else {
                this.mActivityList.addLast(activity);
            }
        }

        Activity getTopActivity() {
            Activity topActivity;
            if (!this.mActivityList.isEmpty() && (topActivity = this.mActivityList.getLast()) != null) {
                return topActivity;
            }
            Activity topActivityByReflect = this.getTopActivityByReflect();
            if (topActivityByReflect != null) {
                this.setTopActivity(topActivityByReflect);
            }
            return topActivityByReflect;
        }

        private Activity getTopActivityByReflect() {
            try {
                Class<?> activityThreadClass = Class.forName("android.app.ActivityThread");
                Object activityThread = activityThreadClass.getMethod("currentActivityThread", new Class[0]).invoke(null, new Object[0]);
                Field activitiesField = activityThreadClass.getDeclaredField("mActivityList");
                activitiesField.setAccessible(true);
                Map activities = (Map)activitiesField.get(activityThread);
                if (activities == null) {
                    return null;
                }
                for (Object activityRecord : activities.values()) {
                    Class<?> activityRecordClass = activityRecord.getClass();
                    Field pausedField = activityRecordClass.getDeclaredField("paused");
                    pausedField.setAccessible(true);
                    if (pausedField.getBoolean(activityRecord)) continue;
                    Field activityField = activityRecordClass.getDeclaredField("activity");
                    activityField.setAccessible(true);
                    return (Activity)activityField.get(activityRecord);
                }
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
            return null;
        }
    }

    static class AdaptScreenArgs {
        int sizeInPx;
        boolean isVerticalSlide;

        AdaptScreenArgs() {
        }
    }

    public static interface OnAppStatusChangedListener {
        public void onForeground();

        public void onBackground();
    }

    public static final class FileProvider4UtilCode
    extends FileProvider {
        public boolean onCreate() {
            Utils.init(this.getContext());
            return true;
        }
    }
}

