/*
 * Decompiled with CFR 0.152.
 */
package com.youloft.core;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.text.TextUtils;
import com.alibaba.fastjson.JSON;
import com.code.utils.SignCheckUtil;
import com.code.youloft.Constants;
import com.google.android.gms.games.AuthenticationResult;
import com.google.android.gms.games.GamesSignInClient;
import com.google.android.gms.games.PlayGames;
import com.google.android.gms.games.PlayGamesSdk;
import com.google.android.gms.games.Player;
import com.google.gson.Gson;
import com.youloft.advert.bean.FireBaseConfigAdsBean;
import com.youloft.api.ApiManager;
import com.youloft.callbcak.NetCallBack;
import com.youloft.core.utils.LogUtils;
import com.youloft.core.utils.MD5Util;
import com.youloft.core.utils.PackageUtils;
import com.youloft.login.LoginUtils;
import com.youloft.statistics.StatisticsManager;
import com.youloft.webview.WebViewActivity;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class YouLoftSdk {
    private static final String TAG = YouLoftSdk.class.getSimpleName();
    private static Activity mActivity;
    private static String mGameId;
    private static String mGameSecret;
    public static String PUBLIC_KEY;
    private static String FEEDBACK;

    public static void initUnityAdSdk(Activity context, String jsonAds, String faceBookStatisticsId, String app_flyers_id, String umengId, String umengChannel, String pk, String pangleId) {
        if (context == null) {
            LogUtils.e(TAG, "activity\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u521d\u59cb\u5316\u5931\u8d25\uff01\uff01\uff01");
            return;
        }
        ApiManager.setContext(context);
        PUBLIC_KEY = pk;
        mActivity = context;
        YouLoftSdk.initStatistics(context.getApplication(), faceBookStatisticsId, app_flyers_id, umengId, umengChannel);
        if (TextUtils.isEmpty((CharSequence)jsonAds)) {
            LogUtils.e("\u6ca1\u6709\u914d\u7f6e\u5e7f\u544aid");
        } else {
            YouLoftSdk.initAd(context, jsonAds, pangleId);
        }
        ApiManager.CheckParameter(faceBookStatisticsId, jsonAds, umengId, pangleId);
        ApiManager.ReUpPurchaseData();
        PlayGamesSdk.initialize((Context)context);
        GamesSignInClient gamesSignInClient = PlayGames.getGamesSignInClient((Activity)mActivity);
        String gameId = "";
        ApplicationInfo appInfo = null;
        try {
            appInfo = mActivity.getPackageManager().getApplicationInfo(mActivity.getPackageName(), 128);
            gameId = appInfo.metaData.getString("com.google.android.gms.games.APP_ID");
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        if (TextUtils.isEmpty((CharSequence)gameId) || TextUtils.equals((CharSequence)"\u8c37\u6b4c\u6e38\u620fid", (CharSequence)gameId)) {
            return;
        }
        gamesSignInClient.signIn();
        gamesSignInClient.isAuthenticated().addOnCompleteListener(isAuthenticatedTask -> {
            boolean isAuthenticated;
            boolean bl = isAuthenticated = isAuthenticatedTask.isSuccessful() && ((AuthenticationResult)isAuthenticatedTask.getResult()).isAuthenticated();
            if (isAuthenticated) {
                PlayGames.getPlayersClient((Activity)mActivity).getCurrentPlayer().addOnCompleteListener(mTask -> {
                    LogUtils.e(((Player)mTask.getResult()).getCurrentPlayerInfo() + "");
                    JSONObject jsonObject = new JSONObject();
                    try {
                        jsonObject.put("id", (Object)((Player)mTask.getResult()).getPlayerId());
                        jsonObject.put("name", (Object)((Player)mTask.getResult()).getDisplayName());
                        jsonObject.put("picture", (Object)((Player)mTask.getResult()).getIconImageUri());
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                    LoginUtils.getLoginSuccess(jsonObject, 2);
                    LogUtils.e(jsonObject.toString());
                });
            } else {
                LoginUtils.getLoginError("GoogleGame\u81ea\u52a8\u767b\u5f55\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25,\u8bf7\u624b\u52a8\u767b\u5f55" + ((AuthenticationResult)isAuthenticatedTask.getResult()).toString(), 2);
            }
        });
    }

    public static void initAndroidSdk(Activity context, FireBaseConfigAdsBean jsonAds, String faceBookStatisticsId, String app_flyers_id, String umengId, String umengChannel, String pangleId) {
        YouLoftSdk.initUnityAdSdk(context, new Gson().toJson((Object)jsonAds).toString(), faceBookStatisticsId, app_flyers_id, umengId, umengChannel, "", pangleId);
    }

    public static void setDebug(boolean isDebug) {
        Constants.isDebug = isDebug;
        LogUtils.setLogEnable(isDebug);
    }

    private static void initStatistics(Application application, String faceBookStatisticsId, String app_flyers_id, String umengId, String umengChannel) {
        StatisticsManager.initStatistics(application, faceBookStatisticsId, app_flyers_id, umengId, umengChannel);
    }

    private static void initAd(Activity activity, String mJsonAds, String appId) {
        try {
            Class<?> aClass = Class.forName("com.youloft.advert.YouLoftAdManager");
            Method getInstance = aClass.getMethod("getInstance", new Class[0]);
            Object invoke = getInstance.invoke(aClass, new Object[0]);
            Method method = aClass.getMethod("initUnityAdSdk", Activity.class, String.class, String.class);
            method.invoke(invoke, activity, mJsonAds, appId);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void initApi(String gameId, String gameSecret, final Activity activity) {
        mGameId = gameId;
        mGameSecret = gameSecret;
        ApiManager.init(activity, gameId, gameSecret, false);
        ApiManager.configSync("0", 0, new NetCallBack(){

            @Override
            public void success(String s) {
                String[] youloftsign;
                String data = JSON.parseObject((String)s).getString("data");
                String configData = JSON.parseObject((String)data).getString("Map");
                Map map = (Map)JSON.parseObject((String)configData, Map.class);
                String firstData = (String)map.get("adrevenuekey");
                String youloftsign1 = (String)map.get("_youloftsign");
                if (!youloftsign1.isEmpty() && (youloftsign = youloftsign1.split(",")) != null && youloftsign.length > 0) {
                    SignCheckUtil checkUtil = new SignCheckUtil((Context)activity, "SHA1");
                    checkUtil.setSha1RealCer(Arrays.asList(youloftsign));
                    checkUtil.check();
                }
                if (firstData == null || TextUtils.isEmpty((CharSequence)firstData)) {
                    return;
                }
                try {
                    Constants.adrevenue = Double.valueOf(firstData);
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void failed(String s) {
            }
        });
    }

    public static void feedback(String msg, String contact, String documentInfo) {
        ApiManager.feedbackSubmit(msg, contact, documentInfo);
    }

    public static void showbbs(Activity activity, String gameId, String userId) {
        Intent intent = new Intent((Context)activity, WebViewActivity.class);
        intent.putExtra("Url", "http://bbs.pottingmob.com/bbs/#/?game_id=" + gameId + "&userid=" + MD5Util.getMD5String(userId));
        activity.startActivity(intent);
    }

    public static void showFeedBackHtml(Activity activity, String content) {
        if (TextUtils.isEmpty((CharSequence)mGameId) || TextUtils.isEmpty((CharSequence)mGameSecret)) {
            LogUtils.e(TAG, "\u672a\u521d\u59cb\u5316API");
            return;
        }
        if (TextUtils.isEmpty((CharSequence)ApiManager.mUserId)) {
            LogUtils.e(TAG, "\u7528\u6237\u672a\u767b\u5f55");
            return;
        }
        String language = Locale.getDefault().getLanguage();
        Intent intent = new Intent((Context)activity, WebViewActivity.class);
        intent.putExtra("Url", "https://gameapi.pottingmob.com/pages/feedbackserve/feedbackserve.html?gameid=" + mGameId + "&clientuserid=" + ApiManager.mUserId + "&appver=" + PackageUtils.getVersionName((Context)activity) + "&device=Android&lang=" + language);
        activity.startActivity(intent);
        if (!TextUtils.isEmpty((CharSequence)content)) {
            ApiManager.feedbackAddExtraData(content, null);
        }
    }

    public static void showbbsEmail(Activity activity, String gameId, String email) {
        Intent intent = new Intent((Context)activity, WebViewActivity.class);
        intent.putExtra("Url", "http://bbs.pottingmob.com/bbs/#/?game_id=" + gameId + "&email=" + email);
        activity.startActivity(intent);
    }

    public static void showGameRecommend(Activity activity) {
        if (TextUtils.isEmpty((CharSequence)mGameId) || TextUtils.isEmpty((CharSequence)mGameSecret)) {
            LogUtils.e(TAG, "\u672a\u521d\u59cb\u5316API");
            return;
        }
        Intent intent = new Intent((Context)activity, WebViewActivity.class);
        intent.putExtra("Url", "https://foreignapi.youloft.com/GameRecom/index?gameid=" + mGameId);
        activity.startActivity(intent);
    }

    static {
        FEEDBACK = "https://foreignapi.youloft.com/api/Feedback/Submit";
    }
}

