/*
 * Decompiled with CFR 0.152.
 */
package com.youloft.webview;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Intent;
import android.net.Uri;
import android.net.http.SslError;
import android.os.Bundle;
import android.os.Parcelable;
import android.view.KeyEvent;
import android.view.View;
import android.webkit.SslErrorHandler;
import android.webkit.ValueCallback;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceRequest;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.TextView;
import androidx.annotation.Nullable;
import com.youloft.core.utils.LogUtils;
import com.youloft.core.utils.PermissionUtils;
import com.youloft.statistics.R;
import com.youloft.webview.ProgressWebView;
import java.net.URISyntaxException;
import java.util.List;

public class WebViewActivity
extends Activity {
    private ProgressWebView webview;
    private TextView tvTitle;
    public ValueCallback<Uri[]> mUploadMessageForAndroid5;
    public ValueCallback<Uri> mUploadMessage;
    public static final int FILE_CHOOSER_RESULT_CODE_FOR_ANDROID_5 = 2;
    private static final int FILE_CHOOSER_RESULT_CODE = 1;
    private Uri imageUri;

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_youloft_web_view);
        String startUrl = this.getIntent().getStringExtra("Url");
        this.findViewById(R.id.close).setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                WebViewActivity.this.finish();
            }
        });
        this.tvTitle = (TextView)this.findViewById(R.id.tv_title);
        this.webview = (ProgressWebView)this.findViewById(R.id.webview);
        WebSettings webSettings = this.webview.getSettings();
        webSettings.setJavaScriptEnabled(true);
        webSettings.setDomStorageEnabled(true);
        this.webview.setWebChromeClient(new WebChromeClient(){

            public void openFileChooser(ValueCallback<Uri> uploadMsg, String acceptType, String capture) {
                WebViewActivity.this.openFileChooserImpl(uploadMsg);
            }

            public boolean onShowFileChooser(WebView webView, ValueCallback<Uri[]> uploadMsg, WebChromeClient.FileChooserParams fileChooserParams) {
                WebViewActivity.this.onenFileChooseImpleForAndroid(uploadMsg);
                return true;
            }
        });
        this.webview.setWebViewClient(new WebViewClient(){

            public boolean shouldOverrideKeyEvent(WebView view, KeyEvent event) {
                return super.shouldOverrideKeyEvent(view, event);
            }

            public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
                return super.shouldOverrideUrlLoading(view, request);
            }

            public boolean shouldOverrideUrlLoading(WebView view, String url) {
                if (!url.startsWith("weixin:") && !url.startsWith("alipay")) {
                    return super.shouldOverrideUrlLoading(view, url);
                }
                try {
                    Intent intent = Intent.parseUri((String)url, (int)1);
                    intent.addCategory("android.intent.category.BROWSABLE");
                    intent.setComponent(null);
                    WebViewActivity.this.startActivity(intent);
                }
                catch (ActivityNotFoundException | URISyntaxException e) {
                    e.printStackTrace();
                }
                return true;
            }

            public void onPageFinished(WebView view, String url) {
                super.onPageFinished(view, url);
                LogUtils.d("Title", view.getTitle());
                if (WebViewActivity.this.tvTitle != null) {
                    WebViewActivity.this.tvTitle.setText((CharSequence)view.getTitle());
                }
                if (url.endsWith(".apk")) {
                    WebViewActivity.this.downloadByBrowser(url);
                }
            }

            public void onReceivedSslError(WebView view, SslErrorHandler handler, SslError error) {
                handler.cancel();
                LogUtils.e(error.toString());
            }

            public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
                super.onReceivedError(view, errorCode, description, failingUrl);
            }
        });
        this.webview.loadUrl(startUrl);
    }

    private void openFileChooserImpl(ValueCallback<Uri> uploadMsg) {
        this.mUploadMessage = uploadMsg;
        Intent i = new Intent("android.intent.action.GET_CONTENT");
        i.addCategory("android.intent.category.OPENABLE");
        i.setType("image/*");
        this.startActivityForResult(Intent.createChooser((Intent)i, (CharSequence)"File Chooser"), 1);
    }

    private void onenFileChooseImpleForAndroid(ValueCallback<Uri[]> filePathCallback) {
        this.mUploadMessageForAndroid5 = filePathCallback;
        PermissionUtils.permission("android.permission-group.STORAGE").callback(new PermissionUtils.FullCallback(){

            @Override
            public void onGranted(List<String> permissionsGranted) {
                LogUtils.d("onGranted", permissionsGranted.toString());
                WebViewActivity.this.takePhoto();
            }

            @Override
            public void onDenied(List<String> permissionsDeniedForever, List<String> permissionsDenied) {
                LogUtils.d("permissionsDeniedForever", permissionsDeniedForever.toString());
                LogUtils.d("permissionsDenied", permissionsDenied.toString());
                PermissionUtils.launchAppDetailsSettings();
            }
        }).rationale(new PermissionUtils.OnRationaleListener(){

            @Override
            public void rationale(PermissionUtils.OnRationaleListener.ShouldRequest shouldRequest) {
                LogUtils.d("ShouldRequest");
                shouldRequest.again(true);
            }
        }).request();
    }

    private void takePhoto() {
        Intent contentSelectionIntent = new Intent("android.intent.action.GET_CONTENT");
        contentSelectionIntent.addCategory("android.intent.category.OPENABLE");
        contentSelectionIntent.setType("image/*");
        Intent chooserIntent = new Intent("android.intent.action.CHOOSER");
        chooserIntent.putExtra("android.intent.extra.INTENT", (Parcelable)contentSelectionIntent);
        chooserIntent.putExtra("android.intent.extra.TITLE", "Image Chooser");
        this.startActivityForResult(chooserIntent, 2);
    }

    public void onActivityResult(int requestCode, int resultCode, Intent intent) {
        Uri result = intent == null || resultCode != -1 ? null : intent.getData();
        switch (requestCode) {
            case 1: {
                if (null == this.mUploadMessage) {
                    return;
                }
                this.mUploadMessage.onReceiveValue((Object)result);
                this.mUploadMessage = null;
                break;
            }
            case 2: {
                if (null == this.mUploadMessageForAndroid5) {
                    return;
                }
                if (result != null) {
                    this.mUploadMessageForAndroid5.onReceiveValue((Object)new Uri[]{result});
                } else {
                    this.mUploadMessageForAndroid5.onReceiveValue((Object)new Uri[0]);
                }
                this.mUploadMessageForAndroid5 = null;
            }
        }
        if (this.mUploadMessage != null) {
            this.mUploadMessage.onReceiveValue(null);
            this.mUploadMessage = null;
        }
        if (this.mUploadMessageForAndroid5 != null) {
            this.mUploadMessageForAndroid5.onReceiveValue(null);
            this.mUploadMessageForAndroid5 = null;
        }
    }

    private void downloadByBrowser(String url) {
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.addCategory("android.intent.category.BROWSABLE");
        intent.setData(Uri.parse((String)url));
        this.startActivity(intent);
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == 4) {
            if (this.webview.canGoBack()) {
                this.webview.goBack();
                return true;
            }
            this.finish();
        }
        return false;
    }

    protected void onDestroy() {
        super.onDestroy();
        if (this.webview != null) {
            this.webview.destroy();
            this.webview = null;
        }
    }
}

