/*
 * Decompiled with CFR 0.152.
 */
package com.youloft.webview;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.View;
import android.view.WindowManager;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class UIUtils {
    public static final int VIVO_NOTCH = 32;
    public static final int VIVO_FILLET = 8;

    public static float getScreenWidthDp(Context context) {
        float scale = context.getResources().getDisplayMetrics().density;
        float width = context.getResources().getDisplayMetrics().widthPixels;
        return width / (scale <= 0.0f ? 1.0f : scale) + 0.5f;
    }

    public static float getHeight(Activity activity) {
        UIUtils.hideBottomUIMenu(activity);
        int realHeight = UIUtils.getRealHeight((Context)activity);
        float height = UIUtils.hasNotchScreen(activity) ? (float)UIUtils.px2dip((Context)activity, realHeight - UIUtils.getStatusBarHeight((Context)activity)) : (float)UIUtils.px2dip((Context)activity, realHeight);
        return height;
    }

    public static void hideBottomUIMenu(Activity activity) {
        if (activity == null) {
            return;
        }
        try {
            if (Build.VERSION.SDK_INT > 11 && Build.VERSION.SDK_INT < 19) {
                View v = activity.getWindow().getDecorView();
                v.setSystemUiVisibility(8);
            } else if (Build.VERSION.SDK_INT >= 19) {
                View decorView = activity.getWindow().getDecorView();
                int uiOptions = 3842;
                decorView.setSystemUiVisibility(uiOptions);
                activity.getWindow().addFlags(0x8000000);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static int getRealHeight(Context context) {
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        Display display = windowManager.getDefaultDisplay();
        DisplayMetrics dm = new DisplayMetrics();
        if (Build.VERSION.SDK_INT >= 17) {
            display.getRealMetrics(dm);
        } else {
            display.getMetrics(dm);
        }
        int realHeight = dm.heightPixels;
        return realHeight;
    }

    public static int getStatusBarHeight(Context context) {
        int height = 0;
        int resourceId = context.getApplicationContext().getResources().getIdentifier("status_bar_height", "dimen", "android");
        if (resourceId > 0) {
            height = context.getApplicationContext().getResources().getDimensionPixelSize(resourceId);
        }
        return height;
    }

    public static int px2dip(Context context, float pxValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(pxValue / (scale <= 0.0f ? 1.0f : scale) + 0.5f);
    }

    public static boolean hasNotchScreen(Activity activity) {
        return UIUtils.getInt("ro.miui.notch", activity) == 1 || UIUtils.hasNotchAtHuawei((Context)activity) || UIUtils.hasNotchAtOPPO((Context)activity) || UIUtils.hasNotchAtVivo((Context)activity) || UIUtils.isAndroidPHasNotch(activity);
    }

    public static boolean isAndroidPHasNotch(Activity activity) {
        boolean ret = false;
        if (Build.VERSION.SDK_INT >= 28) {
            try {
                Class<?> windowInsets = Class.forName("android.view.WindowInsets");
                Method method = windowInsets.getMethod("getDisplayCutout", new Class[0]);
                Object displayCutout = method.invoke(windowInsets, new Object[0]);
                if (displayCutout != null) {
                    ret = true;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    public static int getInt(String key, Activity activity) {
        int result = 0;
        if (UIUtils.isMiui()) {
            try {
                ClassLoader classLoader = activity.getClassLoader();
                Class<?> SystemProperties = classLoader.loadClass("android.os.SystemProperties");
                Class[] paramTypes = new Class[]{String.class, Integer.TYPE};
                Method getInt = SystemProperties.getMethod("getInt", paramTypes);
                Object[] params = new Object[]{new String(key), new Integer(0)};
                result = (Integer)getInt.invoke(SystemProperties, params);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasNotchAtHuawei(Context context) {
        boolean ret = false;
        try {
            ClassLoader classLoader = context.getClassLoader();
            Class<?> HwNotchSizeUtil = classLoader.loadClass("com.huawei.android.util.HwNotchSizeUtil");
            Method get = HwNotchSizeUtil.getMethod("hasNotchInScreen", new Class[0]);
            ret = (Boolean)get.invoke(HwNotchSizeUtil, new Object[0]);
            return ret;
        }
        catch (ClassNotFoundException classNotFoundException) {}
        catch (NoSuchMethodException noSuchMethodException) {}
        catch (Exception exception) {}
        finally {
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasNotchAtVivo(Context context) {
        boolean ret = false;
        try {
            ClassLoader classLoader = context.getClassLoader();
            Class<?> FtFeature = classLoader.loadClass("android.util.FtFeature");
            Method method = FtFeature.getMethod("isFeatureSupport", Integer.TYPE);
            ret = (Boolean)method.invoke(FtFeature, 32);
            return ret;
        }
        catch (ClassNotFoundException classNotFoundException) {}
        catch (NoSuchMethodException noSuchMethodException) {}
        catch (Exception exception) {}
        finally {
            return ret;
        }
    }

    public static boolean hasNotchAtOPPO(Context context) {
        return context.getPackageManager().hasSystemFeature("com.oppo.feature.screen.heteromorphism");
    }

    public static boolean isMiui() {
        boolean sIsMiui = false;
        try {
            Class<?> clz = Class.forName("miui.os.Build");
            if (clz != null) {
                sIsMiui = true;
                return sIsMiui;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sIsMiui;
    }
}

