/*
 * Decompiled with CFR 0.152.
 */
package com.youloft.login;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ProgressBar;
import androidx.annotation.NonNull;
import androidx.core.content.FileProvider;
import com.facebook.AccessToken;
import com.facebook.CallbackManager;
import com.facebook.FacebookCallback;
import com.facebook.FacebookException;
import com.facebook.FacebookRequestError;
import com.facebook.GraphRequest;
import com.facebook.GraphResponse;
import com.facebook.HttpMethod;
import com.facebook.gamingservices.FriendFinderDialog;
import com.facebook.gamingservices.GamingImageUploader;
import com.facebook.gamingservices.GamingVideoUploader;
import com.facebook.login.LoginManager;
import com.facebook.login.LoginResult;
import com.google.android.gms.auth.api.signin.GoogleSignIn;
import com.google.android.gms.auth.api.signin.GoogleSignInAccount;
import com.google.android.gms.auth.api.signin.GoogleSignInClient;
import com.google.android.gms.auth.api.signin.GoogleSignInOptions;
import com.google.android.gms.common.api.ApiException;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;
import com.youloft.api.ApiManager;
import com.youloft.callbcak.LoginCallBack;
import com.youloft.core.UnityPlayerBridge;
import com.youloft.core.utils.LogUtils;
import com.youloft.core.utils.PackageUtils;
import com.youloft.core.utils.SPUtils;
import com.youloft.login.MediaUploadCallback;
import com.youloft.login.VideoUploadCallback;
import com.youloft.statistics.R;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Arrays;
import org.json.JSONException;
import org.json.JSONObject;

public class LoginUtils {
    public static final int GOOGLE_SIGN_IN_CODE = 900541;
    private static final String TAG = "LoginUtils";
    private static CallbackManager callbackManager;
    private static LoginCallBack mLoginCallBack;
    public static String facebookId;
    public static String googleId;
    public static String googleGameId;

    public static void setLoginCallBack(LoginCallBack loginCallBack) {
        mLoginCallBack = loginCallBack;
    }

    public static CallbackManager getCallbackManager() {
        if (callbackManager == null) {
            callbackManager = CallbackManager.Factory.create();
            return callbackManager;
        }
        return callbackManager;
    }

    public static void uploadPhoto(Activity activity, String path) {
        File file = new File(path);
        Uri fileUri = null;
        fileUri = Build.VERSION.SDK_INT >= 24 ? FileProvider.getUriForFile((Context)activity, (String)(PackageUtils.getAppProcessName((Context)activity) + ".provider"), (File)file) : Uri.fromFile((File)file);
        LoginUtils.uploadPhoto(activity, fileUri);
    }

    public static void uploadVideo(Activity activity, String videoUri) {
        File file = new File(videoUri);
        Uri fileUri = null;
        fileUri = Build.VERSION.SDK_INT >= 24 ? FileProvider.getUriForFile((Context)activity, (String)(PackageUtils.getAppProcessName((Context)activity) + ".provider"), (File)file) : Uri.fromFile((File)file);
        LoginUtils.uploadVideo(activity, fileUri);
    }

    public static void uploadPhoto(Activity activity, Uri imageUri) {
        GamingImageUploader imageUploader = new GamingImageUploader((Context)activity);
        try {
            imageUploader.uploadToMediaLibrary("My Test Image", imageUri, true, (GraphRequest.Callback)new MediaUploadCallback((Context)activity, false));
        }
        catch (FileNotFoundException e) {
            LogUtils.e(e.toString());
        }
    }

    public static void uploadVideo(Activity activity, Uri videoUri) {
        GamingVideoUploader videoUploader = new GamingVideoUploader((Context)activity);
        ProgressBar progressBar = (ProgressBar)activity.getLayoutInflater().inflate(R.layout.youloft_progressbar, null);
        ViewGroup viewGroup = (ViewGroup)activity.getWindow().getDecorView().findViewById(0x1020002);
        viewGroup.addView((View)progressBar);
        try {
            videoUploader.uploadToMediaLibrary("My Test Video", videoUri, (GraphRequest.OnProgressCallback)new VideoUploadCallback((Context)activity, progressBar));
        }
        catch (FileNotFoundException e) {
            LogUtils.e(e.toString());
        }
    }

    public static void openFriendFinderDeepLink(Activity activity) {
        AccessToken currentAccessToken = AccessToken.getCurrentAccessToken();
        if (currentAccessToken != null && currentAccessToken.getGraphDomain().equals("gaming")) {
            FriendFinderDialog dialog = new FriendFinderDialog(activity);
            dialog.registerCallback(LoginUtils.getCallbackManager(), (FacebookCallback)new FacebookCallback<FriendFinderDialog.Result>(){

                public void onSuccess(FriendFinderDialog.Result friendFinderResult) {
                    LogUtils.e("Player Finder Dialog closed");
                    UnityPlayerBridge.sendMsg("PottingMobile", "facebookFriendFinderResult", "0");
                }

                public void onCancel() {
                    UnityPlayerBridge.sendMsg("PottingMobile", "facebookFriendFinderResult", "1");
                }

                public void onError(FacebookException exception) {
                    LogUtils.e("GamingServicesFBCallback", exception.toString());
                    UnityPlayerBridge.sendMsg("PottingMobile", "facebookFriendFinderResult", exception.toString());
                }
            });
            dialog.show();
        }
    }

    public static void loginOutToFacebook() {
        AccessToken accessToken = AccessToken.getCurrentAccessToken();
        if (accessToken != null && !accessToken.isExpired()) {
            GraphRequest request = new GraphRequest(accessToken, "/me/permissions", null, HttpMethod.DELETE, new GraphRequest.Callback(){

                public void onCompleted(GraphResponse response) {
                    com.alibaba.fastjson.JSONObject jsonObject = new com.alibaba.fastjson.JSONObject();
                    if (response.getError() == null) {
                        jsonObject.put("Code", (Object)200);
                        jsonObject.put("Msg", (Object)"onCompleted");
                        UnityPlayerBridge.sendMsg("PottingMobile", "facebookLoginDeleteResult", jsonObject.toJSONString());
                        return;
                    }
                    FacebookRequestError error = response.getError();
                    jsonObject.put("Code", (Object)error.getErrorCode());
                    jsonObject.put("Msg", (Object)"onCompleted");
                    UnityPlayerBridge.sendMsg("PottingMobile", "facebookLoginDeleteResult", jsonObject.toJSONString());
                    Log.e((String)"GraphRequest", (String)("Error: " + error.getErrorMessage()));
                }
            });
            request.executeAsync();
        } else {
            com.alibaba.fastjson.JSONObject jsonObject = new com.alibaba.fastjson.JSONObject();
            jsonObject.put("Code", (Object)-1);
            jsonObject.put("Msg", (Object)"onCompleted");
            UnityPlayerBridge.sendMsg("PottingMobile", "facebookLoginDeleteResult", jsonObject.toJSONString());
            LoginUtils.loginToFacebook(ApiManager.getContext());
        }
        LoginManager.getInstance().logOut();
    }

    public static void loginToFacebook(final Activity activity) {
        if (callbackManager == null) {
            callbackManager = CallbackManager.Factory.create();
        }
        LoginManager.getInstance().registerCallback(callbackManager, (FacebookCallback)new FacebookCallback<LoginResult>(){

            public void onSuccess(LoginResult loginResult) {
                if (loginResult == null || loginResult.getAccessToken() == null) {
                    LoginUtils.getLoginError("Facebook\u7528\u6237\u4fe1\u606f\u83b7\u53d6\u5931\u8d25,loginResult is null", 0);
                    return;
                }
                GraphRequest request = GraphRequest.newMeRequest((AccessToken)loginResult.getAccessToken(), (GraphRequest.GraphJSONObjectCallback)new GraphRequest.GraphJSONObjectCallback(){

                    public void onCompleted(JSONObject object, GraphResponse response) {
                        LoginUtils.getLoginSuccess(object, 0);
                        activity.finish();
                    }
                });
                Bundle parameters = new Bundle();
                parameters.putString("fields", "id,name,email,picture");
                request.setParameters(parameters);
                request.executeAsync();
            }

            public void onCancel() {
                LogUtils.d("FacebookLogin", "\u53d6\u6d88\u767b\u9646");
                LoginUtils.getLoginError("\u53d6\u6d88\u83b7\u53d6Facebook\u7528\u6237\u4fe1\u606f", 0);
                activity.finish();
            }

            public void onError(FacebookException exception) {
                LoginUtils.getLoginError("Facebook\u7528\u6237\u4fe1\u606f\u83b7\u53d6\u5931\u8d25" + exception.getMessage(), 0);
                activity.finish();
            }
        });
        LoginManager.getInstance().logInWithReadPermissions(activity, Arrays.asList("email"));
    }

    public static void getLoginError(String msg, int type) {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("Code", -1);
            jsonObject.put("Msg", (Object)msg);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        if (type == 0) {
            UnityPlayerBridge.sendMsg("PottingMobile", "loginUseFacebookDidComplete", jsonObject.toString());
        } else if (type == 1) {
            UnityPlayerBridge.sendMsg("PottingMobile", "loginUseGoogleDidComplete", jsonObject.toString());
        } else if (type == 2) {
            UnityPlayerBridge.sendMsg("PottingMobile", "loginGame", jsonObject.toString());
        }
        if (mLoginCallBack != null) {
            mLoginCallBack.failed(jsonObject.toString(), String.valueOf(type));
        }
    }

    public static void getLoginSuccess(JSONObject object, int type) {
        String id2 = "";
        String name = "";
        String email = "";
        String photo = "";
        String token = "";
        try {
            id2 = object.optString("id");
            name = object.optString("name");
            email = object.optString("email");
            token = object.optString("token");
            photo = "";
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (type == 0) {
            try {
                JSONObject object_data;
                JSONObject object_pic = object.optJSONObject("picture");
                if (object_pic != null && (object_data = object_pic.optJSONObject("data")) != null) {
                    photo = object_data.optString("url");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (type == 1) {
            try {
                photo = object.getString("picture");
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        LogUtils.d("LoginActivity", "id:" + id2 + "name:" + name + "email:" + email + "photo:" + photo);
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("UserID", (Object)id2);
            jsonObject.put("UserName", (Object)name);
            jsonObject.put("UserEmail", (Object)email);
            jsonObject.put("PictureURL", (Object)photo);
            jsonObject.put("Token", (Object)token);
            jsonObject.put("Code", 200);
            if (type == 0) {
                jsonObject.put("Msg", (Object)"Facebook\u7528\u6237\u4fe1\u606f\u83b7\u53d6\u6210\u529f");
            } else if (type == 1) {
                jsonObject.put("Msg", (Object)"Google\u7528\u6237\u4fe1\u606f\u83b7\u53d6\u6210\u529f");
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        if (type == 0) {
            facebookId = id2;
            UnityPlayerBridge.sendMsg("PottingMobile", "loginUseFacebookDidComplete", jsonObject.toString());
        } else if (type == 1) {
            googleId = id2;
            UnityPlayerBridge.sendMsg("PottingMobile", "loginUseGoogleDidComplete", jsonObject.toString());
        } else if (type == 2) {
            googleGameId = id2;
            SPUtils.getInstance().put("GoogleGameManager", id2);
            UnityPlayerBridge.sendMsg("PottingMobile", "loginGame", jsonObject.toString());
        }
        if (mLoginCallBack != null) {
            mLoginCallBack.success(jsonObject.toString(), String.valueOf(type));
        }
    }

    public static void loginToGoogle(Activity activity) {
        GoogleSignInOptions gso = new GoogleSignInOptions.Builder(GoogleSignInOptions.DEFAULT_SIGN_IN).requestEmail().requestProfile().build();
        GoogleSignInClient mGoogleSignInClient = GoogleSignIn.getClient((Activity)activity, (GoogleSignInOptions)gso);
        Intent signInIntent = mGoogleSignInClient.getSignInIntent();
        activity.startActivityForResult(signInIntent, 900541);
    }

    public static void loginOutToGoogle(Activity activity) {
        GoogleSignInOptions gso = new GoogleSignInOptions.Builder(GoogleSignInOptions.DEFAULT_SIGN_IN).requestEmail().requestProfile().build();
        GoogleSignInClient mGoogleSignInClient = GoogleSignIn.getClient((Activity)activity, (GoogleSignInOptions)gso);
        mGoogleSignInClient.signOut().addOnCompleteListener(activity, (OnCompleteListener)new OnCompleteListener<Void>(){

            public void onComplete(@NonNull Task<Void> task) {
                LogUtils.d("loginOutToGoogle--");
                UnityPlayerBridge.sendMsg("PottingMobile", "signOut", "onComplete");
            }
        });
    }

    public static void loginToGoogle(Activity activity, String clientID) {
        GoogleSignInOptions gso = new GoogleSignInOptions.Builder(GoogleSignInOptions.DEFAULT_SIGN_IN).requestEmail().requestProfile().requestIdToken(clientID).build();
        GoogleSignInClient mGoogleSignInClient = GoogleSignIn.getClient((Activity)activity, (GoogleSignInOptions)gso);
        Intent signInIntent = mGoogleSignInClient.getSignInIntent();
        activity.startActivityForResult(signInIntent, 900541);
    }

    public static void getGoogleSignInCallback(Activity activity, int requestCode, int resultCode, Intent data) {
        if (requestCode == 900541) {
            Task completedTask = GoogleSignIn.getSignedInAccountFromIntent((Intent)data);
            try {
                GoogleSignInAccount account = (GoogleSignInAccount)completedTask.getResult(ApiException.class);
                if (account != null) {
                    LogUtils.d(TAG, account.getEmail() + account.getDisplayName() + account.getId() + account.getPhotoUrl());
                    LogUtils.e(account.getIdToken());
                    JSONObject jsonObject = new JSONObject();
                    try {
                        jsonObject.put("id", (Object)account.getId());
                        jsonObject.put("name", (Object)account.getDisplayName());
                        jsonObject.put("email", (Object)account.getEmail());
                        jsonObject.put("picture", (Object)account.getPhotoUrl());
                        jsonObject.put("token", (Object)account.getIdToken());
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                    LoginUtils.getLoginSuccess(jsonObject, 1);
                } else {
                    LoginUtils.getLoginError("Google\u767b\u5f55\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25", 1);
                }
                activity.finish();
            }
            catch (ApiException e) {
                LoginUtils.getLoginError("Google\u767b\u5f55\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25" + e.getMessage(), 1);
                LogUtils.e(TAG, "signInResult:failed code=" + e.getStatusCode());
                activity.finish();
            }
        }
    }
}

