/*
 * Decompiled with CFR 0.152.
 */
package com.youloft.google;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.ImageView;
import android.widget.ListView;
import android.widget.TextView;
import com.google.android.gms.common.images.ImageManager;
import com.google.android.gms.games.snapshot.Snapshot;
import com.google.android.gms.games.snapshot.SnapshotMetadata;
import com.youloft.core.utils.LogUtils;
import com.youloft.statistics.R;
import java.util.ArrayList;

public class SelectSnapshotActivity
extends Activity
implements AdapterView.OnItemClickListener {
    private static final String TAG = "SelSnapshotActivity";
    public static final String SNAPSHOT_METADATA = "snapshotmeta";
    public static final String SNAPSHOT_METADATA_LIST = "snapshotmetaList";
    public static final String CONFLICT_ID = "conflictId";
    public static final String RETRY_COUNT = "retrycount";
    private String mConflictId;
    private int mRetryCount;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_select_snapshot);
        Intent intent = this.getIntent();
        if (intent != null) {
            ListView vw = (ListView)this.findViewById(R.id.snapshot_list);
            ArrayList snapshotMetadataList = intent.getParcelableArrayListExtra(SNAPSHOT_METADATA_LIST);
            vw.setAdapter(new SnapshotListAdapter(this, snapshotMetadataList));
            this.mConflictId = intent.getStringExtra(CONFLICT_ID);
            this.mRetryCount = intent.getIntExtra(RETRY_COUNT, 0);
            vw.setOnItemClickListener((AdapterView.OnItemClickListener)this);
        }
    }

    public void onItemClick(AdapterView<?> adapterView, View view, int position, long listId) {
        SnapshotMetadata selected = (SnapshotMetadata)adapterView.getItemAtPosition(position);
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.putExtra(SNAPSHOT_METADATA, (Parcelable)selected.freeze());
        if (this.mConflictId != null) {
            intent.putExtra(CONFLICT_ID, this.mConflictId);
            intent.putExtra(RETRY_COUNT, this.mRetryCount);
        }
        LogUtils.d(TAG, "Finishing item at position " + position + " clicked");
        this.setResult(-1, intent);
        this.finish();
    }

    static class SnapshotListAdapter<T>
    extends ArrayAdapter<T> {
        private static final long MILLIS_PER_MINUTE = 60000L;
        private static final long MILLIS_PER_HOUR = 3600000L;
        private static final long MILLIS_PER_DAY = 86400000L;

        public SnapshotListAdapter(Activity activity, ArrayList<T> data) {
            super((Context)activity, R.layout.snapshotlayout, data);
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            LayoutInflater inflater = (LayoutInflater)this.getContext().getSystemService("layout_inflater");
            View rowView = inflater.inflate(R.layout.snapshotlayout, parent, false);
            TextView textView = (TextView)rowView.findViewById(R.id.label);
            TextView ageView = (TextView)rowView.findViewById(R.id.age);
            ImageView imageView = (ImageView)rowView.findViewById(R.id.snapshot_icon);
            Object item = this.getItem(position);
            SnapshotMetadata snapshotMetadata = item instanceof Snapshot ? ((Snapshot)item).getMetadata() : (SnapshotMetadata)item;
            if (snapshotMetadata != null) {
                textView.setText((CharSequence)snapshotMetadata.getDescription());
                ageView.setText((CharSequence)this.getAge(snapshotMetadata.getLastModifiedTimestamp()));
                ImageManager.create((Context)this.getContext()).loadImage(imageView, snapshotMetadata.getCoverImageUri());
            }
            return rowView;
        }

        private String getAge(long timestamp) {
            long delta = System.currentTimeMillis() - timestamp;
            int days = (int)(delta / 86400000L);
            int hours = (int)((delta %= 86400000L) / 3600000L);
            int minutes = (int)((delta %= 3600000L) / 60000L);
            delta = (int)(delta % 60000L);
            int seconds = (int)delta / 1000;
            if (days > 0) {
                return this.getContext().getString(R.string.format_days_ago, new Object[]{days});
            }
            if (hours > 0) {
                return this.getContext().getString(R.string.format_hours_ago, new Object[]{hours});
            }
            if (minutes > 0) {
                return this.getContext().getString(R.string.format_minutes_ago, new Object[]{minutes});
            }
            if (seconds > 0) {
                return this.getContext().getString(R.string.format_seconds_ago, new Object[]{seconds});
            }
            return this.getContext().getString(R.string.moments_ago);
        }
    }
}

