/*
 * Decompiled with CFR 0.152.
 */
package com.youloft.core.utils;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import com.facebook.CallbackManager;
import com.facebook.FacebookCallback;
import com.facebook.FacebookException;
import com.facebook.share.Sharer;
import com.facebook.share.model.ShareContent;
import com.facebook.share.model.ShareLinkContent;
import com.facebook.share.model.SharePhoto;
import com.facebook.share.model.SharePhotoContent;
import com.facebook.share.widget.ShareDialog;
import com.youloft.core.UnityPlayerBridge;
import com.youloft.core.utils.LogUtils;

public class ShareUtil {
    private static CallbackManager callbackManager;

    public static void shareText(Context context, String extraText) {
        Intent intent = new Intent("android.intent.action.SEND");
        intent.setType("text/plain");
        intent.putExtra("android.intent.extra.SUBJECT", "Share");
        intent.putExtra("android.intent.extra.TEXT", extraText);
        intent.setFlags(0x10000000);
        context.startActivity(Intent.createChooser((Intent)intent, (CharSequence)""));
    }

    public static void shareFbPhoto(final Activity activity, String path) {
        LogUtils.e("fbshare--Path:" + path);
        BitmapFactory.Options opt = new BitmapFactory.Options();
        opt.inPreferredConfig = Bitmap.Config.RGB_565;
        opt.inPurgeable = true;
        opt.inInputShareable = true;
        Bitmap bitmap = BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)opt);
        SharePhoto photo = new SharePhoto.Builder().setBitmap(bitmap).build();
        callbackManager = CallbackManager.Factory.create();
        SharePhotoContent content = new SharePhotoContent.Builder().addPhoto(photo).build();
        ShareDialog shareDialog = new ShareDialog(activity);
        shareDialog.registerCallback(callbackManager, (FacebookCallback)new FacebookCallback<Sharer.Result>(){

            public void onSuccess(Sharer.Result result) {
                UnityPlayerBridge.sendMsg("PottingMobile", "facebookShareComplete", "1");
                activity.finish();
            }

            public void onCancel() {
                UnityPlayerBridge.sendMsg("PottingMobile", "facebookShareComplete", "0");
                activity.finish();
            }

            public void onError(FacebookException error) {
                UnityPlayerBridge.sendMsg("PottingMobile", "facebookShareComplete", "-1");
                activity.finish();
            }
        });
        shareDialog.show((ShareContent)content, ShareDialog.Mode.AUTOMATIC);
    }

    public static void shareFbPhoto1(Activity activity, String path) {
        ShareDialog shareDialog = new ShareDialog(activity);
        if (ShareDialog.canShow(ShareLinkContent.class)) {
            ShareLinkContent linkContent = ((ShareLinkContent.Builder)new ShareLinkContent.Builder().setContentUrl(Uri.parse((String)"http://developers.facebook.com/android"))).build();
            shareDialog.show((Object)linkContent);
        }
    }

    public static void onActivityResult(int requestCode, int resultCode, Intent data) {
        callbackManager.onActivityResult(requestCode, resultCode, data);
    }
}

