/*
 * Decompiled with CFR 0.152.
 */
package com.youloft.core.utils;

import android.app.ActivityManager;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Process;
import android.telephony.TelephonyManager;
import com.youloft.core.utils.LogUtils;
import java.util.List;

public class PackageUtils {
    public static String getVersionName(Context context) {
        PackageManager pm = context.getPackageManager();
        try {
            PackageInfo packageInfo = pm.getPackageInfo(context.getPackageName(), 0);
            return packageInfo.versionName;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String getAppProcessName(Context context) {
        int pid = Process.myPid();
        ActivityManager manager = (ActivityManager)context.getSystemService("activity");
        List infos = manager.getRunningAppProcesses();
        if (infos == null) {
            return "";
        }
        for (ActivityManager.RunningAppProcessInfo info : infos) {
            if (info.pid != pid) continue;
            return info.processName;
        }
        return "";
    }

    public static int getVersionCode(Context context) {
        PackageManager pm = context.getPackageManager();
        try {
            PackageInfo packageInfo = pm.getPackageInfo(context.getPackageName(), 0);
            return packageInfo.versionCode;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public static String getAppName(Context context) {
        PackageManager pm = context.getPackageManager();
        try {
            PackageInfo packageInfo = pm.getPackageInfo(context.getPackageName(), 0);
            ApplicationInfo applicationInfo = packageInfo.applicationInfo;
            int labelRes = applicationInfo.labelRes;
            return context.getResources().getString(labelRes);
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String getCountryZipCode(Context context) {
        String CountryID = "";
        TelephonyManager manager = (TelephonyManager)context.getSystemService("phone");
        CountryID = manager.getSimCountryIso().toUpperCase();
        LogUtils.d("ss", "CountryID--->>>" + CountryID);
        return CountryID;
    }
}

