/*
 * Decompiled with CFR 0.152.
 */
package com.youloft.core.utils;

import android.util.Log;

public class LogUtils {
    private static final String TAG = "YouLoft";
    private static boolean LOG_ENABLE = false;
    private static boolean DETAIL_ENABLE = true;

    private static String buildMsg(String msg) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(msg);
        return buffer.toString();
    }

    public static void setLogEnable(boolean enable) {
        LOG_ENABLE = enable;
    }

    public static void v(String msg) {
        if (LOG_ENABLE) {
            Log.v((String)TAG, (String)LogUtils.buildMsg(msg));
        }
    }

    public static void v(String tag, String msg) {
        if (LOG_ENABLE) {
            Log.v((String)(TAG + tag), (String)LogUtils.buildMsg(msg));
        }
    }

    public static void d(String msg) {
        if (LOG_ENABLE) {
            Log.d((String)TAG, (String)LogUtils.buildMsg(msg));
        }
    }

    public static void d(String tag, String msg) {
        if (LOG_ENABLE) {
            Log.d((String)(TAG + tag), (String)LogUtils.buildMsg(msg));
        }
    }

    public static void i(String msg) {
        if (LOG_ENABLE) {
            Log.i((String)TAG, (String)LogUtils.buildMsg(msg));
        }
    }

    public static void i(String tag, String msg) {
        if (LOG_ENABLE) {
            Log.i((String)(TAG + tag), (String)LogUtils.buildMsg(msg));
        }
    }

    public static void w(String msg) {
        if (LOG_ENABLE) {
            Log.w((String)TAG, (String)LogUtils.buildMsg(msg));
        }
    }

    public static void w(String msg, Exception e) {
        if (LOG_ENABLE) {
            Log.w((String)TAG, (String)LogUtils.buildMsg(msg), (Throwable)e);
        }
    }

    public static void w(String tag, String msg) {
        if (LOG_ENABLE) {
            Log.w((String)(TAG + tag), (String)LogUtils.buildMsg(msg));
        }
    }

    public static void w(String tag, String msg, Exception e) {
        if (LOG_ENABLE) {
            Log.w((String)(TAG + tag), (String)LogUtils.buildMsg(msg), (Throwable)e);
        }
    }

    public static void e(String msg) {
        Log.e((String)TAG, (String)LogUtils.buildMsg(msg));
    }

    public static void e(String msg, Exception e) {
        Log.e((String)TAG, (String)LogUtils.buildMsg(msg), (Throwable)e);
    }

    public static void e(String tag, String msg) {
        Log.e((String)(TAG + tag), (String)LogUtils.buildMsg(msg));
    }

    public static void e(String tag, String msg, Exception e) {
        Log.e((String)(TAG + tag), (String)LogUtils.buildMsg(msg), (Throwable)e);
    }
}

