/*
 * Decompiled with CFR 0.152.
 */
package com.youloft.core.utils;

import android.content.Context;
import android.os.Environment;
import android.telephony.TelephonyManager;
import com.appsflyer.AppsFlyerLib;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.security.MessageDigest;

public class DeviceIdUtil {
    private static final String CACHE_DEVICES_DIR = "devices";
    private static final String DEVICES_FILE_NAME = ".DEVICES";

    public static String getDeviceId(Context context) {
        return AppsFlyerLib.getInstance().getAppsFlyerUID(context);
    }

    private static String readDeviceID(Context context) {
        File file = DeviceIdUtil.getDevicesDir(context);
        StringBuffer buffer = new StringBuffer();
        try {
            int i;
            FileInputStream fis = new FileInputStream(file);
            InputStreamReader isr = new InputStreamReader((InputStream)fis, "UTF-8");
            BufferedReader in = new BufferedReader(isr);
            while ((i = ((Reader)in).read()) > -1) {
                buffer.append((char)i);
            }
            ((Reader)in).close();
            return buffer.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String getIMIEStatus(Context context) {
        TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
        String deviceId = tm.getDeviceId();
        return deviceId;
    }

    private static String getLocalMac(Context context) {
        String macAddress = null;
        StringBuffer buf = new StringBuffer();
        NetworkInterface networkInterface = null;
        try {
            byte[] addr;
            networkInterface = NetworkInterface.getByName("eth1");
            if (networkInterface == null) {
                networkInterface = NetworkInterface.getByName("wlan0");
            }
            if (networkInterface == null) {
                return "";
            }
            for (byte b : addr = networkInterface.getHardwareAddress()) {
                buf.append(String.format("%02X:", b));
            }
            if (buf.length() > 0) {
                buf.deleteCharAt(buf.length() - 1);
            }
            macAddress = buf.toString();
        }
        catch (SocketException e) {
            e.printStackTrace();
            return "";
        }
        return macAddress;
    }

    private static void saveDeviceID(String str, Context context) {
        File file = DeviceIdUtil.getDevicesDir(context);
        try {
            FileOutputStream fos = new FileOutputStream(file);
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)fos, "UTF-8");
            out.write(str);
            ((Writer)out).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static String getMD5(String message, boolean upperCase) {
        String md5str = "";
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] input = message.getBytes();
            byte[] buff = md.digest(input);
            md5str = DeviceIdUtil.bytesToHex(buff, upperCase);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return md5str;
    }

    private static String bytesToHex(byte[] bytes, boolean upperCase) {
        StringBuffer md5str = new StringBuffer();
        for (int i = 0; i < bytes.length; ++i) {
            int digital = bytes[i];
            if (digital < 0) {
                digital += 256;
            }
            if (digital < 16) {
                md5str.append("0");
            }
            md5str.append(Integer.toHexString(digital));
        }
        if (upperCase) {
            return md5str.toString().toUpperCase();
        }
        return md5str.toString().toLowerCase();
    }

    private static File getDevicesDir(Context context) {
        File mCropFile = null;
        if (Environment.getExternalStorageState().equals("mounted")) {
            File cropdir = new File(Environment.getExternalStorageDirectory(), CACHE_DEVICES_DIR);
            if (!cropdir.exists()) {
                cropdir.mkdirs();
            }
            mCropFile = new File(cropdir, DEVICES_FILE_NAME);
        } else {
            File cropdir = new File(context.getFilesDir(), CACHE_DEVICES_DIR);
            if (!cropdir.exists()) {
                cropdir.mkdirs();
            }
            mCropFile = new File(cropdir, DEVICES_FILE_NAME);
        }
        return mCropFile;
    }
}

