/*
 * Decompiled with CFR 0.152.
 */
package com.youloft.api;

import android.app.Activity;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Handler;
import android.text.TextUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.appsflyer.AppsFlyerLib;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.youloft.api.HttpLogger;
import com.youloft.api.config.OkBean;
import com.youloft.api.config.PurchaseBean;
import com.youloft.api.config.PurchaseObj;
import com.youloft.api.config.UrlConfig;
import com.youloft.callbcak.NetCallBack;
import com.youloft.callbcak.OkNetCallBack;
import com.youloft.core.UnityPlayerBridge;
import com.youloft.core.utils.AdvertisingIdClient;
import com.youloft.core.utils.LogUtils;
import com.youloft.core.utils.MD5Util;
import com.youloft.core.utils.PackageUtils;
import com.youloft.core.utils.PhoneUtils;
import com.youloft.core.utils.SPUtils;
import com.youloft.login.LoginUtils;
import com.youloft.statistics.StatisticsManager;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.logging.HttpLoggingInterceptor;
import org.jetbrains.annotations.NotNull;

public class ApiManager {
    private static final String TAG = "ApiManager";
    public static final String UNITY_OBJECT = "PottingMobileServices";
    private static Activity mActivity;
    public static String mGameId;
    private static String mGameSecret;
    public static String mUserId;
    private static String mToken;
    private static String account_type;
    private static String mChannel;
    private static String adid;
    private static OkHttpClient client;
    public static final MediaType OKJSON;

    public static void init(Activity activity, String gameId, String gameSecret, boolean isDebug) {
        if (TextUtils.isEmpty((CharSequence)gameId) || TextUtils.isEmpty((CharSequence)gameSecret) || activity == null) {
            throw new NullPointerException("\u521d\u59cb\u5316\u53c2\u6570\u6709\u7a7a");
        }
        mActivity = activity;
        UrlConfig.URL_ROOT = isDebug ? "https://testchinaapi.youloft.com" : "https://gameapi.pottingmob.com";
        HttpLoggingInterceptor logInterceptor = new HttpLoggingInterceptor((HttpLoggingInterceptor.Logger)new HttpLogger());
        logInterceptor.setLevel(HttpLoggingInterceptor.Level.BODY);
        client = new OkHttpClient().newBuilder().connectTimeout(15L, TimeUnit.SECONDS).readTimeout(15L, TimeUnit.SECONDS).writeTimeout(15L, TimeUnit.SECONDS).addNetworkInterceptor((Interceptor)logInterceptor).build();
        mGameId = gameId;
        mGameSecret = gameSecret;
        mUserId = SPUtils.getInstance().getString("USER_ID");
        mToken = SPUtils.getInstance().getString("TOKEN");
        ApiManager.initAdid();
    }

    public static int isGooglePlayServicesAvailable() {
        LogUtils.e("isGooglePlayServicesAvailable--" + GoogleApiAvailability.getInstance().isGooglePlayServicesAvailable((Context)ApiManager.getContext()));
        return GoogleApiAvailability.getInstance().isGooglePlayServicesAvailable((Context)ApiManager.getContext());
    }

    private static void post(final String httpUrl, String json, final OkNetCallBack netCallBack) {
        RequestBody body = RequestBody.create((String)json, (MediaType)OKJSON);
        Request request = new Request.Builder().url(httpUrl).post(body).addHeader("ov", Build.VERSION.RELEASE).addHeader("av", PackageUtils.getVersionName((Context)mActivity)).build();
        Call call = client.newCall(request);
        call.enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                OkBean okBean = new OkBean();
                JSONObject json = new JSONObject();
                json.put("code", (Object)-200);
                json.put("data", (Object)call.toString());
                okBean.setData(json);
                okBean.setSucceed(false);
                netCallBack.OnResult(okBean);
                LogUtils.e(call.toString() + e.getMessage() + "-->" + httpUrl);
            }

            public void onResponse(Call call, Response response) throws IOException {
                String data = response.body().string();
                if (response.code() == 200) {
                    JSONObject originalData = null;
                    try {
                        originalData = JSON.parseObject((String)data);
                        OkBean okBean = new OkBean();
                        okBean.setData(originalData);
                        if (originalData.getIntValue("code") == 200) {
                            okBean.setSucceed(true);
                        }
                        netCallBack.OnResult(okBean);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        OkBean okBean = new OkBean();
                        JSONObject json = new JSONObject();
                        json.put("code", (Object)-200);
                        json.put("data", (Object)data);
                        okBean.setData(json);
                        okBean.setSucceed(false);
                        netCallBack.OnResult(okBean);
                        LogUtils.e(call.toString() + "-->" + httpUrl);
                    }
                } else {
                    OkBean okBean = new OkBean();
                    JSONObject json = new JSONObject();
                    json.put("code", (Object)-200);
                    json.put("data", (Object)call.toString());
                    okBean.setData(json);
                    okBean.setSucceed(false);
                    netCallBack.OnResult(okBean);
                    LogUtils.e(call.toString() + "-->" + httpUrl);
                }
            }
        });
    }

    private static void initAdid() {
        Executors.newSingleThreadExecutor().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    adid = AdvertisingIdClient.getGoogleAdId((Context)mActivity);
                    LogUtils.e(ApiManager.TAG, "adid:" + adid);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public static void ReUpPurchaseData() {
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                String purchaseString = SPUtils.getInstance().getString("PurchaseObj");
                LogUtils.e("purchaseString", purchaseString);
                PurchaseObj purchaseObj = (PurchaseObj)JSON.parseObject((String)purchaseString, PurchaseObj.class);
                if (purchaseObj != null && purchaseObj.getPurchaseBean() != null) {
                    final PurchaseBean purchaseBean = purchaseObj.getPurchaseBean();
                    final long price = purchaseObj.getPrice();
                    final String currency = purchaseObj.getCurrency();
                    ApiManager.googleValidate(purchaseBean.getPurchaseToken(), purchaseBean.getOrderId(), purchaseBean.getProductId(), purchaseObj.getType(), purchaseObj.getActId(), new NetCallBack(){

                        @Override
                        public void success(String decryptData) {
                            SPUtils.getInstance().put("PurchaseObj", "");
                            String mCurrency = currency;
                            if (TextUtils.isEmpty((CharSequence)currency)) {
                                mCurrency = "USD";
                            }
                            JSONObject json = JSON.parseObject((String)decryptData);
                            Integer uploadstate = json.getInteger("uploadstate");
                            JSONObject js = JSON.parseObject((String)JSON.toJSON((Object)purchaseBean).toString());
                            js.put("orderstate", (Object)json.getInteger("orderstate"));
                            UnityPlayerBridge.sendMsg("PottingMobile", "Validate", js.toJSONString());
                            if (uploadstate == 0) {
                                StatisticsManager.buyProduct(price, purchaseBean.getProductId(), mCurrency);
                            }
                        }

                        @Override
                        public void failed(String s) {
                            JSONObject jsonObject = new JSONObject();
                            jsonObject.put("skuid", (Object)purchaseBean.getProductId());
                            jsonObject.put("orderid", (Object)purchaseBean.getOrderId());
                            jsonObject.put("userid", (Object)mUserId);
                            StatisticsManager.customEvent("youloftpayuploadfail", jsonObject.toJSONString());
                        }
                    });
                }
            }
        }, 5000L);
    }

    public static Activity getContext() {
        if (mActivity == null) {
            throw new NullPointerException("\u521d\u59cb\u5316activity\u4e3a\u7a7a");
        }
        return mActivity;
    }

    public static void setContext(Activity activity) {
        if (mActivity == null) {
            mActivity = activity;
        }
    }

    public static void keyData(String userId) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("Userid", (Object)userId);
        jsonObject.put("Googlegameid", (Object)LoginUtils.googleGameId);
        jsonObject.put("Googleloginid", (Object)LoginUtils.googleId);
        jsonObject.put("Appsflyerid", (Object)AppsFlyerLib.getInstance().getAppsFlyerUID((Context)mActivity));
        jsonObject.put("Facebookid", (Object)LoginUtils.facebookId);
        jsonObject.put("Googleadid", (Object)adid);
        ApiManager.post("https://gamecms.pottingmob.com/api/KeyData", jsonObject.toJSONString(), new OkNetCallBack(){

            @Override
            public void OnResult(OkBean bean) {
                if (bean.isSucceed()) {
                    JSONObject jSONObject = ApiManager.getJsonDec(bean, true);
                }
            }
        });
    }

    public static void channelPayOrder(int channel, String goodsid) {
        if (TextUtils.isEmpty((CharSequence)mGameId) || TextUtils.isEmpty((CharSequence)mGameSecret)) {
            throw new NullPointerException("\u521d\u59cb\u5316\u53c2\u6570\u6709\u7a7a");
        }
        if (TextUtils.isEmpty((CharSequence)mUserId) || TextUtils.isEmpty((CharSequence)mToken)) {
            UnityPlayerBridge.sendMsg(UNITY_OBJECT, "LoginStatus", "0");
            return;
        }
        List<String> listParams = ApiManager.getParamsList(true, String.valueOf(channel), goodsid);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("channel", (Object)channel);
        jsonObject.put("goodsid", (Object)goodsid);
        jsonObject.put("userid", (Object)mUserId);
        jsonObject.put("token", (Object)mToken);
        String json = ApiManager.getParamsJsonObject(jsonObject, listParams).toJSONString();
        ApiManager.post(UrlConfig.URL_ROOT + UrlConfig.ChannelpayOrder, json, new OkNetCallBack(){

            @Override
            public void OnResult(OkBean bean) {
                if (bean.isSucceed()) {
                    JSONObject successJson = ApiManager.getJsonDec(bean, true);
                    UnityPlayerBridge.sendMsg(ApiManager.UNITY_OBJECT, "ChannelpayOrder", successJson.toString());
                } else {
                    UnityPlayerBridge.sendMsg(ApiManager.UNITY_OBJECT, "ChannelpayOrder", bean.getData().toJSONString());
                }
            }
        });
    }

    @NotNull
    private static JSONObject getJsonDec(OkBean bean, boolean isToken) {
        String password = "";
        password = isToken ? mToken.substring(0, 4) + mGameSecret.substring(0, 4) : mGameSecret.substring(0, 8);
        String data = bean.getData().getString("data");
        String decryptData = MD5Util.decrypt(password, data);
        JSONObject successJson = new JSONObject();
        successJson.put("code", (Object)200);
        successJson.put("data", JSON.parse((String)decryptData));
        LogUtils.d(successJson.toString());
        return successJson;
    }

    public static void channelPayOrder(int channel, String goodsid, final NetCallBack netCallBack) {
        if (TextUtils.isEmpty((CharSequence)mGameId) || TextUtils.isEmpty((CharSequence)mGameSecret)) {
            throw new NullPointerException("\u521d\u59cb\u5316\u53c2\u6570\u6709\u7a7a");
        }
        if (TextUtils.isEmpty((CharSequence)mUserId) || TextUtils.isEmpty((CharSequence)mToken)) {
            if (netCallBack != null) {
                netCallBack.failed("\u8bf7\u5148\u767b\u5f55");
            }
            return;
        }
        List<String> listParams = ApiManager.getParamsList(true, String.valueOf(channel), goodsid);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("channel", (Object)channel);
        jsonObject.put("goodsid", (Object)goodsid);
        jsonObject.put("userid", (Object)mUserId);
        jsonObject.put("token", (Object)mToken);
        String json = ApiManager.getParamsJsonObject(jsonObject, listParams).toJSONString();
        ApiManager.post(UrlConfig.URL_ROOT + UrlConfig.ChannelpayOrder, json, new OkNetCallBack(){

            @Override
            public void OnResult(OkBean bean) {
                if (bean.isSucceed()) {
                    JSONObject successJson = ApiManager.getJsonDec(bean, true);
                    LogUtils.d(successJson.toString());
                    if (netCallBack != null) {
                        netCallBack.success(successJson.toJSONString());
                    }
                } else {
                    if (netCallBack != null) {
                        netCallBack.failed(bean.getData().toJSONString());
                    }
                    LogUtils.e(bean.getData().toString());
                }
            }
        });
    }

    public static void channelPayGetAppVersion(String channel) {
        ApiManager.channelPayGetAppVersion(channel, null);
    }

    public static void channelPayGetAppVersion(String channel, final NetCallBack netCallBack) {
        if (TextUtils.isEmpty((CharSequence)mGameId) || TextUtils.isEmpty((CharSequence)mGameSecret)) {
            throw new NullPointerException("\u521d\u59cb\u5316\u53c2\u6570\u6709\u7a7a");
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("channel", (Object)channel);
        List<String> listParams = ApiManager.getParamsList(false, String.valueOf(channel));
        String json = ApiManager.getParamsJsonObject(jsonObject, listParams).toJSONString();
        Charset utf8 = Charset.forName("utf-8");
        ApiManager.post(UrlConfig.URL_ROOT + UrlConfig.ChannelpayGetAppVersion, json, new OkNetCallBack(){

            @Override
            public void OnResult(OkBean response) {
                if (response.isSucceed()) {
                    if (netCallBack != null) {
                        netCallBack.success(response.getData().toJSONString());
                    }
                    UnityPlayerBridge.sendMsg(ApiManager.UNITY_OBJECT, "ChannelpayGetAppVersion", response.getData().toJSONString());
                } else {
                    if (netCallBack != null) {
                        netCallBack.failed(response.getData().toJSONString());
                    }
                    UnityPlayerBridge.sendMsg(ApiManager.UNITY_OBJECT, "ChannelpayGetAppVersion", response.getData().toJSONString());
                }
            }
        });
    }

    public static void configSync(String appVer, int lastVer) {
        ApiManager.configSync(appVer, lastVer, null);
    }

    public static void configSync(String appVer, int lastVer, final NetCallBack netCallBack) {
        if (TextUtils.isEmpty((CharSequence)mGameId) || TextUtils.isEmpty((CharSequence)mGameSecret)) {
            throw new NullPointerException("\u521d\u59cb\u5316\u53c2\u6570\u6709\u7a7a");
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("appVer", (Object)appVer);
        jsonObject.put("lastVer", (Object)lastVer);
        List<String> listParams = ApiManager.getParamsList(false, appVer, String.valueOf(lastVer));
        String json = ApiManager.getParamsJsonObject(jsonObject, listParams).toJSONString();
        ApiManager.post(UrlConfig.URL_ROOT + UrlConfig.ConfigSync, json, new OkNetCallBack(){

            @Override
            public void OnResult(OkBean response) {
                if (response.isSucceed()) {
                    JSONObject successJson = ApiManager.getJsonDec(response, false);
                    if (netCallBack != null) {
                        netCallBack.success(successJson.toJSONString());
                    }
                    UnityPlayerBridge.sendMsg(ApiManager.UNITY_OBJECT, "ConfigSync", successJson.toString());
                } else {
                    LogUtils.e(response.getData().toString());
                    if (netCallBack != null) {
                        netCallBack.failed(response.getData().toString());
                    }
                    UnityPlayerBridge.sendMsg(ApiManager.UNITY_OBJECT, "ConfigSync", response.getData().toJSONString());
                }
            }
        });
    }

    public static void dedeemConsume(String redeemcode, final NetCallBack netCallBack) {
        if (TextUtils.isEmpty((CharSequence)mGameId) || TextUtils.isEmpty((CharSequence)mGameSecret)) {
            throw new NullPointerException("\u521d\u59cb\u5316\u53c2\u6570\u6709\u7a7a");
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("redeemcode", (Object)redeemcode);
        List<String> listParams = ApiManager.getParamsList(false, redeemcode);
        String json = ApiManager.getParamsJsonObject(jsonObject, listParams).toJSONString();
        ApiManager.post(UrlConfig.URL_ROOT + UrlConfig.DedeemConsume, json, new OkNetCallBack(){

            @Override
            public void OnResult(OkBean response) {
                if (response.isSucceed()) {
                    JSONObject successJson = ApiManager.getJsonDec(response, false);
                    UnityPlayerBridge.sendMsg(ApiManager.UNITY_OBJECT, "DedeemConsume", successJson.toString());
                    if (netCallBack != null) {
                        netCallBack.success(successJson.toJSONString());
                    }
                } else {
                    LogUtils.d(response.getData().toString());
                    UnityPlayerBridge.sendMsg(ApiManager.UNITY_OBJECT, "DedeemConsume", response.getData().toString());
                    if (netCallBack != null) {
                        netCallBack.failed(response.getData().toJSONString());
                    }
                }
            }
        });
    }

    public static void userLogin(String id2, int type, String name, String icon) {
        ApiManager.userLogin(id2, type, name, icon, null);
    }

    public static void userLogin(String id2, int type, String name, String icon, final NetCallBack netCallBack) {
        if (TextUtils.isEmpty((CharSequence)mGameId) || TextUtils.isEmpty((CharSequence)mGameSecret)) {
            throw new NullPointerException("\u521d\u59cb\u5316\u53c2\u6570\u6709\u7a7a");
        }
        List<String> listParams = ApiManager.getParamsList(false, String.valueOf(type), id2, name, icon);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("markid", (Object)id2);
        jsonObject.put("type", (Object)type);
        jsonObject.put("name", (Object)name);
        jsonObject.put("icon", (Object)icon);
        String json = ApiManager.getParamsJsonObject(jsonObject, listParams).toJSONString();
        ApiManager.post(UrlConfig.URL_ROOT + UrlConfig.UserLogin, json, new OkNetCallBack(){

            @Override
            public void OnResult(OkBean bean) {
                if (bean.isSucceed()) {
                    String data = bean.getData().getString("data");
                    JSONObject dataJson = JSON.parseObject((String)data);
                    mUserId = dataJson.getString("userid");
                    mToken = dataJson.getString("tokenid");
                    SPUtils.getInstance().put("USER_ID", mUserId);
                    SPUtils.getInstance().put("TOKEN", mToken);
                    account_type = "account";
                    JSONObject successJson = new JSONObject();
                    successJson.put("code", (Object)200);
                    successJson.put("data", (Object)dataJson);
                    LogUtils.d(successJson.toString());
                    UnityPlayerBridge.sendMsg(ApiManager.UNITY_OBJECT, "UserLogin", successJson.toString());
                    JSONObject labels = new JSONObject();
                    ApiManager.dataReport("loginin", mUserId, "\u767b\u5f55", labels);
                    ApiManager.keyData(mUserId);
                    if (netCallBack != null) {
                        netCallBack.success(successJson.toJSONString());
                    }
                } else {
                    LogUtils.e(bean.getData().toString());
                    UnityPlayerBridge.sendMsg(ApiManager.UNITY_OBJECT, "UserLogin", bean.getData().toJSONString());
                    if (netCallBack != null) {
                        netCallBack.failed(bean.getData().toJSONString());
                    }
                }
            }
        });
    }

    public static void userSync(String archive, int archiveVersion) {
        ApiManager.userSync(archive, archiveVersion, null);
    }

    public static void userSync(String archive, int archiveVersion, final NetCallBack netCallBack) {
        if (TextUtils.isEmpty((CharSequence)mGameId) || TextUtils.isEmpty((CharSequence)mGameSecret)) {
            throw new NullPointerException("\u521d\u59cb\u5316\u53c2\u6570\u6709\u7a7a");
        }
        if (TextUtils.isEmpty((CharSequence)mUserId) || TextUtils.isEmpty((CharSequence)mToken)) {
            UnityPlayerBridge.sendMsg(UNITY_OBJECT, "LoginStatus", "0");
            return;
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("archive", (Object)archive);
        jsonObject.put("archiveVersion", (Object)archiveVersion);
        jsonObject.put("userid", (Object)mUserId);
        jsonObject.put("token", (Object)mToken);
        List<String> listParams = ApiManager.getParamsList(true, archive, String.valueOf(archiveVersion));
        String json = ApiManager.getParamsJsonObject(jsonObject, listParams).toJSONString();
        ApiManager.post(UrlConfig.URL_ROOT + UrlConfig.UserSync, json, new OkNetCallBack(){

            @Override
            public void OnResult(OkBean response) {
                if (response.isSucceed()) {
                    JSONObject successJson = ApiManager.getJsonDec(response, true);
                    LogUtils.d(successJson.toString());
                    if (netCallBack != null) {
                        netCallBack.success(successJson.toString());
                    }
                    UnityPlayerBridge.sendMsg(ApiManager.UNITY_OBJECT, "UserSync", successJson.toString());
                } else {
                    LogUtils.d(response.getData().toString());
                    if (netCallBack != null) {
                        netCallBack.failed(response.getData().toString());
                    }
                    UnityPlayerBridge.sendMsg(ApiManager.UNITY_OBJECT, "UserSync", response.getData().toJSONString());
                }
            }
        });
    }

    @Deprecated
    public static void userSyncStream(String archive, int archiveVersion) {
        if (TextUtils.isEmpty((CharSequence)mGameId) || TextUtils.isEmpty((CharSequence)mGameSecret)) {
            throw new NullPointerException("\u521d\u59cb\u5316\u53c2\u6570\u6709\u7a7a");
        }
        if (TextUtils.isEmpty((CharSequence)mUserId) || TextUtils.isEmpty((CharSequence)mToken)) {
            UnityPlayerBridge.sendMsg(UNITY_OBJECT, "LoginStatus", "0");
            return;
        }
        int timestamp = (int)(System.currentTimeMillis() / 1000L);
        String nonce = String.valueOf(System.currentTimeMillis());
        ArrayList<String> list = new ArrayList<String>();
        list.add(archive);
        list.add(String.valueOf(archiveVersion));
        list.add(mUserId);
        list.add(mToken);
        list.add(nonce);
        list.add(String.valueOf(timestamp));
        list.add(mGameId);
        list.add(mGameSecret);
        Collections.sort(list);
        String signValue = MD5Util.getMD5String(MD5Util.listToString(list, '&'));
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("archive", (Object)archive);
        jsonObject.put("archiveVersion", (Object)archiveVersion);
        jsonObject.put("userid", (Object)mUserId);
        jsonObject.put("token", (Object)mToken);
        jsonObject.put("nonce", (Object)nonce);
        jsonObject.put("timestamp", (Object)timestamp);
        jsonObject.put("gameid", (Object)mGameId);
        jsonObject.put("sign", (Object)signValue);
        String json = jsonObject.toJSONString();
        ApiManager.post(UrlConfig.URL_ROOT + UrlConfig.UserSyncStream, json, new OkNetCallBack(){

            @Override
            public void OnResult(OkBean response) {
                if (response.isSucceed()) {
                    JSONObject successJson = ApiManager.getJsonDec(response, true);
                    LogUtils.d(successJson.toString());
                    UnityPlayerBridge.sendMsg(ApiManager.UNITY_OBJECT, "UserSyncStream", successJson.toString());
                } else {
                    LogUtils.d(response.getData().toString());
                    UnityPlayerBridge.sendMsg(ApiManager.UNITY_OBJECT, "UserSyncStream", response.getData().toJSONString());
                }
            }
        });
    }

    public static void userHeartbeat() {
        ApiManager.userHeartbeat(null);
    }

    public static void userHeartbeat(final NetCallBack netCallBack) {
        if (TextUtils.isEmpty((CharSequence)mGameId) || TextUtils.isEmpty((CharSequence)mGameSecret)) {
            throw new NullPointerException("\u521d\u59cb\u5316\u53c2\u6570\u6709\u7a7a");
        }
        if (TextUtils.isEmpty((CharSequence)mUserId) || TextUtils.isEmpty((CharSequence)mToken)) {
            UnityPlayerBridge.sendMsg(UNITY_OBJECT, "LoginStatus", "0");
            return;
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("userid", (Object)mUserId);
        jsonObject.put("token", (Object)mToken);
        List<String> listParams = ApiManager.getParamsList(true, new String[0]);
        String json = ApiManager.getParamsJsonObject(jsonObject, listParams).toJSONString();
        ApiManager.post(UrlConfig.URL_ROOT + UrlConfig.UserHeartbeat, json, new OkNetCallBack(){

            @Override
            public void OnResult(OkBean response) {
                if (response.isSucceed()) {
                    if (netCallBack != null) {
                        netCallBack.success(response.getData().toString());
                    }
                    UnityPlayerBridge.sendMsg(ApiManager.UNITY_OBJECT, "UserHeartbeat", response.getData().toString());
                } else {
                    if (netCallBack != null) {
                        netCallBack.failed(response.getData().toString());
                    }
                    LogUtils.d(response.getData().toString());
                    UnityPlayerBridge.sendMsg(ApiManager.UNITY_OBJECT, "UserHeartbeat", response.getData().toJSONString());
                }
            }
        });
    }

    public static void userUploadScore(int score, String info, String rankingid) {
        ApiManager.userUploadScore(score, info, rankingid, null);
    }

    public static void userUploadScore(int score, String info, String rankingid, final NetCallBack netCallBack) {
        if (TextUtils.isEmpty((CharSequence)mGameId) || TextUtils.isEmpty((CharSequence)mGameSecret)) {
            throw new NullPointerException("\u521d\u59cb\u5316\u53c2\u6570\u6709\u7a7a");
        }
        if (TextUtils.isEmpty((CharSequence)mUserId) || TextUtils.isEmpty((CharSequence)mToken)) {
            UnityPlayerBridge.sendMsg(UNITY_OBJECT, "LoginStatus", "0");
            return;
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("score", (Object)score);
        jsonObject.put("info", (Object)info);
        jsonObject.put("rankingid", (Object)rankingid);
        jsonObject.put("userid", (Object)mUserId);
        jsonObject.put("token", (Object)mToken);
        List<String> listParams = ApiManager.getParamsList(true, String.valueOf(score), info, rankingid);
        String json = ApiManager.getParamsJsonObject(jsonObject, listParams).toJSONString();
        ApiManager.post(UrlConfig.URL_ROOT + UrlConfig.UserUploadScore, json, new OkNetCallBack(){

            @Override
            public void OnResult(OkBean response) {
                if (response.isSucceed()) {
                    if (netCallBack != null) {
                        netCallBack.success(response.getData().toJSONString());
                    }
                    UnityPlayerBridge.sendMsg(ApiManager.UNITY_OBJECT, "UserUploadScore", response.getData().toJSONString());
                } else {
                    if (netCallBack != null) {
                        netCallBack.failed(response.getData().toJSONString());
                    }
                    LogUtils.d(response.getData().toString());
                    UnityPlayerBridge.sendMsg(ApiManager.UNITY_OBJECT, "UserUploadScore", response.getData().toJSONString());
                }
            }
        });
    }

    public static void userGetUserRank(String rankingid) {
        ApiManager.userGetUserRank(rankingid, null);
    }

    public static void userGetUserRank(String rankingid, final NetCallBack netCallBack) {
        if (TextUtils.isEmpty((CharSequence)mGameId) || TextUtils.isEmpty((CharSequence)mGameSecret)) {
            throw new NullPointerException("\u521d\u59cb\u5316\u53c2\u6570\u6709\u7a7a");
        }
        if (TextUtils.isEmpty((CharSequence)mUserId) || TextUtils.isEmpty((CharSequence)mToken)) {
            UnityPlayerBridge.sendMsg(UNITY_OBJECT, "LoginStatus", "0");
            return;
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("rankingid", (Object)rankingid);
        jsonObject.put("userid", (Object)mUserId);
        jsonObject.put("token", (Object)mToken);
        List<String> listParams = ApiManager.getParamsList(true, rankingid);
        String json = ApiManager.getParamsJsonObject(jsonObject, listParams).toJSONString();
        ApiManager.post(UrlConfig.URL_ROOT + UrlConfig.UserGetUserRank, json, new OkNetCallBack(){

            @Override
            public void OnResult(OkBean response) {
                if (response.isSucceed()) {
                    JSONObject successJson = ApiManager.getJsonDec(response, true);
                    LogUtils.d(successJson.toString());
                    if (netCallBack != null) {
                        netCallBack.success(successJson.toString());
                    }
                    UnityPlayerBridge.sendMsg(ApiManager.UNITY_OBJECT, "UserGetUserRank", successJson.toString());
                } else {
                    LogUtils.e(response.getData().toString());
                    if (netCallBack != null) {
                        netCallBack.failed(response.getData().toString());
                    }
                    UnityPlayerBridge.sendMsg(ApiManager.UNITY_OBJECT, "UserGetUserRank", response.getData().toJSONString());
                }
            }
        });
    }

    public static void feedbackSubmit(String msg, String contact, String documentInfo) {
        ApiManager.feedbackSubmit(msg, contact, documentInfo, null);
    }

    public static void feedbackSubmit(String msg, String contact, String documentInfo, final NetCallBack netCallBack) {
        if (TextUtils.isEmpty((CharSequence)mGameId) || TextUtils.isEmpty((CharSequence)mGameSecret)) {
            UnityPlayerBridge.sendMsg(UNITY_OBJECT, "feedbackSubmit", "\u672a\u521d\u59cb\u5316API");
            LogUtils.e("\u672a\u521d\u59cb\u5316API");
            return;
        }
        if (TextUtils.isEmpty((CharSequence)msg) || TextUtils.isEmpty((CharSequence)contact) || TextUtils.isEmpty((CharSequence)documentInfo)) {
            UnityPlayerBridge.sendMsg(UNITY_OBJECT, "feedbackSubmit", "\u7528\u6237\u672a\u586b\u5199\u4fe1\u606f");
            LogUtils.e("\u53cd\u9988\u4fe1\u606f\u4e0d\u5b8c\u6574");
            return;
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("msg", (Object)msg);
        jsonObject.put("contact", (Object)contact);
        jsonObject.put("documentinfo", (Object)documentInfo);
        jsonObject.put("appVer", (Object)String.valueOf(PackageUtils.getVersionCode((Context)mActivity)));
        jsonObject.put("device", (Object)(Build.BRAND + Build.MODEL));
        jsonObject.put("countryCode", (Object)PackageUtils.getCountryZipCode((Context)mActivity));
        String mId = mUserId;
        if (TextUtils.isEmpty((CharSequence)mUserId)) {
            mId = AppsFlyerLib.getInstance().getAppsFlyerUID((Context)mActivity);
        }
        if (TextUtils.isEmpty((CharSequence)mId)) {
            mId = "";
        }
        jsonObject.put("clientuserid", (Object)mId);
        List<String> listParams = ApiManager.getParamsList(false, msg, contact, documentInfo, String.valueOf(PackageUtils.getVersionCode((Context)mActivity)), Build.BRAND + Build.MODEL, PackageUtils.getCountryZipCode((Context)mActivity), mId);
        String json = ApiManager.getParamsJsonObject(jsonObject, listParams).toJSONString();
        ApiManager.post(UrlConfig.URL_ROOT + UrlConfig.feedback, json, new OkNetCallBack(){

            @Override
            public void OnResult(OkBean response) {
                if (response.isSucceed()) {
                    UnityPlayerBridge.sendMsg(ApiManager.UNITY_OBJECT, "feedBackSubmitComplected", response.getData().toString());
                    if (netCallBack != null) {
                        netCallBack.success(response.getData().toString());
                    }
                } else {
                    LogUtils.e(response.getData().toString());
                    UnityPlayerBridge.sendMsg(ApiManager.UNITY_OBJECT, "feedBackSubmitComplected", response.getData().toJSONString());
                    if (netCallBack != null) {
                        netCallBack.failed(response.getData().toJSONString());
                    }
                }
            }
        });
    }

    public static void feedbackAddExtraData(String contact, final NetCallBack netCallBack) {
        if (TextUtils.isEmpty((CharSequence)mGameId) || TextUtils.isEmpty((CharSequence)mGameSecret)) {
            UnityPlayerBridge.sendMsg(UNITY_OBJECT, "feedbackSubmit", "\u672a\u521d\u59cb\u5316API");
            LogUtils.e("\u672a\u521d\u59cb\u5316API");
            return;
        }
        JSONObject content = JSON.parseObject((String)contact);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("content", (Object)content.toJSONString());
        String mId = mUserId;
        if (TextUtils.isEmpty((CharSequence)mUserId)) {
            mId = AppsFlyerLib.getInstance().getAppsFlyerUID((Context)mActivity);
        }
        if (TextUtils.isEmpty((CharSequence)mId)) {
            mId = "";
        }
        jsonObject.put("clientuserid", (Object)mId);
        List<String> listParams = ApiManager.getParamsList(false, contact, mId);
        String json = ApiManager.getParamsJsonObject(jsonObject, listParams).toJSONString();
        ApiManager.post(UrlConfig.URL_ROOT + UrlConfig.FeedbackAddExtraData, json, new OkNetCallBack(){

            @Override
            public void OnResult(OkBean response) {
                if (response.isSucceed()) {
                    if (netCallBack != null) {
                        netCallBack.success(response.getData().toString());
                    }
                } else {
                    LogUtils.e(response.getData().toString());
                    if (netCallBack != null) {
                        netCallBack.failed(response.getData().toJSONString());
                    }
                }
            }
        });
    }

    public static void getActivitiesWithChannel(String channel, String language) {
        ApiManager.getActivitiesWithChannel(channel, language, null);
    }

    public static void getActivitiesWithChannel(String channel, String language, final NetCallBack netCallBack) {
        if (TextUtils.isEmpty((CharSequence)mGameId) || TextUtils.isEmpty((CharSequence)mGameSecret)) {
            throw new NullPointerException("\u521d\u59cb\u5316\u53c2\u6570\u6709\u7a7a");
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("channel", (Object)channel);
        jsonObject.put("language", (Object)language);
        List<String> listParams = ApiManager.getParamsList(false, channel, language);
        String json = ApiManager.getParamsJsonObject(jsonObject, listParams).toJSONString();
        ApiManager.post(UrlConfig.URL_ROOT + UrlConfig.getActivitiesWithChannel, json, new OkNetCallBack(){

            @Override
            public void OnResult(OkBean response) {
                if (response.isSucceed()) {
                    JSONObject successJson = ApiManager.getJsonDec(response, false);
                    LogUtils.d(successJson.toString());
                    if (netCallBack != null) {
                        netCallBack.success(successJson.toJSONString());
                    }
                    UnityPlayerBridge.sendMsg(ApiManager.UNITY_OBJECT, "GetActivitiesWithChannel", successJson.toString());
                } else {
                    LogUtils.d(response.getData().toString());
                    if (netCallBack != null) {
                        netCallBack.failed(response.getData().toJSONString());
                    }
                    UnityPlayerBridge.sendMsg(ApiManager.UNITY_OBJECT, "GetActivitiesWithChannel", response.getData().toJSONString());
                }
            }
        });
    }

    public static void gameAnoncementsWithChannel(String channel, String version, String language) {
        ApiManager.gameAnoncementsWithChannel(channel, version, language, null);
    }

    public static void gameAnoncementsWithChannel(String channel, String version, String language, final NetCallBack netCallBack) {
        if (TextUtils.isEmpty((CharSequence)mGameId) || TextUtils.isEmpty((CharSequence)mGameSecret)) {
            throw new NullPointerException("\u521d\u59cb\u5316\u53c2\u6570\u6709\u7a7a");
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("channel", (Object)channel);
        jsonObject.put("language", (Object)language);
        jsonObject.put("version", (Object)version);
        List<String> listParams = ApiManager.getParamsList(false, channel, version, language);
        String json = ApiManager.getParamsJsonObject(jsonObject, listParams).toJSONString();
        ApiManager.post(UrlConfig.URL_ROOT + UrlConfig.gameAnoncementsWithChannel, json, new OkNetCallBack(){

            @Override
            public void OnResult(OkBean response) {
                if (response.isSucceed()) {
                    JSONObject successJson = ApiManager.getJsonDec(response, false);
                    LogUtils.d(successJson.toString());
                    if (netCallBack != null) {
                        netCallBack.success(successJson.toJSONString());
                    }
                    UnityPlayerBridge.sendMsg(ApiManager.UNITY_OBJECT, "GameAnoncementsWithChannel", successJson.toString());
                } else {
                    LogUtils.d(response.getData().toString());
                    if (netCallBack != null) {
                        netCallBack.failed(response.getData().toJSONString());
                    }
                    UnityPlayerBridge.sendMsg(ApiManager.UNITY_OBJECT, "GameAnoncementsWithChannel", response.getData().toJSONString());
                }
            }
        });
    }

    public static void redeemConsume(String redeemcode, String channel) {
        ApiManager.redeemConsume(redeemcode, channel, null);
    }

    public static void redeemConsume(String redeemcode, String channel, final NetCallBack netCallBack) {
        if (TextUtils.isEmpty((CharSequence)mGameId) || TextUtils.isEmpty((CharSequence)mGameSecret)) {
            throw new NullPointerException("\u521d\u59cb\u5316\u53c2\u6570\u6709\u7a7a");
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("channel", (Object)channel);
        jsonObject.put("redeemcode", (Object)redeemcode);
        List<String> listParams = ApiManager.getParamsList(false, channel, redeemcode);
        String json = ApiManager.getParamsJsonObject(jsonObject, listParams).toJSONString();
        ApiManager.post(UrlConfig.URL_ROOT + UrlConfig.RedeemConsume, json, new OkNetCallBack(){

            @Override
            public void OnResult(OkBean response) {
                if (response.isSucceed()) {
                    JSONObject successJson = ApiManager.getJsonDec(response, false);
                    LogUtils.d(successJson.toString());
                    if (netCallBack != null) {
                        netCallBack.success(successJson.toJSONString());
                    }
                    UnityPlayerBridge.sendMsg(ApiManager.UNITY_OBJECT, "RedeemConsume", successJson.toString());
                } else {
                    LogUtils.d(response.getData().toString());
                    if (netCallBack != null) {
                        netCallBack.failed(response.getData().toJSONString());
                    }
                    UnityPlayerBridge.sendMsg(ApiManager.UNITY_OBJECT, "RedeemConsume", response.getData().toJSONString());
                }
            }
        });
    }

    public static void redeemUserConsume(String redeemcode, String channel, String guid) {
        ApiManager.redeemUserConsume(redeemcode, channel, guid, null);
    }

    public static void redeemUserConsume(String redeemcode, String channel, String guid, final NetCallBack netCallBack) {
        if (TextUtils.isEmpty((CharSequence)mGameId) || TextUtils.isEmpty((CharSequence)mGameSecret)) {
            throw new NullPointerException("\u521d\u59cb\u5316\u53c2\u6570\u6709\u7a7a");
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("clientid", (Object)guid);
        jsonObject.put("channel", (Object)channel);
        jsonObject.put("redeemcode", (Object)redeemcode);
        List<String> listParams = ApiManager.getParamsList(false, channel, guid, redeemcode);
        String json = ApiManager.getParamsJsonObject(jsonObject, listParams).toJSONString();
        ApiManager.post(UrlConfig.URL_ROOT + UrlConfig.RedeemUserConsume, json, new OkNetCallBack(){

            @Override
            public void OnResult(OkBean response) {
                if (response.isSucceed()) {
                    JSONObject successJson = ApiManager.getJsonDec(response, false);
                    LogUtils.d(successJson.toString());
                    if (netCallBack != null) {
                        netCallBack.success(successJson.toJSONString());
                    }
                    UnityPlayerBridge.sendMsg(ApiManager.UNITY_OBJECT, "RedeemUserConsume", successJson.toString());
                } else {
                    LogUtils.d(response.getData().toString());
                    if (netCallBack != null) {
                        netCallBack.failed(response.getData().toJSONString());
                    }
                    UnityPlayerBridge.sendMsg(ApiManager.UNITY_OBJECT, "RedeemUserConsume", response.getData().toJSONString());
                }
            }
        });
    }

    public static void googleValidate(String payToken, String gporderId, String sku, String price, int skuType, String actId) {
        if (TextUtils.isEmpty((CharSequence)mGameId) || TextUtils.isEmpty((CharSequence)mGameSecret)) {
            throw new NullPointerException("\u521d\u59cb\u5316\u53c2\u6570\u6709\u7a7a");
        }
        if (actId == null) {
            actId = "";
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("paytoken", (Object)payToken);
        jsonObject.put("gporderid", (Object)gporderId);
        jsonObject.put("packagename", (Object)mActivity.getPackageName());
        jsonObject.put("sku", (Object)sku);
        jsonObject.put("price", (Object)price);
        jsonObject.put("skutype", (Object)skuType);
        jsonObject.put("actid", (Object)actId);
        List<String> listParams = ApiManager.getParamsList(false, payToken, gporderId, mActivity.getPackageName(), sku, price, String.valueOf(skuType), actId);
        String json = ApiManager.getParamsJsonObject(jsonObject, listParams).toJSONString();
        ApiManager.post(UrlConfig.URL_ROOT + UrlConfig.GoogleValidate, json, new OkNetCallBack(){

            @Override
            public void OnResult(OkBean response) {
                if (response.isSucceed()) {
                    JSONObject successJson = ApiManager.getJsonDec(response, false);
                    LogUtils.d(successJson.toString());
                    UnityPlayerBridge.sendMsg(ApiManager.UNITY_OBJECT, "GoogleValidate", successJson.toString());
                } else {
                    LogUtils.d(response.getData().toString());
                    UnityPlayerBridge.sendMsg(ApiManager.UNITY_OBJECT, "GoogleValidate", response.getData().toJSONString());
                }
            }
        });
    }

    public static void CheckParameter(String fb_id, String ad_ids, String umeng_id, String pangleId) {
        if (TextUtils.isEmpty((CharSequence)mGameId) || TextUtils.isEmpty((CharSequence)mGameSecret)) {
            throw new NullPointerException("\u521d\u59cb\u5316\u53c2\u6570\u6709\u7a7a");
        }
        String channelnametmp = "";
        String gameId = "";
        String facebookToken = "";
        ApplicationInfo appInfo = null;
        try {
            appInfo = mActivity.getPackageManager().getApplicationInfo(mActivity.getPackageName(), 128);
            gameId = appInfo.metaData.getString("com.google.android.gms.games.APP_ID");
            channelnametmp = appInfo.metaData.getString("com.google.android.gms.ads.APPLICATION_ID");
            facebookToken = appInfo.metaData.getString("com.facebook.sdk.ClientToken");
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("Gameid", (Object)mGameId);
        jsonObject.put("package_name", (Object)PackageUtils.getAppProcessName((Context)mActivity));
        jsonObject.put("fb_id", (Object)fb_id);
        jsonObject.put("facebookToken", (Object)facebookToken);
        jsonObject.put("admob_id", (Object)channelnametmp);
        jsonObject.put("google_game_id", (Object)gameId);
        jsonObject.put("ad_ids", (Object)ad_ids);
        jsonObject.put("umeng_id", (Object)umeng_id);
        jsonObject.put("pangleId", (Object)pangleId);
        jsonObject.put("sdk_version", (Object)"2.8.0");
        String json = jsonObject.toJSONString();
        ApiManager.post("https://gamecms.pottingmob.com/api/CheckParameter", json, new OkNetCallBack(){

            @Override
            public void OnResult(OkBean response) {
                LogUtils.d(response.getData().toString());
            }
        });
    }

    public static void Serverinfo() {
        ApiManager.Serverinfo(null);
    }

    public static void Serverinfo(final NetCallBack netCallBack) {
        if (TextUtils.isEmpty((CharSequence)mGameId) || TextUtils.isEmpty((CharSequence)mGameSecret)) {
            throw new NullPointerException("\u521d\u59cb\u5316\u53c2\u6570\u6709\u7a7a");
        }
        JSONObject jsonObject = new JSONObject();
        List<String> listParams = ApiManager.getParamsList(false, new String[0]);
        String json = ApiManager.getParamsJsonObject(jsonObject, listParams).toJSONString();
        ApiManager.post(UrlConfig.URL_ROOT + UrlConfig.Serverinfo, json, new OkNetCallBack(){

            @Override
            public void OnResult(OkBean response) {
                if (response.isSucceed()) {
                    JSONObject successJson = ApiManager.getJsonDec(response, false);
                    LogUtils.d(successJson.toString());
                    if (netCallBack != null) {
                        netCallBack.success(successJson.toString());
                    }
                    UnityPlayerBridge.sendMsg(ApiManager.UNITY_OBJECT, "Serverinfo", successJson.toString());
                } else {
                    LogUtils.d(response.getData().toString());
                    if (netCallBack != null) {
                        netCallBack.failed(response.getData().toJSONString());
                    }
                    UnityPlayerBridge.sendMsg(ApiManager.UNITY_OBJECT, "Serverinfo", response.getData().toJSONString());
                }
            }
        });
    }

    public static void googleValidate(String payToken, String gporderId, String sku, int skuType, String actId, final NetCallBack netCallBack) {
        if (TextUtils.isEmpty((CharSequence)mGameId) || TextUtils.isEmpty((CharSequence)mGameSecret)) {
            throw new NullPointerException("\u521d\u59cb\u5316\u53c2\u6570\u6709\u7a7a");
        }
        if (TextUtils.isEmpty((CharSequence)payToken)) {
            payToken = "";
        }
        if (TextUtils.isEmpty((CharSequence)gporderId)) {
            gporderId = "";
        }
        if (TextUtils.isEmpty((CharSequence)sku)) {
            sku = "";
        }
        if (TextUtils.isEmpty((CharSequence)actId)) {
            actId = "";
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("paytoken", (Object)payToken);
        jsonObject.put("gporderid", (Object)gporderId);
        jsonObject.put("packagename", (Object)mActivity.getPackageName());
        jsonObject.put("sku", (Object)sku);
        jsonObject.put("actid", (Object)actId);
        String mId = mUserId;
        if (TextUtils.isEmpty((CharSequence)mUserId)) {
            mId = AppsFlyerLib.getInstance().getAppsFlyerUID((Context)mActivity);
        }
        if (TextUtils.isEmpty((CharSequence)mId)) {
            mId = "";
        }
        jsonObject.put("clientuserid", (Object)mId);
        jsonObject.put("skutype", (Object)skuType);
        List<String> listParams = ApiManager.getParamsList(false, payToken, gporderId, mActivity.getPackageName(), sku, mId, String.valueOf(skuType), actId);
        String json = ApiManager.getParamsJsonObject(jsonObject, listParams).toJSONString();
        ApiManager.post(UrlConfig.URL_ROOT + UrlConfig.UserGoogleValidate, json, new OkNetCallBack(){

            @Override
            public void OnResult(OkBean response) {
                if (response.isSucceed()) {
                    String decryptData = ApiManager.getJsonDec(response, false).getString("data");
                    netCallBack.success(decryptData);
                } else {
                    LogUtils.e(response.getData().toString());
                    netCallBack.failed(response.getData().toJSONString());
                }
            }
        });
    }

    public static void dataReport(String key, String value, String remark, JSONObject labels) {
        ApiManager.dataReport(key, value, remark, labels.toString());
    }

    public static void dataReport(String key, String value, String remark, String labels) {
        if (TextUtils.isEmpty((CharSequence)mGameId) || TextUtils.isEmpty((CharSequence)mGameSecret)) {
            throw new NullPointerException("\u521d\u59cb\u5316\u53c2\u6570\u6709\u7a7a");
        }
        JSONObject jsonObject = new JSONObject();
        JSONObject events = new JSONObject();
        events.put("event_key", (Object)key);
        events.put("event_value", (Object)value);
        events.put("event_value_remark", (Object)remark);
        JSONObject labelsJson = JSON.parseObject((String)labels);
        events.put("labels", (Object)labelsJson);
        JSONArray jsonArray = new JSONArray();
        jsonArray.add((Object)events);
        JSONObject context = new JSONObject();
        context.put("device_id", (Object)PhoneUtils.getANDROID((Context)mActivity));
        context.put("region", (Object)PhoneUtils.getCountry((Context)mActivity));
        context.put("access", (Object)PhoneUtils.getNetworkState((Context)mActivity));
        context.put("os_version", (Object)Build.VERSION.RELEASE);
        context.put("device_model", (Object)(Build.BRAND + " " + Build.MODEL));
        context.put("resolution", (Object)PhoneUtils.getResolution((Context)mActivity));
        context.put("timezone", (Object)PhoneUtils.getTimeZone());
        TimeZone timeZone = TimeZone.getDefault();
        String id2 = timeZone.getID();
        context.put("timezone_name", (Object)id2);
        context.put("carrier", (Object)PhoneUtils.getSimOperatorByMnc());
        context.put("sdk_version", (Object)"2.8.0");
        context.put("display_name", (Object)PackageUtils.getAppName((Context)mActivity));
        context.put("sdk_type", (Object)"lg_sdk");
        context.put("mac_path", (Object)PhoneUtils.getMacFromHardware((Context)mActivity));
        context.put("channel", (Object)mChannel);
        context.put("account_type", (Object)account_type);
        context.put("language", (Object)PhoneUtils.getLanguage((Context)mActivity));
        context.put("os", (Object)"Android");
        context.put("openud_id", (Object)"");
        context.put("package", (Object)PackageUtils.getAppProcessName((Context)mActivity));
        context.put("app_version", (Object)PackageUtils.getVersionName((Context)mActivity));
        context.put("imei", (Object)"");
        context.put("google_ad_id", (Object)adid);
        context.put("af_id", (Object)AppsFlyerLib.getInstance().getAppsFlyerUID((Context)mActivity));
        context.put("android_id", (Object)PhoneUtils.getANDROID((Context)mActivity));
        context.put("user_id", (Object)mUserId);
        context.put("game_id", (Object)mGameId);
        jsonObject.put("events", (Object)jsonArray);
        jsonObject.put("context", (Object)context);
        jsonObject.put("magic_tag", (Object)"app_log");
        JSONObject af_data = TextUtils.isEmpty((CharSequence)StatisticsManager.conversionData) ? new JSONObject() : JSON.parseObject((String)StatisticsManager.conversionData);
        jsonObject.put("af_data", (Object)af_data);
        ApiManager.post("https://logapi.pottingmob.com" + UrlConfig.datareport, jsonObject.toJSONString(), new OkNetCallBack(){

            @Override
            public void OnResult(OkBean response) {
                LogUtils.d(response.getData().toString());
            }
        });
    }

    public static void gameInfoUpload(String values) {
        if (TextUtils.isEmpty((CharSequence)mGameId)) {
            throw new NullPointerException("\u521d\u59cb\u5316\u53c2\u6570\u6709\u7a7a");
        }
        if (TextUtils.isEmpty((CharSequence)mUserId) || TextUtils.isEmpty((CharSequence)mToken)) {
            UnityPlayerBridge.sendMsg(UNITY_OBJECT, "LoginStatus", "0");
            return;
        }
        Map map = null;
        if (!TextUtils.isEmpty((CharSequence)values)) {
            map = (Map)new Gson().fromJson(values, new TypeToken<Map<String, String>>(){}.getType());
        }
        StringBuffer infodata = new StringBuffer();
        if (map != null && map.size() > 0) {
            for (Map.Entry entry : map.entrySet()) {
                System.out.println("key = " + (String)entry.getKey() + ", value = " + (String)entry.getValue());
                infodata.append((String)entry.getKey() + "=" + (String)entry.getValue() + "&");
            }
            infodata.deleteCharAt(infodata.length() - 1);
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("infodata", (Object)infodata.toString());
        jsonObject.put("userid", (Object)mUserId);
        jsonObject.put("token", (Object)mToken);
        List<String> listParams = ApiManager.getParamsList(true, infodata.toString());
        String json = ApiManager.getParamsJsonObject(jsonObject, listParams).toJSONString();
        ApiManager.post(UrlConfig.URL_ROOT + UrlConfig.GamekeyinfoUpload, json, new OkNetCallBack(){

            @Override
            public void OnResult(OkBean response) {
                if (response.isSucceed()) {
                    JSONObject successJson = ApiManager.getJsonDec(response, false);
                    LogUtils.d(successJson.toString());
                    UnityPlayerBridge.sendMsg(ApiManager.UNITY_OBJECT, "GamekeyinfoUpload", successJson.toString());
                } else {
                    LogUtils.e(response.getData().toString());
                    UnityPlayerBridge.sendMsg(ApiManager.UNITY_OBJECT, "GamekeyinfoUpload", response.getData().toJSONString());
                }
            }
        });
    }

    public static List<String> getParamsList(boolean isNeedLogin, String ... params) {
        int timestamp = (int)(System.currentTimeMillis() / 1000L);
        String nonce = String.valueOf(System.currentTimeMillis());
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(params));
        if (isNeedLogin) {
            list.add(mUserId);
            list.add(mToken);
        }
        list.add(nonce);
        list.add(String.valueOf(timestamp));
        list.add(mGameId);
        list.add(mGameSecret);
        Collections.sort(list);
        String signValue = MD5Util.getMD5String(MD5Util.listToString(list, '&'));
        ArrayList<String> listParams = new ArrayList<String>();
        listParams.add(nonce);
        listParams.add(String.valueOf(timestamp));
        listParams.add(signValue);
        return listParams;
    }

    public static JSONObject getParamsJsonObject(JSONObject jsonObject, List<String> listParams) {
        if (jsonObject == null) {
            jsonObject = new JSONObject();
        }
        jsonObject.put("nonce", (Object)listParams.get(0));
        jsonObject.put("timestamp", (Object)Integer.valueOf(listParams.get(1)));
        jsonObject.put("gameid", (Object)mGameId);
        jsonObject.put("sign", (Object)listParams.get(2));
        return jsonObject;
    }

    static {
        account_type = "guest";
        adid = "";
        client = new OkHttpClient();
        OKJSON = MediaType.get((String)"application/json; charset=utf-8");
    }
}

