/*
 * Decompiled with CFR 0.152.
 */
package com.code.utils;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.content.pm.SigningInfo;
import android.os.Build;
import android.text.TextUtils;
import com.alibaba.fastjson.JSONObject;
import com.youloft.api.ApiManager;
import com.youloft.core.utils.MD5Util;
import com.youloft.statistics.StatisticsManager;
import java.io.ByteArrayInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateFactory;
import java.util.List;
import java.util.Random;

public class SignCheckUtil {
    private Context context;
    private String cer = null;
    private String type = "SHA1";
    private List<String> sha1RealCer = null;
    private static final String TAG = "sign";

    public SignCheckUtil(Context context, String type) {
        this.context = context;
        this.type = type;
    }

    public void setSha1RealCer(List<String> sha1RealCer) {
        this.sha1RealCer = sha1RealCer;
    }

    public String getCertificateSHA1Fingerprint() {
        String hexString = "";
        PackageManager pm = this.context.getPackageManager();
        String packageName = this.context.getPackageName();
        Signature[] signatures = null;
        try {
            PackageInfo packageInfo;
            if (Build.VERSION.SDK_INT > 28) {
                packageInfo = this.context.getPackageManager().getPackageInfo(this.context.getPackageName(), 0x8000000);
                SigningInfo signingInfo = packageInfo.signingInfo;
                signatures = signingInfo.getApkContentsSigners();
            } else {
                packageInfo = pm.getPackageInfo(packageName, 64);
                signatures = packageInfo.signatures;
            }
            byte[] cert = signatures[0].toByteArray();
            ByteArrayInputStream input = new ByteArrayInputStream(cert);
            CertificateFactory cf = CertificateFactory.getInstance("X509");
            Certificate c = null;
            c = cf.generateCertificate(input);
            MessageDigest md = MessageDigest.getInstance(this.type);
            byte[] publicKey = md.digest(c.getEncoded());
            hexString = this.byte2HexFormatted(publicKey);
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e1) {
            e1.printStackTrace();
        }
        catch (CertificateEncodingException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return hexString.trim();
    }

    private String byte2HexFormatted(byte[] arr) {
        StringBuilder str = new StringBuilder(arr.length * 2);
        for (int i = 0; i < arr.length; ++i) {
            String h = Integer.toHexString(arr[i]);
            int l = h.length();
            if (l == 1) {
                h = "0" + h;
            }
            if (l > 2) {
                h = h.substring(l - 2, l);
            }
            str.append(h.toUpperCase());
            if (i >= arr.length - 1) continue;
            str.append(':');
        }
        return str.toString();
    }

    public boolean check() {
        if (this.sha1RealCer == null) {
            return true;
        }
        this.cer = this.getCertificateSHA1Fingerprint();
        if (TextUtils.isEmpty((CharSequence)this.cer)) {
            return true;
        }
        if (this.sha1RealCer.size() < 1) {
            return true;
        }
        if (TextUtils.equals((CharSequence)this.type, (CharSequence)"SHA1")) {
            for (String s : this.sha1RealCer) {
                if (!MD5Util.getMD5String(this.cer).equals(s)) continue;
                return true;
            }
        }
        JSONObject labels = new JSONObject();
        labels.put("value", (Object)"0");
        StatisticsManager.customEvent("_youloftcheat", labels.toJSONString());
        ApiManager.dataReport("_youloftcheat", "0", "_youloftcheat", labels);
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Random random = new Random();
                    int i = random.nextInt(120);
                    Thread.sleep(i * 1000);
                    throw new NullPointerException("error");
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    return;
                }
            }
        }).start();
        return false;
    }
}

