/*
 * Decompiled with CFR 0.152.
 */
package com.youloft.advert;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.Display;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.applovin.sdk.AppLovinPrivacySettings;
import com.applovin.sdk.AppLovinSdk;
import com.appsflyer.AppsFlyerLib;
import com.appsflyer.adrevenue.AppsFlyerAdRevenue;
import com.appsflyer.adrevenue.adnetworks.AppsFlyerAdNetworkEventType;
import com.appsflyer.adrevenue.adnetworks.generic.MediationNetwork;
import com.code.advert.AppOpenManager;
import com.google.android.gms.ads.AdError;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.AdValue;
import com.google.android.gms.ads.AdView;
import com.google.android.gms.ads.AdapterResponseInfo;
import com.google.android.gms.ads.FullScreenContentCallback;
import com.google.android.gms.ads.LoadAdError;
import com.google.android.gms.ads.MobileAds;
import com.google.android.gms.ads.OnPaidEventListener;
import com.google.android.gms.ads.OnUserEarnedRewardListener;
import com.google.android.gms.ads.ResponseInfo;
import com.google.android.gms.ads.interstitial.InterstitialAd;
import com.google.android.gms.ads.interstitial.InterstitialAdLoadCallback;
import com.google.android.gms.ads.rewarded.RewardItem;
import com.google.android.gms.ads.rewarded.RewardedAd;
import com.google.android.gms.ads.rewarded.RewardedAdLoadCallback;
import com.google.android.gms.ads.rewardedinterstitial.RewardedInterstitialAd;
import com.google.android.gms.ads.rewardedinterstitial.RewardedInterstitialAdLoadCallback;
import com.google.android.ump.ConsentDebugSettings;
import com.google.android.ump.ConsentForm;
import com.google.android.ump.ConsentInformation;
import com.google.android.ump.ConsentRequestParameters;
import com.google.android.ump.FormError;
import com.google.android.ump.UserMessagingPlatform;
import com.google.gson.Gson;
import com.ironsource.mediationsdk.IronSource;
import com.tapjoy.TJPrivacyPolicy;
import com.tapjoy.Tapjoy;
import com.unity3d.ads.metadata.MetaData;
import com.youloft.advert.AdvertisingIdClient;
import com.youloft.advert.bean.FireBaseConfigAdsBean;
import com.youloft.advert.callback.BannerAdListener;
import com.youloft.advert.callback.InterstitialAdListener;
import com.youloft.advert.callback.RewardedAdListener;
import com.youloft.advert.callback.RewardedInterstitialAdListener;
import com.youloft.api.ApiManager;
import com.youloft.core.UnityPlayerBridge;
import com.youloft.core.utils.LogUtils;
import com.youloft.statistics.R;
import com.youloft.statistics.StatisticsManager;
import java.util.ArrayList;
import java.util.Currency;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import org.json.JSONException;
import org.json.JSONObject;

public class YouLoftAdManager {
    private static final String TAG = "YouLoftAdManager";
    private static long maxValidateTime = 1200000L;
    private static long localTime = System.currentTimeMillis();
    private static long overTime = 30000L;
    private static long repeatTime = 120000L;
    private List<String> bannerAdUnits;
    private List<String> interstitialAdUnits;
    private List<String> rewardedVideoAdUnits;
    private List<String> rewardedInterstitialAdUnits;
    private List<String> openIds;
    private static YouLoftAdManager instance = null;
    private int bannerIndex = 0;
    private int interstitialIndex = 0;
    private AdView adView;
    private Handler mHandler;
    private Runnable runnable;
    public static Activity mActivity;
    private BannerAdListener mBannerAdListener;
    private InterstitialAdListener mInterstitialAdListener;
    private RewardedInterstitialAdListener mRewardedInterstitialAdListener;
    private InterstitialAd mInterstitialAd;
    private RewardedAdListener mRewardedAdListener;
    private HashMap<String, RewardedAd> rewardedAdHashMap = new HashMap();
    private HashMap<String, RewardedInterstitialAd> rewardedInterstitialAdHashMap = new HashMap();
    private static AppOpenManager appOpenManager;
    private final AtomicBoolean isMobileAdsInitializeCalled = new AtomicBoolean(false);
    private static long hasVideoLocalTime;

    private YouLoftAdManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static YouLoftAdManager getInstance() {
        Class<YouLoftAdManager> clazz = YouLoftAdManager.class;
        synchronized (YouLoftAdManager.class) {
            if (null == instance) {
                instance = new YouLoftAdManager();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private Handler getMainHandler() {
        return new Handler(Looper.getMainLooper());
    }

    public void getADID(final Activity activity) {
        Executors.newSingleThreadExecutor().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    String adid = AdvertisingIdClient.getGoogleAdId((Context)activity);
                    LogUtils.e((String)YouLoftAdManager.TAG, (String)("adid:" + adid));
                    YouLoftAdManager.this.sendMsg("onGetADID", adid);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void initUnityAdSdk(final Activity context, final String jsonAds, final String appId) {
        if (context == null) {
            LogUtils.e((String)TAG, (String)"activity \u4e0d\u80fd\u4e3a\u7a7a");
            return;
        }
        mActivity = context;
        this.rewardedAdHashMap = new HashMap();
        new Handler(context.getMainLooper()).post(new Runnable(){

            @Override
            public void run() {
                try {
                    FireBaseConfigAdsBean baseConfigAdsBean = (FireBaseConfigAdsBean)new Gson().fromJson(jsonAds, FireBaseConfigAdsBean.class);
                    if (baseConfigAdsBean.getBannerIds() != null && !baseConfigAdsBean.getBannerIds().isEmpty()) {
                        YouLoftAdManager.this.bannerAdUnits = new ArrayList<String>();
                        YouLoftAdManager.this.bannerAdUnits.addAll(baseConfigAdsBean.getBannerIds());
                    }
                    if (baseConfigAdsBean.getInterstIds() != null && !baseConfigAdsBean.getInterstIds().isEmpty()) {
                        YouLoftAdManager.this.interstitialAdUnits = new ArrayList<String>();
                        YouLoftAdManager.this.interstitialAdUnits.addAll(baseConfigAdsBean.getInterstIds());
                    }
                    if (baseConfigAdsBean.getVideoIds() != null && !baseConfigAdsBean.getVideoIds().isEmpty()) {
                        YouLoftAdManager.this.rewardedVideoAdUnits = new ArrayList<String>();
                        YouLoftAdManager.this.rewardedVideoAdUnits.addAll(baseConfigAdsBean.getVideoIds());
                    }
                    if (baseConfigAdsBean.getRewardedInterstitiaIds() != null && !baseConfigAdsBean.getRewardedInterstitiaIds().isEmpty()) {
                        YouLoftAdManager.this.rewardedInterstitialAdUnits = new ArrayList<String>();
                        YouLoftAdManager.this.rewardedInterstitialAdUnits.addAll(baseConfigAdsBean.getRewardedInterstitiaIds());
                    }
                    if (baseConfigAdsBean.getOpenIds() != null && !baseConfigAdsBean.getOpenIds().isEmpty()) {
                        YouLoftAdManager.this.openIds = new ArrayList<String>();
                        YouLoftAdManager.this.openIds.addAll(baseConfigAdsBean.getOpenIds());
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    LogUtils.e((String)YouLoftAdManager.TAG, (String)"\u5e7f\u544aID\u7684json\u5b57\u7b26\u4e32\u9519\u8bef");
                }
                if (YouLoftAdManager.this.rewardedVideoAdUnits != null && !YouLoftAdManager.this.rewardedVideoAdUnits.isEmpty()) {
                    YouLoftAdManager.this.sdkInit(context, appId);
                } else if (YouLoftAdManager.this.bannerAdUnits != null && !YouLoftAdManager.this.bannerAdUnits.isEmpty()) {
                    YouLoftAdManager.this.sdkInit(context, appId);
                } else if (YouLoftAdManager.this.interstitialAdUnits != null && !YouLoftAdManager.this.interstitialAdUnits.isEmpty()) {
                    YouLoftAdManager.this.sdkInit(context, appId);
                } else {
                    YouLoftAdManager.this.sdkInit(context, appId);
                }
            }
        });
    }

    public static void setRepeatTime(int repeat) {
        repeatTime = repeat * 1000;
    }

    public void consentInformationReset() {
        if (mActivity == null) {
            LogUtils.e((String)"mActivity is null");
            return;
        }
        ConsentInformation consentInformation = UserMessagingPlatform.getConsentInformation((Context)mActivity);
        consentInformation.reset();
    }

    private void sdkInit(final Activity mContext, final String appId) {
        if (mContext == null) {
            LogUtils.e((String)TAG, (String)"activity \u4e0d\u80fd\u4e3a\u7a7a");
            return;
        }
        ConsentDebugSettings debugSettings = new ConsentDebugSettings.Builder((Context)mActivity).setDebugGeography(1).addTestDeviceHashedId("1DFA3862CDCF294C7944CFE75806F853").build();
        ConsentRequestParameters params = new ConsentRequestParameters.Builder().build();
        final ConsentInformation consentInformation = UserMessagingPlatform.getConsentInformation((Context)mActivity);
        consentInformation.requestConsentInfoUpdate(mActivity, params, new ConsentInformation.OnConsentInfoUpdateSuccessListener(){

            public void onConsentInfoUpdateSuccess() {
                UserMessagingPlatform.loadAndShowConsentFormIfRequired((Activity)mActivity, (ConsentForm.OnConsentFormDismissedListener)new ConsentForm.OnConsentFormDismissedListener(){

                    public void onConsentFormDismissed(@Nullable FormError formError) {
                        if (formError != null) {
                            Log.e((String)YouLoftAdManager.TAG, (String)String.format("%s: %s", formError.getErrorCode(), formError.getMessage()));
                        }
                        if (consentInformation.canRequestAds()) {
                            MetaData ccpaMetaData = new MetaData((Context)mActivity);
                            ccpaMetaData.set("privacy.consent", (Object)true);
                            ccpaMetaData.commit();
                            AppLovinPrivacySettings.setHasUserConsent((boolean)true, (Context)mActivity);
                            AppLovinPrivacySettings.setDoNotSell((boolean)true, (Context)mActivity);
                            IronSource.setConsent((boolean)true);
                            IronSource.setMetaData((String)"do_not_sell", (String)"true");
                            TJPrivacyPolicy privacyPolicy = Tapjoy.getPrivacyPolicy();
                            privacyPolicy.setSubjectToGDPR(true);
                            privacyPolicy.setUserConsent("0");
                            privacyPolicy.setUSPrivacy("1YYY");
                            YouLoftAdManager.this.initAd(mContext, appId);
                        }
                    }
                });
            }
        }, new ConsentInformation.OnConsentInfoUpdateFailureListener(){

            public void onConsentInfoUpdateFailure(@NonNull FormError formError) {
                YouLoftAdManager.this.initAd(mContext, appId);
            }
        });
        if (consentInformation.canRequestAds()) {
            this.initAd(mContext, appId);
        }
    }

    private void initAd(Activity mContext, String appId) {
        if (this.isMobileAdsInitializeCalled.getAndSet(true)) {
            return;
        }
        AppLovinSdk.getInstance((Context)mContext).getSettings().setCreativeDebuggerEnabled(false);
        MobileAds.initialize((Context)mContext);
        appOpenManager = new AppOpenManager(mContext.getApplication());
        if (TextUtils.isEmpty((CharSequence)appId)) {
            return;
        }
    }

    public void fetchAd() {
        if (this.openIds == null || this.openIds.isEmpty()) {
            LogUtils.e((String)"openIds isEmpty ");
            return;
        }
        this.getMainHandler().post(new Runnable(){

            @Override
            public void run() {
                appOpenManager.fetchAd(YouLoftAdManager.this.openIds.get(0));
            }
        });
    }

    public void showAdIfAvailable() {
        this.getMainHandler().post(new Runnable(){

            @Override
            public void run() {
                appOpenManager.showAdIfAvailable();
            }
        });
    }

    private void createAndLoadRewardedAd(final String adUnitId) {
        AdRequest adRequest = new AdRequest.Builder().build();
        RewardedAd.load((Context)mActivity, (String)adUnitId, (AdRequest)adRequest, (RewardedAdLoadCallback)new RewardedAdLoadCallback(){

            public void onAdFailedToLoad(@NonNull LoadAdError loadAdError) {
                Log.d((String)YouLoftAdManager.TAG, (String)loadAdError.getMessage());
                YouLoftAdManager.this.rewardedAdHashMap.put(adUnitId, null);
                Log.d((String)YouLoftAdManager.TAG, (String)("onRewardedVideoLoadFailure" + loadAdError.toString()));
                YouLoftAdManager.this.sendMsg("onRewardedVideoLoadFailure", loadAdError.toString());
                StatisticsManager.customEvent((String)"onRewardedVideoLoadFailure", (String)("{\"adUnitId\":\"" + adUnitId + "\"}"));
                if (YouLoftAdManager.this.mRewardedAdListener != null) {
                    YouLoftAdManager.this.mRewardedAdListener.onRewardedVideoLoadFailure(loadAdError.toString());
                }
            }

            public void onAdLoaded(final @NonNull RewardedAd rewardedAd) {
                YouLoftAdManager.this.rewardedAdHashMap.put(adUnitId, rewardedAd);
                YouLoftAdManager.this.sendMsg("onRewardedVideoLoadSuccess", adUnitId);
                StatisticsManager.customEvent((String)"onRewardedVideoLoadSuccess", (String)("{\"adUnitId\":\"" + adUnitId + "\"}"));
                if (YouLoftAdManager.this.mRewardedAdListener != null) {
                    YouLoftAdManager.this.mRewardedAdListener.onRewardedVideoLoadSuccess();
                }
                LogUtils.d((String)"onRewardedVideoLoadSuccess", (String)adUnitId);
                rewardedAd.setOnPaidEventListener(new OnPaidEventListener(){

                    public void onPaidEvent(AdValue adValue) {
                        Log.d((String)"MyApp", (String)String.format("Paid event of value %d microcents in currency %s of precision %s%n occurred for ad unit %s from ad network %s.", adValue.getValueMicros(), adValue.getCurrencyCode(), adValue.getPrecisionType(), rewardedAd.getAdUnitId(), rewardedAd.getResponseInfo().getMediationAdapterClassName()));
                    }
                });
            }
        });
    }

    public void loadAndShowBannerAd(final int adPosition, int size) {
        if (mActivity == null) {
            LogUtils.e((String)TAG, (String)"activity \u4e0d\u80fd\u4e3a\u7a7a");
            return;
        }
        if (this.bannerAdUnits == null || this.bannerAdUnits.isEmpty()) {
            LogUtils.e((String)TAG, (String)"banner Id\u4e0d\u80fd\u4e3a\u7a7a");
            return;
        }
        this.getMainHandler().post(new Runnable(){

            @Override
            public void run() {
                if (YouLoftAdManager.this.adView == null) {
                    YouLoftAdManager.this.adView = new AdView((Context)mActivity);
                    FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(-2, -2);
                    if (adPosition == 0) {
                        lp.gravity = 0x800033;
                    } else if (adPosition == 1) {
                        lp.gravity = 49;
                    } else if (adPosition == 2) {
                        lp.gravity = 8388661;
                    } else if (adPosition == 3) {
                        lp.gravity = 17;
                    } else if (adPosition == 4) {
                        lp.gravity = 8388691;
                    } else if (adPosition == 5) {
                        lp.gravity = 81;
                    } else if (adPosition == 6) {
                        lp.gravity = 0x800055;
                    }
                    mActivity.addContentView((View)YouLoftAdManager.this.adView, (ViewGroup.LayoutParams)lp);
                    YouLoftAdManager.this.adView.setAdSize(AdSize.BANNER);
                    YouLoftAdManager.this.adView.setAdUnitId(YouLoftAdManager.this.bannerAdUnits.get(YouLoftAdManager.this.bannerIndex));
                }
                YouLoftAdManager.this.adView.setVisibility(0);
                final String adUnitId = YouLoftAdManager.this.bannerAdUnits.get(YouLoftAdManager.this.bannerIndex);
                AdRequest adRequest = new AdRequest.Builder().build();
                YouLoftAdManager.this.adView.loadAd(adRequest);
                ++YouLoftAdManager.this.bannerIndex;
                if (YouLoftAdManager.this.bannerIndex == YouLoftAdManager.this.bannerAdUnits.size()) {
                    YouLoftAdManager.this.bannerIndex = 0;
                }
                YouLoftAdManager.this.adView.setOnPaidEventListener(new OnPaidEventListener(){

                    public void onPaidEvent(@NonNull AdValue adValue) {
                        Bundle bundle = new Bundle();
                        bundle.putDouble("value", (double)adValue.getValueMicros() / 1000000.0);
                        bundle.putString("currency", "USD");
                        bundle.putInt("precisionType", adValue.getPrecisionType());
                        bundle.putString("adNetwork", YouLoftAdManager.this.adView.getResponseInfo().getMediationAdapterClassName());
                        StatisticsManager.fireBaseCustomEvent((String)"Ad_Impression_Revenue", (Bundle)bundle);
                        String currencyCode = adValue.getCurrencyCode();
                        int precision = adValue.getPrecisionType();
                        String adUnitId = YouLoftAdManager.this.adView.getAdUnitId();
                        AdapterResponseInfo loadedAdapterResponseInfo = YouLoftAdManager.this.adView.getResponseInfo().getLoadedAdapterResponseInfo();
                        String adSourceName = loadedAdapterResponseInfo.getAdSourceName();
                        Bundle extras = YouLoftAdManager.this.adView.getResponseInfo().getResponseExtras();
                        String mediationGroupName = extras.getString("mediation_group_name");
                        HashMap<String, String> customParams = new HashMap<String, String>();
                        customParams.put("country", "US");
                        customParams.put("ad_unit", adUnitId);
                        customParams.put("event_revenue_currency", currencyCode);
                        customParams.put("ad_type", AppsFlyerAdNetworkEventType.BANNER.toString());
                        customParams.put("placement", "place");
                        customParams.put("ecpm_payload", "encrypt");
                        customParams.put("precision", String.valueOf(precision));
                        AppsFlyerAdRevenue.logAdRevenue((String)adSourceName, (MediationNetwork)MediationNetwork.googleadmob, (Currency)Currency.getInstance(currencyCode), (Double)((double)adValue.getValueMicros() / 1000000.0), customParams);
                        com.alibaba.fastjson.JSONObject labels = new com.alibaba.fastjson.JSONObject();
                        labels.put("adtype", (Object)0);
                        labels.put("revenue", (Object)((double)adValue.getValueMicros() / 1000000.0));
                        ApiManager.dataReport((String)"adshow", (String)YouLoftAdManager.this.bannerAdUnits.get(0), (String)"\u5e7f\u544a\u5c55\u73b0", (com.alibaba.fastjson.JSONObject)labels);
                    }
                });
                YouLoftAdManager.this.adView.setAdListener(new AdListener(){

                    public void onAdLoaded() {
                        YouLoftAdManager.this.sendMsg("onBannerLoaded", "");
                        StatisticsManager.customEvent((String)"onBannerLoaded", (String)("{\"adUnitId\":\"" + adUnitId + "\"}"));
                        if (YouLoftAdManager.this.mBannerAdListener != null) {
                            YouLoftAdManager.this.mBannerAdListener.onBannerLoaded();
                        }
                    }

                    public void onAdFailedToLoad(LoadAdError adError) {
                        YouLoftAdManager.this.sendMsg("onBannerFailed", adError.toString());
                        StatisticsManager.customEvent((String)"onBannerFailed", (String)("{\"adUnitId\":\"" + adUnitId + "\"}"));
                        if (YouLoftAdManager.this.mBannerAdListener != null) {
                            YouLoftAdManager.this.mBannerAdListener.onBannerFailed(adError.toString());
                        }
                    }

                    public void onAdOpened() {
                    }

                    public void onAdClicked() {
                        YouLoftAdManager.this.sendMsg("onBannerClicked", "");
                        StatisticsManager.customEvent((String)"onBannerClicked", (String)("{\"adUnitId\":\"" + adUnitId + "\"}"));
                        if (YouLoftAdManager.this.mBannerAdListener != null) {
                            YouLoftAdManager.this.mBannerAdListener.onBannerClicked();
                        }
                    }

                    public void onAdClosed() {
                    }
                });
            }
        });
    }

    private void sendMsg(final String s1, final String s2) {
        this.getMainHandler().post(new Runnable(){

            @Override
            public void run() {
                UnityPlayerBridge.sendMsg((String)"PottingMobile", (String)s1, (String)s2);
            }
        });
    }

    private AdSize getAdSize() {
        Display display = mActivity.getWindowManager().getDefaultDisplay();
        DisplayMetrics outMetrics = new DisplayMetrics();
        display.getMetrics(outMetrics);
        float widthPixels = outMetrics.widthPixels;
        float density = outMetrics.density;
        int adWidth = (int)(widthPixels / density);
        return AdSize.getCurrentOrientationAnchoredAdaptiveBannerAdSize((Context)mActivity, (int)adWidth);
    }

    public void hideBannerAd() {
        this.getMainHandler().post(new Runnable(){

            @Override
            public void run() {
                if (YouLoftAdManager.this.adView != null) {
                    YouLoftAdManager.this.adView.setVisibility(8);
                }
            }
        });
    }

    public void setBannerAdListener(BannerAdListener bannerAdListener) {
        this.mBannerAdListener = bannerAdListener;
    }

    public void loadInterstitialAd() {
        if (mActivity == null) {
            LogUtils.e((String)TAG, (String)"activity \u4e0d\u80fd\u4e3a\u7a7a");
            return;
        }
        if (this.interstitialAdUnits == null || this.interstitialAdUnits.isEmpty()) {
            return;
        }
        this.getMainHandler().post(new Runnable(){

            @Override
            public void run() {
                try {
                    final String adUnitId = YouLoftAdManager.this.interstitialAdUnits.get(YouLoftAdManager.this.interstitialIndex);
                    AdRequest adRequest = new AdRequest.Builder().build();
                    InterstitialAd.load((Context)mActivity, (String)adUnitId, (AdRequest)adRequest, (InterstitialAdLoadCallback)new InterstitialAdLoadCallback(){

                        public void onAdLoaded(@NonNull InterstitialAd interstitialAd) {
                            YouLoftAdManager.this.mInterstitialAd = interstitialAd;
                            Log.d((String)YouLoftAdManager.TAG, (String)"onAdLoaded");
                            YouLoftAdManager.this.sendMsg("onInterstitialLoaded", "");
                            StatisticsManager.customEvent((String)"onInterstitialLoaded", (String)("{\"adUnitId\":\"" + adUnitId + "\"}"));
                            if (YouLoftAdManager.this.mInterstitialAdListener != null) {
                                YouLoftAdManager.this.mInterstitialAdListener.onInterstitialLoaded();
                            }
                        }

                        public void onAdFailedToLoad(@NonNull LoadAdError loadAdError) {
                            Log.i((String)YouLoftAdManager.TAG, (String)loadAdError.getMessage());
                            YouLoftAdManager.this.mInterstitialAd = null;
                            YouLoftAdManager.this.sendMsg("onInterstitialFailed", loadAdError.toString());
                            StatisticsManager.customEvent((String)"onInterstitialFailed", (String)("{\"adUnitId\":\"" + adUnitId + "\"}"));
                            if (YouLoftAdManager.this.mInterstitialAdListener != null) {
                                YouLoftAdManager.this.mInterstitialAdListener.onInterstitialFailed(loadAdError.toString());
                            }
                        }
                    });
                    ++YouLoftAdManager.this.interstitialIndex;
                    if (YouLoftAdManager.this.interstitialIndex == YouLoftAdManager.this.interstitialAdUnits.size()) {
                        YouLoftAdManager.this.interstitialIndex = 0;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    YouLoftAdManager.this.sendMsg("onInterstitialFailed", e.getMessage());
                    StatisticsManager.customEvent((String)"onInterstitialFailed", (String)("{\"adUnitId\":\"" + YouLoftAdManager.this.interstitialAdUnits.get(YouLoftAdManager.this.interstitialIndex) + "\"}"));
                }
            }
        });
    }

    public void showInterstitialAd() {
        if (mActivity == null) {
            LogUtils.e((String)TAG, (String)"activity \u4e0d\u80fd\u4e3a\u7a7a");
            return;
        }
        if (this.interstitialAdUnits == null || this.interstitialAdUnits.isEmpty()) {
            LogUtils.e((String)TAG, (String)mActivity.getString(R.string.no_interstitial));
            return;
        }
        this.getMainHandler().post(new Runnable(){

            @Override
            public void run() {
                if (YouLoftAdManager.this.mInterstitialAd != null) {
                    YouLoftAdManager.this.mInterstitialAd.setFullScreenContentCallback(new FullScreenContentCallback(){

                        public void onAdDismissedFullScreenContent() {
                            Log.d((String)"TAG", (String)"The ad was dismissed.");
                            YouLoftAdManager.this.sendMsg("onInterstitialDismissed", "");
                            StatisticsManager.customEvent((String)"onInterstitialDismissed", (String)("{\"adUnitId\":\"" + YouLoftAdManager.this.mInterstitialAd.getAdUnitId() + "\"}"));
                            if (YouLoftAdManager.this.mInterstitialAdListener != null) {
                                YouLoftAdManager.this.mInterstitialAdListener.onInterstitialDismissed();
                            }
                        }

                        public void onAdFailedToShowFullScreenContent(AdError adError) {
                            Log.d((String)"TAG", (String)"The ad failed to show.");
                            StatisticsManager.customEvent((String)"onInterstitialFailedToShow", (String)("{\"adUnitId\":\"" + YouLoftAdManager.this.mInterstitialAd.getAdUnitId() + "\"}"));
                        }

                        public void onAdShowedFullScreenContent() {
                            Log.d((String)"TAG", (String)"The ad was shown.");
                            YouLoftAdManager.this.sendMsg("onInterstitialShown", "");
                            StatisticsManager.customEvent((String)"onInterstitialShown", (String)("{\"adUnitId\":\"" + YouLoftAdManager.this.mInterstitialAd.getAdUnitId() + "\"}"));
                            if (YouLoftAdManager.this.mInterstitialAdListener != null) {
                                YouLoftAdManager.this.mInterstitialAdListener.onInterstitialShown();
                            }
                            YouLoftAdManager.this.loadInterstitialAd();
                        }
                    });
                    YouLoftAdManager.this.mInterstitialAd.setOnPaidEventListener(new OnPaidEventListener(){

                        public void onPaidEvent(@NonNull AdValue adValue) {
                            Bundle bundle = new Bundle();
                            bundle.putDouble("value", (double)adValue.getValueMicros() / 1000000.0);
                            bundle.putString("currency", "USD");
                            bundle.putInt("precisionType", adValue.getPrecisionType());
                            bundle.putString("adNetwork", YouLoftAdManager.this.mInterstitialAd.getResponseInfo().getMediationAdapterClassName());
                            StatisticsManager.fireBaseCustomEvent((String)"Ad_Impression_Revenue", (Bundle)bundle);
                            String currencyCode = adValue.getCurrencyCode();
                            int precision = adValue.getPrecisionType();
                            String adUnitId = YouLoftAdManager.this.mInterstitialAd.getAdUnitId();
                            AdapterResponseInfo loadedAdapterResponseInfo = YouLoftAdManager.this.mInterstitialAd.getResponseInfo().getLoadedAdapterResponseInfo();
                            String adSourceName = loadedAdapterResponseInfo.getAdSourceName();
                            Bundle extras = YouLoftAdManager.this.mInterstitialAd.getResponseInfo().getResponseExtras();
                            String mediationGroupName = extras.getString("mediation_group_name");
                            HashMap<String, String> customParams = new HashMap<String, String>();
                            customParams.put("country", "US");
                            customParams.put("event_revenue_currency", currencyCode);
                            customParams.put("ad_unit", adUnitId);
                            customParams.put("ad_type", AppsFlyerAdNetworkEventType.INTERSTITIAL.toString());
                            customParams.put("placement", "place");
                            customParams.put("ecpm_payload", "encrypt");
                            customParams.put("precision", String.valueOf(precision));
                            AppsFlyerAdRevenue.logAdRevenue((String)adSourceName, (MediationNetwork)MediationNetwork.googleadmob, (Currency)Currency.getInstance(currencyCode), (Double)((double)adValue.getValueMicros() / 1000000.0), customParams);
                            com.alibaba.fastjson.JSONObject labels = new com.alibaba.fastjson.JSONObject();
                            labels.put("adtype", (Object)1);
                            labels.put("revenue", (Object)((double)adValue.getValueMicros() / 1000000.0));
                            ApiManager.dataReport((String)"adshow", (String)YouLoftAdManager.this.interstitialAdUnits.get(0), (String)"\u5e7f\u544a\u5c55\u73b0", (com.alibaba.fastjson.JSONObject)labels);
                        }
                    });
                    YouLoftAdManager.this.mInterstitialAd.show(mActivity);
                } else {
                    Log.d((String)YouLoftAdManager.TAG, (String)"The interstitial wasn't loaded yet.");
                    YouLoftAdManager.this.loadInterstitialAd();
                }
            }
        });
    }

    public void setInterstitialAdListener(InterstitialAdListener interstitialAdListener) {
        this.mInterstitialAdListener = interstitialAdListener;
    }

    public void loadRewardedVideoAd() {
        if (mActivity == null) {
            LogUtils.e((String)TAG, (String)"activity \u4e0d\u80fd\u4e3a\u7a7a");
            return;
        }
        if (this.rewardedVideoAdUnits == null || this.rewardedVideoAdUnits.isEmpty()) {
            LogUtils.e((String)TAG, (String)mActivity.getString(R.string.no_rewarded_video));
            return;
        }
        YouLoftAdManager.getInstance().autoLoadRewardedVideoAd();
    }

    public void loadRewardedVideoAd(final String id) {
        if (mActivity == null) {
            LogUtils.e((String)TAG, (String)"activity \u4e0d\u80fd\u4e3a\u7a7a");
            return;
        }
        if (this.rewardedVideoAdUnits == null || this.rewardedVideoAdUnits.isEmpty()) {
            LogUtils.e((String)TAG, (String)mActivity.getString(R.string.no_rewarded_video));
            return;
        }
        if (this.rewardedAdHashMap == null) {
            return;
        }
        this.getMainHandler().post(new Runnable(){

            @Override
            public void run() {
                if (YouLoftAdManager.this.rewardedAdHashMap.get(id) == null) {
                    YouLoftAdManager.this.createAndLoadRewardedAd(id);
                }
            }
        });
    }

    public boolean hasRewardedVideo() {
        int i;
        if (this.rewardedVideoAdUnits == null || this.rewardedVideoAdUnits.isEmpty() || this.rewardedAdHashMap.isEmpty()) {
            return false;
        }
        JSONObject jsonObject = new JSONObject();
        for (i = 0; i < this.rewardedVideoAdUnits.size(); ++i) {
            if (this.rewardedAdHashMap.size() > i && this.rewardedAdHashMap.get(this.rewardedVideoAdUnits.get(i)) != null) {
                try {
                    jsonObject.put(this.rewardedVideoAdUnits.get(i), true);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                continue;
            }
            try {
                jsonObject.put(this.rewardedVideoAdUnits.get(i), false);
                continue;
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        if (System.currentTimeMillis() - hasVideoLocalTime > 1000L) {
            this.sendMsg("hasRewardedVideo", jsonObject.toString());
            hasVideoLocalTime = System.currentTimeMillis();
        }
        for (i = 0; i < this.rewardedVideoAdUnits.size(); ++i) {
            if (this.rewardedAdHashMap.size() <= i || this.rewardedAdHashMap.get(this.rewardedVideoAdUnits.get(i)) == null) continue;
            return true;
        }
        return false;
    }

    public boolean hasRewardedVideo(String adId) {
        if (this.rewardedAdHashMap == null) {
            return false;
        }
        if (this.rewardedAdHashMap.size() <= 0) {
            return false;
        }
        return this.rewardedAdHashMap.get(adId) != null;
    }

    public boolean hasRewardedInterstitial(String adId) {
        if (this.rewardedInterstitialAdHashMap == null) {
            return false;
        }
        if (this.rewardedInterstitialAdHashMap.size() <= 0) {
            return false;
        }
        return this.rewardedInterstitialAdHashMap.get(adId) != null;
    }

    public void showRewardedVideoAd() {
        this.getMainHandler().post(new Runnable(){

            @Override
            public void run() {
                LogUtils.d((String)"\u64ad\u653e\u89c6\u9891---------------");
                if (mActivity == null) {
                    LogUtils.e((String)YouLoftAdManager.TAG, (String)"activity \u4e0d\u80fd\u4e3a\u7a7a");
                    return;
                }
                if (YouLoftAdManager.this.rewardedVideoAdUnits == null || YouLoftAdManager.this.rewardedVideoAdUnits.isEmpty()) {
                    LogUtils.e((String)YouLoftAdManager.TAG, (String)mActivity.getString(R.string.no_rewarded_video));
                    return;
                }
                if (YouLoftAdManager.this.rewardedAdHashMap == null || YouLoftAdManager.this.rewardedAdHashMap.size() <= 0) {
                    LogUtils.e((String)YouLoftAdManager.TAG, (String)mActivity.getString(R.string.no_rewarded_video));
                    return;
                }
                for (String rewardedVideoAdUnit : YouLoftAdManager.this.rewardedVideoAdUnits) {
                    if (!YouLoftAdManager.this.hasRewardedVideo(rewardedVideoAdUnit)) continue;
                    YouLoftAdManager.this.showRewardedVideoAd(rewardedVideoAdUnit);
                    break;
                }
            }
        });
    }

    public void showRewardedVideoAd(final String adUnitID) {
        LogUtils.d((String)("\u64ad\u653e\u89c6\u9891---------------" + adUnitID));
        if (mActivity == null) {
            LogUtils.e((String)TAG, (String)"activity \u4e0d\u80fd\u4e3a\u7a7a");
            return;
        }
        if (this.rewardedVideoAdUnits == null || this.rewardedVideoAdUnits.isEmpty()) {
            LogUtils.e((String)TAG, (String)mActivity.getString(R.string.no_rewarded_video));
            return;
        }
        this.getMainHandler().post(new Runnable(){

            @Override
            public void run() {
                if (YouLoftAdManager.this.rewardedAdHashMap.isEmpty()) {
                    return;
                }
                final RewardedAd rewardedAd = YouLoftAdManager.this.rewardedAdHashMap.get(adUnitID);
                if (rewardedAd == null) {
                    LogUtils.e((String)"The rewarded ad wasn't ready yet.");
                    return;
                }
                Activity activityContext = mActivity;
                rewardedAd.setOnPaidEventListener(new OnPaidEventListener(){

                    public void onPaidEvent(@NonNull AdValue adValue) {
                        Bundle bundle = new Bundle();
                        bundle.putDouble("value", (double)adValue.getValueMicros() / 1000000.0);
                        bundle.putString("currency", "USD");
                        bundle.putInt("precisionType", adValue.getPrecisionType());
                        bundle.putString("adNetwork", rewardedAd.getResponseInfo().getMediationAdapterClassName());
                        StatisticsManager.fireBaseCustomEvent((String)"Ad_Impression_Revenue", (Bundle)bundle);
                        String currencyCode = adValue.getCurrencyCode();
                        int precision = adValue.getPrecisionType();
                        String adUnitId = rewardedAd.getAdUnitId();
                        AdapterResponseInfo loadedAdapterResponseInfo = rewardedAd.getResponseInfo().getLoadedAdapterResponseInfo();
                        String adSourceName = loadedAdapterResponseInfo.getAdSourceName();
                        Bundle extras = rewardedAd.getResponseInfo().getResponseExtras();
                        String mediationGroupName = extras.getString("mediation_group_name");
                        HashMap<String, String> customParams = new HashMap<String, String>();
                        customParams.put("country", "US");
                        customParams.put("event_revenue_currency", currencyCode);
                        customParams.put("ad_unit", adUnitId);
                        customParams.put("ad_type", AppsFlyerAdNetworkEventType.REWARDED.toString());
                        customParams.put("placement", "place");
                        customParams.put("ecpm_payload", "encrypt");
                        customParams.put("precision", String.valueOf(precision));
                        customParams.put("cry", currencyCode);
                        AppsFlyerAdRevenue.logAdRevenue((String)adSourceName, (MediationNetwork)MediationNetwork.googleadmob, (Currency)Currency.getInstance(currencyCode), (Double)((double)adValue.getValueMicros() / 1000000.0), customParams);
                        com.alibaba.fastjson.JSONObject labels = new com.alibaba.fastjson.JSONObject();
                        labels.put("adtype", (Object)2);
                        labels.put("revenue", (Object)((double)adValue.getValueMicros() / 1000000.0));
                        ApiManager.dataReport((String)"adshow", (String)adUnitID, (String)"\u5e7f\u544a\u5c55\u73b0", (com.alibaba.fastjson.JSONObject)labels);
                    }
                });
                rewardedAd.setFullScreenContentCallback(new FullScreenContentCallback(){

                    public void onAdShowedFullScreenContent() {
                        YouLoftAdManager.this.sendMsg("onRewardedVideoStarted", adUnitID);
                        StatisticsManager.customEvent((String)"onRewardedVideoStarted", (String)("{\"adUnitId\":\"" + adUnitID + "\"}"));
                        if (YouLoftAdManager.this.mRewardedAdListener != null) {
                            YouLoftAdManager.this.mRewardedAdListener.onRewardedVideoStarted();
                        }
                        YouLoftAdManager.this.rewardedAdHashMap.put(adUnitID, null);
                        new Handler().postDelayed(new Runnable(){

                            @Override
                            public void run() {
                                YouLoftAdManager.this.createAndLoadRewardedAd(adUnitID);
                            }
                        }, 3000L);
                        AppsFlyerLib.getInstance().logEvent((Context)mActivity, "af_ad_view", null);
                    }

                    public void onAdFailedToShowFullScreenContent(AdError adError) {
                        YouLoftAdManager.this.sendMsg("onRewardedVideoPlaybackError", adError.toString());
                        StatisticsManager.customEvent((String)"onRewardedVideoPlaybackError", (String)("{\"adUnitId\":\"" + adUnitID + "\"}"));
                        if (YouLoftAdManager.this.mRewardedAdListener != null) {
                            YouLoftAdManager.this.mRewardedAdListener.onRewardedVideoLoadFailure(adError.toString());
                        }
                        YouLoftAdManager.this.rewardedAdHashMap.put(adUnitID, null);
                    }

                    public void onAdDismissedFullScreenContent() {
                        LogUtils.d((String)"onRewardedAdClosed");
                        YouLoftAdManager.this.sendMsg("onRewardedVideoClosed", adUnitID);
                        StatisticsManager.customEvent((String)"onRewardedVideoClosed", (String)("{\"adUnitId\":\"" + adUnitID + "\"}"));
                        if (YouLoftAdManager.this.mRewardedAdListener != null) {
                            YouLoftAdManager.this.mRewardedAdListener.onRewardedVideoClosed();
                        }
                    }
                });
                rewardedAd.show(activityContext, new OnUserEarnedRewardListener(){

                    public void onUserEarnedReward(@NonNull RewardItem rewardItem) {
                        ResponseInfo responseInfo;
                        YouLoftAdManager.this.sendMsg("onRewardedVideoCompleted", adUnitID);
                        LogUtils.d((String)adUnitID);
                        StatisticsManager.customEvent((String)"onRewardedVideoCompleted", (String)("{\"sourceId\":\"" + adUnitID + "\"}"));
                        if (YouLoftAdManager.this.mRewardedAdListener != null) {
                            YouLoftAdManager.this.mRewardedAdListener.onRewardedVideoCompleted();
                        }
                        if ((responseInfo = rewardedAd.getResponseInfo()) != null) {
                            StatisticsManager.customEventAf((String)"admobAddata", (String)responseInfo.toString());
                        }
                    }
                });
            }
        });
    }

    public void setRewardedAdListener(RewardedAdListener rewardedAdListener) {
        this.mRewardedAdListener = rewardedAdListener;
    }

    public void setRewardedInterstitialAdListener(RewardedInterstitialAdListener rewardedInterstitialAdListener) {
        this.mRewardedInterstitialAdListener = rewardedInterstitialAdListener;
    }

    public void loadRewardedInterstitialAd() {
        if (mActivity == null) {
            LogUtils.e((String)TAG, (String)"activity \u4e0d\u80fd\u4e3a\u7a7a");
            return;
        }
        if (this.rewardedInterstitialAdUnits == null || this.rewardedInterstitialAdUnits.isEmpty()) {
            LogUtils.e((String)TAG, (String)"\u672a\u914d\u7f6e\u6fc0\u52b1\u63d2\u5c4f\u5e7f\u544a");
            return;
        }
        this.getMainHandler().post(new Runnable(){

            @Override
            public void run() {
                if (mActivity == null) {
                    LogUtils.e((String)YouLoftAdManager.TAG, (String)"activity \u4e0d\u80fd\u4e3a\u7a7a");
                    return;
                }
                if (YouLoftAdManager.this.rewardedInterstitialAdUnits == null || YouLoftAdManager.this.rewardedInterstitialAdUnits.isEmpty()) {
                    LogUtils.e((String)YouLoftAdManager.TAG, (String)"\u672a\u914d\u7f6e\u6fc0\u52b1\u63d2\u5c4f\u5e7f\u544a");
                    return;
                }
                LogUtils.d((String)YouLoftAdManager.TAG, (String)"\u5f00\u59cb\u81ea\u52a8\u68c0\u67e5\u662f\u5426\u5b58\u5728\u5df2\u7ecf\u7f13\u5b58\u597d\u7684\u6fc0\u52b1\u63d2\u5c4f\u5e7f\u544a");
                long nowTime = System.currentTimeMillis();
                boolean isLoad = nowTime - localTime > maxValidateTime;
                LogUtils.d((String)YouLoftAdManager.TAG, (String)"\u5f00\u59cb\u81ea\u52a8\u7f13\u5b58\u6fc0\u52b1\u63d2\u5c4f\u5e7f\u544a");
                for (int i = 0; i < YouLoftAdManager.this.rewardedInterstitialAdUnits.size(); ++i) {
                    final String adUnit = YouLoftAdManager.this.rewardedInterstitialAdUnits.get(i);
                    RewardedInterstitialAd rewardedAd = YouLoftAdManager.this.rewardedInterstitialAdHashMap.get(adUnit);
                    if (rewardedAd != null && !isLoad) continue;
                    localTime = System.currentTimeMillis();
                    RewardedInterstitialAd.load((Context)mActivity, (String)adUnit, (AdRequest)new AdRequest.Builder().build(), (RewardedInterstitialAdLoadCallback)new RewardedInterstitialAdLoadCallback(){

                        public void onAdLoaded(RewardedInterstitialAd ad) {
                            YouLoftAdManager.this.rewardedInterstitialAdHashMap.put(adUnit, ad);
                            Log.d((String)YouLoftAdManager.TAG, (String)"onRewardedInterstitialAdLoaded");
                            YouLoftAdManager.this.sendMsg("rewardedInterstitialDidLoadAd", adUnit);
                            if (YouLoftAdManager.this.mRewardedInterstitialAdListener != null) {
                                YouLoftAdManager.this.mRewardedInterstitialAdListener.onAdLoaded();
                            }
                        }

                        public void onAdFailedToLoad(LoadAdError loadAdError) {
                            Log.e((String)YouLoftAdManager.TAG, (String)"onRewardedInterstitialAdFailedToLoad");
                            YouLoftAdManager.this.sendMsg("rewardedInterstitialDidFailToLoadWithMsg", loadAdError.getMessage());
                            if (YouLoftAdManager.this.mRewardedInterstitialAdListener != null) {
                                YouLoftAdManager.this.mRewardedInterstitialAdListener.onAdFailedToLoad(loadAdError);
                            }
                            YouLoftAdManager.this.rewardedInterstitialAdHashMap.put(adUnit, null);
                        }
                    });
                }
            }
        });
    }

    public void showRewardedInterstitialAd() {
        this.getMainHandler().post(new Runnable(){

            @Override
            public void run() {
                LogUtils.d((String)"\u64ad\u653e\u6fc0\u52b1\u63d2\u5c4f---------------");
                if (mActivity == null) {
                    LogUtils.e((String)YouLoftAdManager.TAG, (String)"activity \u4e0d\u80fd\u4e3a\u7a7a");
                    return;
                }
                if (YouLoftAdManager.this.rewardedInterstitialAdUnits == null || YouLoftAdManager.this.rewardedInterstitialAdUnits.isEmpty()) {
                    LogUtils.e((String)YouLoftAdManager.TAG, (String)"\u672a\u914d\u7f6e\u6fc0\u52b1\u63d2\u5c4f");
                    return;
                }
                if (YouLoftAdManager.this.rewardedInterstitialAdHashMap == null || YouLoftAdManager.this.rewardedInterstitialAdHashMap.size() <= 0) {
                    LogUtils.e((String)YouLoftAdManager.TAG, (String)"\u65e0\u7f13\u5b58\u6fc0\u52b1\u63d2\u5c4f");
                    return;
                }
                for (final String adUnit : YouLoftAdManager.this.rewardedInterstitialAdUnits) {
                    if (!YouLoftAdManager.this.hasRewardedInterstitial(adUnit)) continue;
                    final RewardedInterstitialAd rewardedInterstitialAd = YouLoftAdManager.this.rewardedInterstitialAdHashMap.get(adUnit);
                    if (rewardedInterstitialAd == null) break;
                    rewardedInterstitialAd.setFullScreenContentCallback(new FullScreenContentCallback(){

                        public void onAdFailedToShowFullScreenContent(@NonNull AdError adError) {
                            super.onAdFailedToShowFullScreenContent(adError);
                            YouLoftAdManager.this.sendMsg("rewardedInterstitialAdDidFailToPlayWithMsg", adError.getMessage());
                            if (YouLoftAdManager.this.mRewardedInterstitialAdListener != null) {
                                YouLoftAdManager.this.mRewardedInterstitialAdListener.onAdFailedToShowFullScreenContent(adError);
                            }
                            YouLoftAdManager.this.rewardedInterstitialAdHashMap.put(adUnit, null);
                        }

                        public void onAdShowedFullScreenContent() {
                            super.onAdShowedFullScreenContent();
                            YouLoftAdManager.this.sendMsg("rewardedInterstitialDidAppear", adUnit);
                            if (YouLoftAdManager.this.mRewardedInterstitialAdListener != null) {
                                YouLoftAdManager.this.mRewardedInterstitialAdListener.onAdShowedFullScreenContent();
                            }
                        }

                        public void onAdDismissedFullScreenContent() {
                            super.onAdDismissedFullScreenContent();
                            YouLoftAdManager.this.sendMsg("rewardedInterstitialDidDisappear", adUnit);
                            if (YouLoftAdManager.this.mRewardedInterstitialAdListener != null) {
                                YouLoftAdManager.this.mRewardedInterstitialAdListener.onAdDismissedFullScreenContent();
                            }
                            YouLoftAdManager.this.rewardedInterstitialAdHashMap.put(adUnit, null);
                            YouLoftAdManager.this.loadRewardedInterstitialAd();
                        }

                        public void onAdImpression() {
                            super.onAdImpression();
                        }
                    });
                    rewardedInterstitialAd.setOnPaidEventListener(new OnPaidEventListener(){

                        public void onPaidEvent(@NonNull AdValue adValue) {
                            Bundle bundle = new Bundle();
                            bundle.putDouble("value", (double)adValue.getValueMicros() / 1000000.0);
                            bundle.putString("currency", "USD");
                            bundle.putInt("precisionType", adValue.getPrecisionType());
                            bundle.putString("adNetwork", rewardedInterstitialAd.getResponseInfo().getMediationAdapterClassName());
                            StatisticsManager.fireBaseCustomEvent((String)"Ad_Impression_Revenue", (Bundle)bundle);
                            HashMap<String, Object> maps = new HashMap<String, Object>();
                            maps.put("af_currency", "USD");
                            maps.put("af_revenue", (double)adValue.getValueMicros() / 1000000.0);
                            AppsFlyerLib.getInstance().logEvent(ApiManager.getContext().getApplicationContext(), "youloft_adshow_pagevideo", maps);
                            String currencyCode = adValue.getCurrencyCode();
                            int precision = adValue.getPrecisionType();
                            String adUnitId = rewardedInterstitialAd.getAdUnitId();
                            AdapterResponseInfo loadedAdapterResponseInfo = rewardedInterstitialAd.getResponseInfo().getLoadedAdapterResponseInfo();
                            String adSourceName = loadedAdapterResponseInfo.getAdSourceName();
                            Bundle extras = rewardedInterstitialAd.getResponseInfo().getResponseExtras();
                            String mediationGroupName = extras.getString("mediation_group_name");
                            HashMap<String, String> customParams = new HashMap<String, String>();
                            customParams.put("country", "US");
                            customParams.put("event_revenue_currency", currencyCode);
                            customParams.put("ad_unit", adUnitId);
                            customParams.put("ad_type", "rewardedInterstitialAd");
                            customParams.put("placement", "place");
                            customParams.put("ecpm_payload", "encrypt");
                            customParams.put("precision", String.valueOf(precision));
                            AppsFlyerAdRevenue.logAdRevenue((String)adSourceName, (MediationNetwork)MediationNetwork.googleadmob, (Currency)Currency.getInstance(currencyCode), (Double)((double)adValue.getValueMicros() / 1000000.0), customParams);
                            com.alibaba.fastjson.JSONObject labels = new com.alibaba.fastjson.JSONObject();
                            labels.put("adtype", (Object)4);
                            labels.put("revenue", (Object)((double)adValue.getValueMicros() / 1000000.0));
                            ApiManager.dataReport((String)"adshow", (String)rewardedInterstitialAd.getAdUnitId(), (String)"\u5e7f\u544a\u5c55\u73b0", (com.alibaba.fastjson.JSONObject)labels);
                        }
                    });
                    rewardedInterstitialAd.show(mActivity, new OnUserEarnedRewardListener(){

                        public void onUserEarnedReward(@NonNull RewardItem rewardItem) {
                            YouLoftAdManager.this.sendMsg("rewardedInterstitialAdShouldReward", adUnit);
                            if (YouLoftAdManager.this.mRewardedInterstitialAdListener != null) {
                                YouLoftAdManager.this.mRewardedInterstitialAdListener.onUserEarnedReward(rewardItem);
                            }
                        }
                    });
                    break;
                }
            }
        });
    }

    public void autoLoad() {
        if (mActivity == null) {
            LogUtils.e((String)TAG, (String)"activity \u4e0d\u80fd\u4e3a\u7a7a");
            return;
        }
        this.mHandler = new Handler();
        this.runnable = new Runnable(){

            @Override
            public void run() {
                if (YouLoftAdManager.this.rewardedVideoAdUnits == null || YouLoftAdManager.this.rewardedVideoAdUnits.isEmpty()) {
                    LogUtils.e((String)YouLoftAdManager.TAG, (String)mActivity.getString(R.string.no_rewarded_video));
                } else {
                    YouLoftAdManager.this.autoLoadRewardedVideoAd();
                }
                if (YouLoftAdManager.this.rewardedInterstitialAdUnits != null && !YouLoftAdManager.this.rewardedInterstitialAdUnits.isEmpty()) {
                    YouLoftAdManager.this.loadRewardedInterstitialAd();
                }
                if (YouLoftAdManager.this.interstitialAdUnits == null || YouLoftAdManager.this.interstitialAdUnits.isEmpty()) {
                    LogUtils.e((String)YouLoftAdManager.TAG, (String)mActivity.getString(R.string.no_interstitial));
                } else {
                    YouLoftAdManager.this.loadInterstitialAd();
                }
                if (YouLoftAdManager.this.openIds == null || YouLoftAdManager.this.openIds.isEmpty()) {
                    LogUtils.e((String)YouLoftAdManager.TAG, (String)"\u672a\u914d\u7f6eopen\u5e7f\u544a");
                } else {
                    YouLoftAdManager.this.fetchAd();
                }
                YouLoftAdManager.this.mHandler.postDelayed(YouLoftAdManager.this.runnable, repeatTime);
            }
        };
        this.mHandler.postDelayed(this.runnable, 0L);
    }

    private void autoLoadRewardedVideoAd() {
        this.getMainHandler().post(new Runnable(){

            @Override
            public void run() {
                if (mActivity == null) {
                    LogUtils.e((String)YouLoftAdManager.TAG, (String)"activity \u4e0d\u80fd\u4e3a\u7a7a");
                    return;
                }
                if (YouLoftAdManager.this.rewardedVideoAdUnits == null || YouLoftAdManager.this.rewardedVideoAdUnits.isEmpty()) {
                    LogUtils.e((String)YouLoftAdManager.TAG, (String)mActivity.getString(R.string.no_rewarded_video));
                    return;
                }
                LogUtils.d((String)YouLoftAdManager.TAG, (String)"\u5f00\u59cb\u81ea\u52a8\u68c0\u67e5\u662f\u5426\u5b58\u5728\u5df2\u7ecf\u7f13\u5b58\u597d\u7684\u89c6\u9891\u5e7f\u544a");
                long nowTime = System.currentTimeMillis();
                boolean isLoad = nowTime - localTime > maxValidateTime;
                LogUtils.d((String)YouLoftAdManager.TAG, (String)"\u5f00\u59cb\u81ea\u52a8\u7f13\u5b58\u89c6\u9891\u5e7f\u544a");
                for (int i = 0; i < YouLoftAdManager.this.rewardedVideoAdUnits.size(); ++i) {
                    RewardedAd rewardedAd = YouLoftAdManager.this.rewardedAdHashMap.get(YouLoftAdManager.this.rewardedVideoAdUnits.get(i));
                    if (rewardedAd != null && !isLoad) continue;
                    localTime = System.currentTimeMillis();
                    YouLoftAdManager.this.createAndLoadRewardedAd(YouLoftAdManager.this.rewardedVideoAdUnits.get(i));
                }
            }
        });
    }

    public static void onMopubResume() {
        if (mActivity == null) {
            return;
        }
        IronSource.onResume((Activity)mActivity);
        com.alibaba.fastjson.JSONObject labels = new com.alibaba.fastjson.JSONObject();
        ApiManager.dataReport((String)"active", (String)"", (String)"active", (com.alibaba.fastjson.JSONObject)labels);
    }

    public static void onMopubPause() {
        if (mActivity == null) {
            return;
        }
        IronSource.onPause((Activity)mActivity);
        com.alibaba.fastjson.JSONObject labels = new com.alibaba.fastjson.JSONObject();
        ApiManager.dataReport((String)"inactive", (String)"", (String)"inactive", (com.alibaba.fastjson.JSONObject)labels);
    }

    public static void setLogEnable(boolean enable) {
        LogUtils.setLogEnable((boolean)enable);
    }

    static {
        hasVideoLocalTime = System.currentTimeMillis();
    }
}

